/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.FileImpl;
import java.io.File;
import org.apache.tools.ant.DirectoryScanner;

public class TextReplacer {
    private static FileImpl _fileUtil = FileImpl.getInstance();

    public static void main(String[] args) {
        String dirs = System.getProperty("text.replacer.dirs");
        String includes = System.getProperty("text.replacer.includes");
        String excludes = System.getProperty("text.replacer.excludes");
        String tokenFile = System.getProperty("text.replacer.token.file");
        String valueFile = System.getProperty("text.replacer.value.file");
        new TextReplacer(dirs, includes, excludes, tokenFile, valueFile);
    }

    public TextReplacer(String dirs, String includes, String excludes, String tokenFile, String valueFile) {
        try {
            String token = _fileUtil.read(tokenFile);
            if (token == null) {
                System.out.println(String.valueOf(tokenFile) + " does not exist");
                return;
            }
            String value = _fileUtil.read(valueFile);
            if (value == null) {
                System.out.println(String.valueOf(valueFile) + " does not exist");
                return;
            }
            String[] stringArray = StringUtil.split((String)dirs);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String dir = stringArray[n2];
                if (!dir.endsWith("/")) {
                    dir = String.valueOf(dir) + "/";
                }
                if (!_fileUtil.exists(dir)) {
                    System.out.println(String.valueOf(dir) + " does not exist");
                } else {
                    DirectoryScanner directoryScanner = new DirectoryScanner();
                    directoryScanner.setBasedir(dir);
                    directoryScanner.setIncludes(StringUtil.split((String)includes));
                    directoryScanner.setExcludes(StringUtil.split((String)excludes));
                    directoryScanner.scan();
                    String[] stringArray2 = directoryScanner.getIncludedFiles();
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String newContent;
                        String fileName = stringArray2[n4];
                        File file = new File(String.valueOf(dir) + fileName);
                        String content = _fileUtil.read(file);
                        if (!content.equals(newContent = StringUtil.replace((String)content, (String)token, (String)value))) {
                            _fileUtil.write(file, newContent);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

