/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.tools.ComparableRoute;
import com.liferay.portal.tools.SourceFormatterHelper;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.xml.SAXReaderImpl;
import com.liferay.util.ContentUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFormatter {
    private static final String[] _TAG_LIBRARIES = new String[]{"aui", "c", "html", "jsp", "liferay-portlet", "liferay-security", "liferay-theme", "liferay-ui", "liferay-util", "portlet", "struts", "tiles"};
    private static String[] _excludes;
    private static Properties _exclusionsProperties;
    private static FileImpl _fileUtil;
    private static Pattern _javaImportPattern;
    private static Map<String, String> _jspContents;
    private static Pattern _jspImportPattern;
    private static Pattern _jspIncludeFilePattern;
    private static SAXReaderImpl _saxReaderUtil;
    private static SourceFormatterHelper _sourceFormatterHelper;
    private static Pattern _xssPattern;

    static {
        _fileUtil = FileImpl.getInstance();
        _javaImportPattern = Pattern.compile("(^[ \t]*import\\s+.*;\n+)+", 8);
        _jspContents = new HashMap<String, String>();
        _jspImportPattern = Pattern.compile("(<.*\n*page.import=\".*>\n*)+", 8);
        _jspIncludeFilePattern = Pattern.compile("/.*[.]jsp[f]?");
        _saxReaderUtil = SAXReaderImpl.getInstance();
        _xssPattern = Pattern.compile("String\\s+([^\\s]+)\\s*=\\s*(Bean)?ParamUtil\\.getString\\(");
    }

    public static void main(String[] args) {
        try {
            _excludes = StringUtil.split((String)GetterUtil.getString((String)System.getProperty("source.formatter.excludes")));
            _sourceFormatterHelper = new SourceFormatterHelper(false);
            _sourceFormatterHelper.init();
            SourceFormatter._readExclusions();
            Thread thread1 = new Thread(){

                public void run() {
                    try {
                        SourceFormatter._checkPersistenceTestSuite();
                        SourceFormatter._formatJSP();
                        SourceFormatter._formatAntXML();
                        SourceFormatter._formatDDLStructuresXML();
                        SourceFormatter._formatFriendlyURLRoutesXML();
                        SourceFormatter._formatPortletXML();
                        SourceFormatter._formatSH();
                        SourceFormatter._formatWebXML();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            Thread thread2 = new Thread(){

                public void run() {
                    try {
                        SourceFormatter._formatJava();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            thread1.start();
            thread2.start();
            thread1.join();
            thread2.join();
            _sourceFormatterHelper.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String stripJavaImports(String content, String packageDir, String className) throws IOException {
        Matcher matcher = _javaImportPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String imports = matcher.group();
        Set classes = ClassUtil.getClasses((Reader)new UnsyncStringReader(content), (String)className);
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(imports));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (!line.contains("import ")) continue;
            int importX = line.indexOf(" ");
            int importY = line.lastIndexOf(".");
            String importPackage = line.substring(importX + 1, importY);
            String importClass = line.substring(importY + 1, line.length() - 1);
            if (packageDir.equals(importPackage)) continue;
            if (!importClass.equals("*")) {
                if (!classes.contains(importClass)) continue;
                sb.append(line);
                sb.append("\n");
                continue;
            }
            sb.append(line);
            sb.append("\n");
        }
        imports = SourceFormatter._formatImports(sb.toString(), 7);
        content = String.valueOf(content.substring(0, matcher.start())) + imports + content.substring(matcher.end());
        content = content.replaceFirst("(?m)^[ \t]*(package .*;)\\s*^[ \t]*import", "$1\n\nimport");
        content = content.replaceFirst("(?m)^[ \t]*((?:package|import) .*;)\\s*^[ \t]*/\\*\\*", "$1\n\n/**");
        return content;
    }

    private static void _addJSPIncludeFileNames(String fileName, Set<String> includeFileNames) {
        int y;
        String content = _jspContents.get(fileName);
        if (Validator.isNull((String)content)) {
            return;
        }
        int x = 0;
        while ((x = content.indexOf("<%@ include file=", x)) != -1 && (x = content.indexOf("\"", x)) != -1 && (y = content.indexOf("\"", x + 1)) != -1) {
            String includeFileName = content.substring(x + 1, y);
            Matcher matcher = _jspIncludeFilePattern.matcher(includeFileName);
            if (!matcher.find()) {
                throw new RuntimeException("Invalid include " + includeFileName);
            }
            String docrootPath = fileName.substring(0, fileName.indexOf("docroot") + 7);
            includeFileName = String.valueOf(docrootPath) + includeFileName;
            if ((includeFileName.endsWith("jsp") || includeFileName.endsWith("jspf")) && !includeFileNames.contains(includeFileName) && !includeFileName.contains("html/portlet/init.jsp")) {
                includeFileNames.add(includeFileName);
            }
            x = y;
        }
    }

    private static void _addJSPReferenceFileNames(String fileName, Set<String> includeFileNames) {
        for (Map.Entry<String, String> entry : _jspContents.entrySet()) {
            String referenceFileName = entry.getKey();
            String content = entry.getValue();
            if (!content.contains("<%@ include file=\"" + fileName) || includeFileNames.contains(referenceFileName)) continue;
            includeFileNames.add(referenceFileName);
        }
    }

    private static void _addJSPUnusedImports(String fileName, List<String> importLines, List<String> unneededImports) {
        for (String importLine : importLines) {
            HashSet<String> includeFileNames = new HashSet<String>();
            includeFileNames.add(fileName);
            HashSet<String> checkedFileNames = new HashSet<String>();
            int x = importLine.indexOf("\"");
            int y = importLine.indexOf("\"", x + 1);
            if (x == -1 || y == -1) continue;
            String className = importLine.substring(x + 1, y);
            if (SourceFormatter._isJSPImportRequired(fileName, className = className.substring(className.lastIndexOf(".") + 1), includeFileNames, checkedFileNames)) continue;
            unneededImports.add(importLine);
        }
    }

    private static void _checkPersistenceTestSuite() throws IOException {
        String basedir = "./portal-impl/test";
        if (!_fileUtil.exists(basedir)) {
            return;
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        directoryScanner.setIncludes(new String[]{"**\\*PersistenceTest.java"});
        List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
        ArrayList<String> persistenceTests = new ArrayList<String>();
        for (String fileName : fileNames) {
            String persistenceTest = fileName.substring(0, fileName.length() - 5);
            persistenceTest = persistenceTest.substring(persistenceTest.lastIndexOf(File.separator) + 1, persistenceTest.length());
            persistenceTests.add(persistenceTest);
        }
        String persistenceTestSuiteFileName = String.valueOf(basedir) + "/com/liferay/portal/service/persistence/" + "PersistenceTestSuite.java";
        String persistenceTestSuiteContent = _fileUtil.read(persistenceTestSuiteFileName);
        for (String persistenceTest : persistenceTests) {
            if (persistenceTestSuiteContent.contains(persistenceTest)) continue;
            _sourceFormatterHelper.printError(persistenceTestSuiteFileName, "PersistenceTestSuite: " + persistenceTest);
        }
    }

    private static boolean _checkTaglibVulnerability(String jspContent, String vulnerability) {
        int pos1 = -1;
        do {
            if ((pos1 = jspContent.indexOf(vulnerability, pos1 + 1)) == -1) continue;
            int pos2 = jspContent.lastIndexOf(60, pos1);
            while (pos2 > 0 && jspContent.charAt(pos2 + 1) == '%') {
                pos2 = jspContent.lastIndexOf(60, pos2 - 1);
            }
            String tagContent = jspContent.substring(pos2, pos1);
            if (tagContent.startsWith("<aui:") || tagContent.startsWith("<liferay-portlet:") || tagContent.startsWith("<liferay-util:") || tagContent.startsWith("<portlet:")) continue;
            return true;
        } while (pos1 != -1);
        return false;
    }

    private static void _checkXSS(String fileName, String jspContent) {
        Matcher matcher = _xssPattern.matcher(jspContent);
        while (matcher.find()) {
            String documentIdVulnerability;
            String inlineStringVulnerability3;
            String inlineStringVulnerability2;
            String inlineStringVulnerability1;
            String inputVulnerability;
            boolean xssVulnerable = false;
            String jspVariable = matcher.group(1);
            String anchorVulnerability = " href=\"<%= " + jspVariable + " %>";
            if (SourceFormatter._checkTaglibVulnerability(jspContent, anchorVulnerability)) {
                xssVulnerable = true;
            }
            if (SourceFormatter._checkTaglibVulnerability(jspContent, inputVulnerability = " value=\"<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (jspContent.contains(inlineStringVulnerability1 = "'<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (jspContent.contains(inlineStringVulnerability2 = "(\"<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (jspContent.contains(inlineStringVulnerability3 = " \"<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (jspContent.contains(documentIdVulnerability = ".<%= " + jspVariable + " %>")) {
                xssVulnerable = true;
            }
            if (!xssVulnerable) continue;
            _sourceFormatterHelper.printError(fileName, "(xss): " + fileName + " (" + jspVariable + ")");
        }
    }

    private static String _fixAntXMLProjectName(String basedir, String fileName, String content) throws IOException {
        int x = 0;
        if (fileName.endsWith("-ext/build.xml")) {
            x = fileName.indexOf("ext/");
            x = x == -1 ? 0 : (x += 4);
        } else if (fileName.endsWith("-hook/build.xml")) {
            x = fileName.indexOf("hooks/");
            x = x == -1 ? 0 : (x += 6);
        } else if (fileName.endsWith("-layouttpl/build.xml")) {
            x = fileName.indexOf("layouttpl/");
            x = x == -1 ? 0 : (x += 10);
        } else if (fileName.endsWith("-portlet/build.xml")) {
            x = fileName.indexOf("portlets/");
            x = x == -1 ? 0 : (x += 9);
        } else if (fileName.endsWith("-theme/build.xml")) {
            x = fileName.indexOf("themes/");
            x = x == -1 ? 0 : (x += 7);
        } else if (fileName.endsWith("-web/build.xml") && !fileName.endsWith("/ext-web/build.xml")) {
            x = fileName.indexOf("webs/");
            x = x == -1 ? 0 : (x += 5);
        } else {
            return content;
        }
        int y = fileName.indexOf("/", x);
        String correctProjectElementText = "<project name=\"" + fileName.substring(x, y) + "\"";
        if (!content.contains(correctProjectElementText)) {
            x = content.indexOf("<project name=\"");
            y = content.indexOf("\"", x) + 1;
            y = content.indexOf("\"", y) + 1;
            content = String.valueOf(content.substring(0, x)) + correctProjectElementText + content.substring(y);
            _sourceFormatterHelper.printError(fileName, String.valueOf(fileName) + " has an incorrect project name");
            _fileUtil.write(String.valueOf(basedir) + fileName, content);
        }
        return content;
    }

    private static void _formatAntXML() throws DocumentException, IOException {
        String basedir = "./";
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        directoryScanner.setIncludes(new String[]{"**\\b*.xml"});
        directoryScanner.setExcludes(new String[]{"**\\tools\\**"});
        List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
        block0: for (String fileName : fileNames) {
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            String content = _fileUtil.read(String.valueOf(basedir) + fileName);
            content = SourceFormatter._fixAntXMLProjectName(basedir, fileName, content);
            Document document = _saxReaderUtil.read(content);
            Element rootElement = document.getRootElement();
            String previousName = "";
            List targetElements = rootElement.elements("target");
            for (Element targetElement : targetElements) {
                String name = targetElement.attributeValue("name");
                if (name.equals("Test")) {
                    name = name.toLowerCase();
                }
                if (name.compareTo(previousName) < -1) {
                    _sourceFormatterHelper.printError(fileName, String.valueOf(fileName) + " has an unordered target " + name);
                    continue block0;
                }
                previousName = name;
            }
        }
    }

    private static void _formatDDLStructuresXML() throws DocumentException, IOException {
        String basedir = "./portal-impl/src/com/liferay/portal/events/dependencies/";
        if (!_fileUtil.exists(basedir)) {
            return;
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        directoryScanner.setIncludes(new String[]{"**\\*structures.xml"});
        List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
        for (String fileName : fileNames) {
            File file = new File(String.valueOf(basedir) + fileName);
            String content = _fileUtil.read(file);
            String newContent = SourceFormatter._formatDDLStructuresXML(content);
            if (newContent == null || content.equals(newContent)) continue;
            _fileUtil.write(file, newContent);
            _sourceFormatterHelper.printError(fileName, file);
        }
    }

    private static String _formatDDLStructuresXML(String content) throws DocumentException, IOException {
        Document document = _saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        rootElement.sortAttributes(true);
        rootElement.sortElementsByChildElement("structure", "name");
        List structureElements = rootElement.elements("structure");
        for (Element structureElement : structureElements) {
            Element structureRootElement = structureElement.element("root");
            structureRootElement.sortElementsByAttribute("dynamic-element", "name");
            List dynamicElementElements = structureRootElement.elements("dynamic-element");
            for (Element dynamicElementElement : dynamicElementElements) {
                Element metaDataElement = dynamicElementElement.element("meta-data");
                metaDataElement.sortElementsByAttribute("entry", "name");
            }
        }
        return document.formattedString();
    }

    private static void _formatFriendlyURLRoutesXML() throws DocumentException, IOException {
        String basedir = "./";
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        directoryScanner.setIncludes(new String[]{"**\\*routes.xml"});
        directoryScanner.setExcludes(new String[]{"**\\classes\\**", "**\\bin\\**"});
        List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
        for (String fileName : fileNames) {
            String newContent;
            File file = new File(String.valueOf(basedir) + fileName);
            String content = _fileUtil.read(file);
            if (content.contains("<!-- SourceFormatter.Ignore -->") || (newContent = SourceFormatter._formatFriendlyURLRoutesXML(content)) == null || content.equals(newContent)) continue;
            _fileUtil.write(file, newContent);
            _sourceFormatterHelper.printError(fileName, file);
        }
    }

    private static String _formatFriendlyURLRoutesXML(String content) throws DocumentException {
        Document document = _saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        ArrayList<ComparableRoute> comparableRoutes = new ArrayList<ComparableRoute>();
        for (Element routeElement : rootElement.elements("route")) {
            Object value;
            String pattern = routeElement.elementText("pattern");
            ComparableRoute comparableRoute = new ComparableRoute(pattern);
            for (Element element : routeElement.elements("generated-parameter")) {
                String string = element.attributeValue("name");
                value = element.getText();
                comparableRoute.addGeneratedParameter(string, (String)value);
            }
            for (Element element : routeElement.elements("ignored-parameter")) {
                String string = element.attributeValue("name");
                comparableRoute.addIgnoredParameter(string);
            }
            for (Element element : routeElement.elements("implicit-parameter")) {
                String string = element.attributeValue("name");
                value = element.getText();
                comparableRoute.addImplicitParameter(string, (String)value);
            }
            for (Element element : routeElement.elements("overridden-parameter")) {
                String string = element.attributeValue("name");
                value = element.getText();
                comparableRoute.addOverriddenParameter(string, (String)value);
            }
            comparableRoutes.add(comparableRoute);
        }
        Collections.sort(comparableRoutes);
        StringBundler sb = new StringBundler();
        sb.append("<?xml version=\"1.0\"?>\n");
        sb.append("<!DOCTYPE routes PUBLIC \"-//Liferay//DTD Friendly URL ");
        sb.append("Routes 6.1.0//EN\" \"http://www.liferay.com/dtd/");
        sb.append("liferay-friendly-url-routes_6_1_0.dtd\">\n\n<routes>\n");
        for (ComparableRoute comparableRoute : comparableRoutes) {
            sb.append("\t<route>\n");
            sb.append("\t\t<pattern>");
            sb.append(comparableRoute.getPattern());
            sb.append("</pattern>\n");
            Map<String, String> generatedParameters = comparableRoute.getGeneratedParameters();
            for (Map.Entry entry : generatedParameters.entrySet()) {
                sb.append("\t\t<generated-parameter name=\"");
                sb.append((String)entry.getKey());
                sb.append("\">");
                sb.append((String)entry.getValue());
                sb.append("</generated-parameter>\n");
            }
            Set<String> set = comparableRoute.getIgnoredParameters();
            for (String entry : set) {
                sb.append("\t\t<ignored-parameter name=\"");
                sb.append(entry);
                sb.append("\" />\n");
            }
            Map<String, String> implicitParameters = comparableRoute.getImplicitParameters();
            for (Map.Entry entry : implicitParameters.entrySet()) {
                sb.append("\t\t<implicit-parameter name=\"");
                sb.append((String)entry.getKey());
                sb.append("\">");
                sb.append((String)entry.getValue());
                sb.append("</implicit-parameter>\n");
            }
            Map<String, String> map = comparableRoute.getOverriddenParameters();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                sb.append("\t\t<overridden-parameter name=\"");
                sb.append(entry.getKey());
                sb.append("\">");
                sb.append(entry.getValue());
                sb.append("</overridden-parameter>\n");
            }
            sb.append("\t</route>\n");
        }
        sb.append("</routes>");
        return sb.toString();
    }

    private static String _formatImports(String imports, int classStartPos) throws IOException {
        if (imports.contains("/*") || imports.contains("*/") || imports.contains("//")) {
            return String.valueOf(imports) + "\n";
        }
        List<String> importsList = new ArrayList();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(imports));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (!line.contains("import=") && !line.contains("import ") || importsList.contains(line)) continue;
            importsList.add(line);
        }
        importsList = ListUtil.sort(importsList);
        StringBundler sb = new StringBundler();
        String temp = null;
        int i = 0;
        while (i < importsList.size()) {
            String s = (String)importsList.get(i);
            int pos = s.indexOf(".");
            if ((pos = s.indexOf(".", pos + 1)) == -1) {
                pos = s.indexOf(".");
            }
            String packageLevel = s.substring(classStartPos, pos);
            if (i != 0 && !packageLevel.equals(temp)) {
                sb.append("\n");
            }
            temp = packageLevel;
            sb.append(s);
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    private static void _formatJava() throws IOException {
        String basedir = "./";
        String copyright = SourceFormatter._getCopyright();
        String oldCopyright = SourceFormatter._getOldCopyright();
        boolean portalJavaFiles = true;
        Collection<String> fileNames = null;
        if (_fileUtil.exists(String.valueOf(basedir) + "portal-impl")) {
            fileNames = SourceFormatter._getPortalJavaFiles();
        } else {
            portalJavaFiles = false;
            fileNames = SourceFormatter._getPluginJavaFiles();
        }
        for (String fileName : fileNames) {
            String customCopyright;
            int packagePathY;
            File file = new File(fileName);
            String content = _fileUtil.read(file);
            if (SourceFormatter._isGenerated(content)) continue;
            String className = file.getName();
            className = className.substring(0, className.length() - 5);
            String packagePath = fileName;
            int packagePathX = packagePath.indexOf(String.valueOf(File.separator) + "src" + File.separator);
            packagePath = packagePathX + 5 >= (packagePathY = packagePath.lastIndexOf(File.separator)) ? "" : packagePath.substring(packagePathX + 5, packagePathY);
            if ((packagePath = StringUtil.replace((String)packagePath, (String)File.separator, (String)".")).endsWith(".model") && content.contains("extends " + className + "Model")) continue;
            String newContent = SourceFormatter._formatJavaContent(fileName, content);
            if (newContent.contains("$\n */")) {
                _sourceFormatterHelper.printError(fileName, "*: " + fileName);
                newContent = StringUtil.replace((String)newContent, (String)"$\n */", (String)"$\n *\n */");
            }
            if (oldCopyright != null && newContent.contains(oldCopyright)) {
                newContent = StringUtil.replace((String)newContent, (String)oldCopyright, (String)copyright);
                _sourceFormatterHelper.printError(fileName, "old (c): " + fileName);
            }
            if (!(newContent.contains(copyright) || !Validator.isNull((String)(customCopyright = SourceFormatter._getCustomCopyright(file))) && newContent.contains(customCopyright))) {
                _sourceFormatterHelper.printError(fileName, "(c): " + fileName);
            }
            if (newContent.contains(String.valueOf(className) + ".java.html")) {
                _sourceFormatterHelper.printError(fileName, "Java2HTML: " + fileName);
            }
            if (newContent.contains(" * @author Raymond Aug") && !newContent.contains(" * @author Raymond Aug\u00e9")) {
                newContent = newContent.replaceFirst("Raymond Aug.++", "Raymond Aug\u00e9");
                _sourceFormatterHelper.printError(fileName, "UTF-8: " + fileName);
            }
            newContent = StringUtil.replace((String)newContent, (String[])new String[]{"com.liferay.portal.PortalException", "com.liferay.portal.SystemException", "com.liferay.util.LocalizationUtil"}, (String[])new String[]{"com.liferay.portal.kernel.exception.PortalException", "com.liferay.portal.kernel.exception.SystemException", "com.liferay.portal.kernel.util.LocalizationUtil"});
            newContent = SourceFormatter.stripJavaImports(newContent, packagePath, className);
            if ((newContent = StringUtil.replace((String)newContent, (String[])new String[]{";\n/**", "\t/*\n\t *", "if(", "for(", "while(", "List <", "){\n", "]{\n", "\n\n\n"}, (String[])new String[]{";\n\n/**", "\t/**\n\t *", "if (", "for (", "while (", "List<", ") {\n", "] {\n", "\n\n"})).contains("*/\npackage ")) {
                _sourceFormatterHelper.printError(fileName, "package: " + fileName);
            }
            if (!newContent.endsWith("\n\n}") && !newContent.endsWith("{\n}")) {
                _sourceFormatterHelper.printError(fileName, "}: " + fileName);
            }
            if (portalJavaFiles && className.endsWith("ServiceImpl") && newContent.contains("ServiceUtil.")) {
                _sourceFormatterHelper.printError(fileName, "ServiceUtil: " + fileName);
            }
            if (newContent == null || content.equals(newContent)) continue;
            _fileUtil.write(file, newContent);
            _sourceFormatterHelper.printError(fileName, file);
        }
    }

    private static String _formatJavaContent(String fileName, String content) throws IOException {
        boolean longLogFactoryUtil = false;
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        int lineCount = 0;
        String line = null;
        String previousLine = "";
        int lineToSkipIfEmpty = 0;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String excluded;
            ++lineCount;
            if (line.trim().length() == 0) {
                line = "";
            }
            line = StringUtil.trimTrailing((String)line);
            line = StringUtil.replace((String)line, (String[])new String[]{"* Copyright (c) 2000-2011 Liferay, Inc."}, (String[])new String[]{"* Copyright (c) 2000-2012 Liferay, Inc."});
            String trimmedLine = StringUtil.trimLeading((String)(line = SourceFormatter._replacePrimitiveWrapperInstantiation(fileName, line, lineCount)));
            if (!trimmedLine.contains("//") && !trimmedLine.startsWith("*")) {
                while (trimmedLine.contains("\t")) {
                    line = StringUtil.replaceLast((String)line, (String)"\t", (String)" ");
                    trimmedLine = StringUtil.replaceLast((String)trimmedLine, (String)"\t", (String)" ");
                }
                while (trimmedLine.contains("  ") && !trimmedLine.contains("\"  ") && !fileName.contains("Test")) {
                    line = StringUtil.replaceLast((String)line, (String)"  ", (String)" ");
                    trimmedLine = StringUtil.replaceLast((String)trimmedLine, (String)"  ", (String)" ");
                }
                if (!line.contains("\"")) {
                    if ((trimmedLine.startsWith("private ") || trimmedLine.startsWith("protected ") || trimmedLine.startsWith("public ")) && line.contains(" (")) {
                        line = StringUtil.replace((String)line, (String)" (", (String)"(");
                    }
                    if (line.contains(" [")) {
                        line = StringUtil.replace((String)line, (String)" [", (String)"[");
                    }
                    int x = -1;
                    while ((x = line.indexOf(",", x + 1)) != -1) {
                        char previousChar;
                        char nextChar;
                        if (line.length() > x + 1 && (nextChar = line.charAt(x + 1)) != ' ' && nextChar != '\'') {
                            line = StringUtil.insert((String)line, (String)" ", (int)(x + 1));
                        }
                        if (x <= 0 || (previousChar = line.charAt(x - 1)) != ' ') continue;
                        line = line.substring(0, x - 1).concat(line.substring(x));
                    }
                }
            }
            if (line.contains("    ") && !line.matches("\\s*\\*.*") && !fileName.endsWith("StringPool.java")) {
                _sourceFormatterHelper.printError(fileName, "tab: " + fileName + " " + lineCount);
            }
            if (line.contains("  {") && !line.matches("\\s*\\*.*")) {
                _sourceFormatterHelper.printError(fileName, "{:" + fileName + " " + lineCount);
            }
            if (line.endsWith("private static Log _log =")) {
                longLogFactoryUtil = true;
            }
            if ((excluded = _exclusionsProperties.getProperty(String.valueOf(StringUtil.replace((String)fileName, (String)"\\", (String)"/")) + "@" + lineCount)) == null) {
                excluded = _exclusionsProperties.getProperty(StringUtil.replace((String)fileName, (String)"\\", (String)"/"));
            }
            String combinedLines = null;
            if (!(excluded != null || line.startsWith("import ") || line.startsWith("package ") || line.matches("\\s*\\*.*") || fileName.endsWith("Table.java") && line.contains("String TABLE_SQL_CREATE = ") || fileName.endsWith("Table.java") && line.contains("String TABLE_SQL_DROP = ") || fileName.endsWith("Table.java") && line.contains(" index IX_"))) {
                if (SourceFormatter._getLineLength(line) > 80) {
                    _sourceFormatterHelper.printError(fileName, "> 80: " + fileName + " " + lineCount);
                } else {
                    combinedLines = SourceFormatter._getCombinedLines(trimmedLine, previousLine);
                }
            }
            if (Validator.isNotNull(combinedLines)) {
                previousLine = combinedLines;
                if (!line.endsWith("{")) continue;
                lineToSkipIfEmpty = lineCount + 1;
                continue;
            }
            if (lineCount > 1 && (Validator.isNotNull((String)previousLine) || lineToSkipIfEmpty != lineCount - 1)) {
                sb.append(previousLine);
                sb.append("\n");
            }
            previousLine = line;
        }
        sb.append(previousLine);
        unsyncBufferedReader.close();
        String newContent = sb.toString();
        if (newContent.endsWith("\n")) {
            newContent = newContent.substring(0, newContent.length() - 1);
        }
        if (longLogFactoryUtil) {
            newContent = StringUtil.replace((String)newContent, (String)"private static Log _log =\n\t\tLogFactoryUtil.getLog(", (String)"private static Log _log = LogFactoryUtil.getLog(\n\t\t");
        }
        return newContent;
    }

    private static void _formatJSP() throws IOException {
        String[] fileNames;
        String basedir = "./";
        String copyright = SourceFormatter._getCopyright();
        String oldCopyright = SourceFormatter._getOldCopyright();
        ArrayList<String> list = new ArrayList<String>();
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        Object[] excludes = new String[]{"**\\portal\\aui\\**", "**\\bin\\**", "**\\null.jsp", "**\\tmp\\**", "**\\tools\\**"};
        excludes = (String[])ArrayUtil.append((Object[])excludes, (Object[])_excludes);
        directoryScanner.setExcludes((String[])excludes);
        directoryScanner.setIncludes(new String[]{"**\\*.jsp", "**\\*.jspf", "**\\*.vm"});
        list.addAll(_sourceFormatterHelper.scanForFiles(directoryScanner));
        String[] stringArray = fileNames = list.toArray(new String[list.size()]);
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            File file = new File(String.valueOf(basedir) + fileName);
            String content = _fileUtil.read(file);
            fileName = fileName.replace('\\', '/');
            _jspContents.put(fileName, content);
            ++n2;
        }
        boolean stripJSPImports = true;
        String[] stringArray2 = fileNames;
        int n3 = fileNames.length;
        n = 0;
        while (n < n3) {
            String fileName = stringArray2[n];
            File file = new File(String.valueOf(basedir) + fileName);
            String content = _fileUtil.read(file);
            String newContent = SourceFormatter._formatJSPContent(fileName, content);
            newContent = StringUtil.replace((String)newContent, (String[])new String[]{"<br/>", "\"/>", "\" >", "@page import", "\"%>", ")%>", "javascript: "}, (String[])new String[]{"<br />", "\" />", "\">", "@ page import", "\" %>", ") %>", "javascript:"});
            if (stripJSPImports) {
                try {
                    newContent = SourceFormatter._stripJSPImports(fileName, newContent);
                }
                catch (RuntimeException runtimeException) {
                    stripJSPImports = false;
                }
            }
            newContent = StringUtil.replace((String)newContent, (String[])new String[]{"* Copyright (c) 2000-2011 Liferay, Inc."}, (String[])new String[]{"* Copyright (c) 2000-2012 Liferay, Inc."});
            if (fileName.endsWith(".jsp") || fileName.endsWith(".jspf")) {
                if (oldCopyright != null && newContent.contains(oldCopyright)) {
                    newContent = StringUtil.replace((String)newContent, (String)oldCopyright, (String)copyright);
                    _sourceFormatterHelper.printError(fileName, "old (c): " + fileName);
                }
                if (!newContent.contains(copyright)) {
                    String customCopyright = SourceFormatter._getCustomCopyright(file);
                    if (Validator.isNull((String)customCopyright) || !newContent.contains(customCopyright)) {
                        _sourceFormatterHelper.printError(fileName, "(c): " + fileName);
                    } else {
                        newContent = StringUtil.replace((String)newContent, (String)("<%\n" + customCopyright + "\n%>"), (String)("<%--\n" + customCopyright + "\n--%>"));
                    }
                } else {
                    newContent = StringUtil.replace((String)newContent, (String)("<%\n" + copyright + "\n%>"), (String)("<%--\n" + copyright + "\n--%>"));
                }
            }
            if ((newContent = StringUtil.replace((String)newContent, (String[])new String[]{"alert('<%= LanguageUtil.", "alert(\"<%= LanguageUtil.", "confirm('<%= LanguageUtil.", "confirm(\"<%= LanguageUtil."}, (String[])new String[]{"alert('<%= UnicodeLanguageUtil.", "alert(\"<%= UnicodeLanguageUtil.", "confirm('<%= UnicodeLanguageUtil.", "confirm(\"<%= UnicodeLanguageUtil."})).contains("    ") && !fileName.endsWith("template.vm")) {
                _sourceFormatterHelper.printError(fileName, "tab: " + fileName);
            }
            if (fileName.endsWith("init.jsp")) {
                boolean compressImports;
                int x = newContent.indexOf("<%@ page import=");
                int y = newContent.lastIndexOf("<%@ page import=");
                y = newContent.indexOf("%>", y);
                if (x != -1 && y != -1 && y > x && (compressImports = true)) {
                    String imports = newContent.substring(x, y);
                    imports = StringUtil.replace((String)imports, (String[])new String[]{"%>\r\n<%@ ", "%>\n<%@ "}, (String[])new String[]{"%><%@\r\n", "%><%@\n"});
                    newContent = String.valueOf(newContent.substring(0, x)) + imports + newContent.substring(y);
                }
            }
            SourceFormatter._checkXSS(fileName, newContent);
            if (newContent != null && !content.equals(newContent)) {
                _fileUtil.write(file, newContent);
                _sourceFormatterHelper.printError(fileName, file);
            }
            ++n;
        }
    }

    private static String _formatJSPContent(String fileName, String content) throws IOException {
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        int lineCount = 0;
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String includeFileName;
            Matcher matcher;
            int y;
            int x;
            String trimmedLine;
            ++lineCount;
            if (line.trim().length() == 0) {
                line = "";
            }
            if ((line = StringUtil.trimTrailing((String)line)).contains("<aui:button ") && line.contains("type=\"button\"")) {
                _sourceFormatterHelper.printError(fileName, "aui:button " + fileName + " " + lineCount);
            }
            if (!(trimmedLine = StringUtil.trimLeading((String)line)).contains("//") && !trimmedLine.startsWith("*")) {
                while (trimmedLine.contains("\t")) {
                    line = StringUtil.replaceLast((String)line, (String)"\t", (String)" ");
                    trimmedLine = StringUtil.replaceLast((String)trimmedLine, (String)"\t", (String)" ");
                }
                while (trimmedLine.contains("  ") && !trimmedLine.contains("\"  ") && !fileName.endsWith(".vm")) {
                    line = StringUtil.replaceLast((String)line, (String)"  ", (String)" ");
                    trimmedLine = StringUtil.replaceLast((String)trimmedLine, (String)"  ", (String)" ");
                }
            }
            if ((x = line.indexOf("<%@ include file")) != -1 && (y = line.indexOf("\"", (x = line.indexOf("\"", x)) + 1)) != -1 && !(matcher = _jspIncludeFilePattern.matcher(includeFileName = line.substring(x + 1, y))).find()) {
                _sourceFormatterHelper.printError(fileName, "include: " + fileName + " " + lineCount);
            }
            line = SourceFormatter._replacePrimitiveWrapperInstantiation(fileName, line, lineCount);
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        content = SourceFormatter._formatTaglibQuotes(fileName, content, "\"");
        content = SourceFormatter._formatTaglibQuotes(fileName, content, "'");
        return content;
    }

    private static void _formatPortletXML() throws DocumentException, IOException {
        String basedir = "./";
        if (_fileUtil.exists(String.valueOf(basedir) + "portal-impl")) {
            File file = new File(String.valueOf(basedir) + "portal-web/docroot/WEB-INF/portlet-custom.xml");
            String content = _fileUtil.read(file);
            String newContent = SourceFormatter._formatPortletXML(content);
            if (newContent != null && !content.equals(newContent)) {
                _fileUtil.write(file, newContent);
                _sourceFormatterHelper.printError(file.toString(), file);
            }
        } else {
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(basedir);
            directoryScanner.setIncludes(new String[]{"**\\portlet.xml"});
            List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
            for (String fileName : fileNames) {
                File file = new File(String.valueOf(basedir) + fileName);
                String content = _fileUtil.read(file);
                String newContent = SourceFormatter._formatPortletXML(content);
                if (newContent == null || content.equals(newContent)) continue;
                _fileUtil.write(file, newContent);
                _sourceFormatterHelper.printError(fileName, file);
            }
        }
    }

    private static String _formatPortletXML(String content) throws DocumentException, IOException {
        Document document = _saxReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        rootElement.sortAttributes(true);
        List portletElements = rootElement.elements("portlet");
        for (Element portletElement : portletElements) {
            portletElement.sortElementsByChildElement("init-param", "name");
            Element portletPreferencesElement = portletElement.element("portlet-preferences");
            if (portletPreferencesElement == null) continue;
            portletPreferencesElement.sortElementsByChildElement("preference", "name");
        }
        return document.formattedString();
    }

    private static void _formatSH() throws IOException {
        SourceFormatter._formatSH("ext/create.sh");
        SourceFormatter._formatSH("hooks/create.sh");
        SourceFormatter._formatSH("layouttpl/create.sh");
        SourceFormatter._formatSH("portlets/create.sh");
        SourceFormatter._formatSH("themes/create.sh");
    }

    private static void _formatSH(String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        String content = _fileUtil.read(new File(fileName), true);
        if (content.contains("\r")) {
            _sourceFormatterHelper.printError(fileName, "Invalid new line character");
            content = StringUtil.replace((String)content, (String)"\r", (String)"");
            _fileUtil.write(fileName, content);
        }
    }

    private static String _formatTaglibQuotes(String fileName, String content, String quoteType) {
        String quoteFix = "'";
        if (quoteFix.equals(quoteType)) {
            quoteFix = "\"";
        }
        Pattern pattern = Pattern.compile(SourceFormatter._getTaglibRegex(quoteType));
        Matcher matcher = pattern.matcher(content);
        block0: while (matcher.find()) {
            int x = content.indexOf(String.valueOf(quoteType) + "<%=", matcher.start());
            int y = content.indexOf("%>" + quoteType, x);
            while (x != -1 && y != -1) {
                String result = content.substring(x + 1, y + 2);
                if (result.contains(quoteType)) {
                    int lineCount = 1;
                    char[] contentCharArray = content.toCharArray();
                    int i = 0;
                    while (i < x) {
                        if (contentCharArray[i] == '\n') {
                            ++lineCount;
                        }
                        ++i;
                    }
                    if (!result.contains(quoteFix)) {
                        StringBundler sb = new StringBundler(5);
                        sb.append(content.substring(0, x));
                        sb.append(quoteFix);
                        sb.append(result);
                        sb.append(quoteFix);
                        sb.append(content.substring(y + 3, content.length()));
                        content = sb.toString();
                    } else {
                        _sourceFormatterHelper.printError(fileName, "taglib: " + fileName + " " + lineCount);
                    }
                }
                if ((x = content.indexOf(String.valueOf(quoteType) + "<%=", y)) > matcher.end()) continue block0;
                y = content.indexOf("%>" + quoteType, x);
            }
        }
        return content;
    }

    /*
     * WARNING - void declaration
     */
    private static void _formatWebXML() throws IOException {
        String basedir = "./";
        if (_fileUtil.exists(String.valueOf(basedir) + "portal-impl")) {
            void var6_14;
            Properties properties = new Properties();
            String propertiesContent = _fileUtil.read(String.valueOf(basedir) + "portal-impl/src/portal.properties");
            PropertiesUtil.load((Properties)properties, (String)propertiesContent);
            Object[] locales = StringUtil.split((String)properties.getProperty("locales"));
            Arrays.sort(locales);
            TreeSet<Object> urlPatterns = new TreeSet<Object>();
            Object[] objectArray = locales;
            int n = locales.length;
            boolean n2 = false;
            while (var6_14 < n) {
                Object locale = objectArray[var6_14];
                int pos = ((String)locale).indexOf("_");
                String languageCode = ((String)locale).substring(0, pos);
                urlPatterns.add(languageCode);
                urlPatterns.add(locale);
                ++var6_14;
            }
            StringBundler sb = new StringBundler();
            for (String string : urlPatterns) {
                sb.append("\t<servlet-mapping>\n");
                sb.append("\t\t<servlet-name>I18n Servlet</servlet-name>\n");
                sb.append("\t\t<url-pattern>/" + string + "/*</url-pattern>\n");
                sb.append("\t</servlet-mapping>\n");
            }
            File file = new File(String.valueOf(basedir) + "portal-web/docroot/WEB-INF/web.xml");
            String content = _fileUtil.read(file);
            int x = content.indexOf("<servlet-mapping>");
            x = content.indexOf("<servlet-name>I18n Servlet</servlet-name>", x);
            x = content.lastIndexOf("<servlet-mapping>", x) - 1;
            int y = content.lastIndexOf("<servlet-name>I18n Servlet</servlet-name>");
            y = content.indexOf("</servlet-mapping>", y) + 19;
            String newContent = String.valueOf(content.substring(0, x)) + sb.toString() + content.substring(y);
            x = newContent.indexOf("<security-constraint>");
            x = newContent.indexOf("<web-resource-name>/c/portal/protected</web-resource-name>", x);
            x = newContent.indexOf("<url-pattern>", x) - 3;
            y = newContent.indexOf("<http-method>", x);
            y = newContent.lastIndexOf("</url-pattern>", y) + 15;
            sb = new StringBundler();
            sb.append("\t\t\t<url-pattern>/c/portal/protected</url-pattern>\n");
            for (String string : urlPatterns) {
                sb.append("\t\t\t<url-pattern>/" + string + "/c/portal/protected</url-pattern>\n");
            }
            if ((newContent = String.valueOf(newContent.substring(0, x)) + sb.toString() + newContent.substring(y)) != null && !content.equals(newContent)) {
                _fileUtil.write(file, newContent);
                System.out.println(file);
            }
        } else {
            String webXML = ContentUtil.get((String)"com/liferay/portal/deploy/dependencies/web.xml");
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(basedir);
            directoryScanner.setIncludes(new String[]{"**\\web.xml"});
            List<String> fileNames = _sourceFormatterHelper.scanForFiles(directoryScanner);
            for (String fileName : fileNames) {
                String string = _fileUtil.read(String.valueOf(basedir) + fileName);
                if (!string.equals(webXML)) continue;
                _sourceFormatterHelper.printError(fileName, fileName);
            }
        }
    }

    private static String _getCombinedLines(String line, String previousLine) {
        if (Validator.isNull((String)previousLine)) {
            return null;
        }
        int previousLineLength = SourceFormatter._getLineLength(previousLine);
        String trimmedPreviousLine = StringUtil.trimLeading((String)previousLine);
        if (line.length() + previousLineLength < 80) {
            if (trimmedPreviousLine.startsWith("for ") && previousLine.endsWith(":") && line.endsWith("{")) {
                return String.valueOf(previousLine) + " " + line;
            }
            if (previousLine.endsWith("=") && line.endsWith(";")) {
                return String.valueOf(previousLine) + " " + line;
            }
            if ((trimmedPreviousLine.startsWith("if ") || trimmedPreviousLine.startsWith("else ")) && (previousLine.endsWith("||") || previousLine.endsWith("&&")) && line.endsWith("{")) {
                return String.valueOf(previousLine) + " " + line;
            }
        }
        if (!previousLine.endsWith("(")) {
            return null;
        }
        if (line.length() + previousLineLength > 80) {
            return null;
        }
        if (line.endsWith(";")) {
            return String.valueOf(previousLine) + line;
        }
        if ((line.endsWith("{") || line.endsWith(")")) && (trimmedPreviousLine.startsWith("else ") || trimmedPreviousLine.startsWith("if ") || trimmedPreviousLine.startsWith("private ") || trimmedPreviousLine.startsWith("protected ") || trimmedPreviousLine.startsWith("public "))) {
            return String.valueOf(previousLine) + line;
        }
        return null;
    }

    private static String _getCopyright() throws IOException {
        String copyright = _fileUtil.read("copyright.txt");
        if (Validator.isNull((String)copyright)) {
            copyright = _fileUtil.read("../copyright.txt");
        }
        if (Validator.isNull((String)copyright)) {
            copyright = _fileUtil.read("../../copyright.txt");
        }
        return copyright;
    }

    private static String _getCustomCopyright(File file) throws IOException {
        String absolutePath = _fileUtil.getAbsolutePath(file);
        int x = absolutePath.length();
        while ((x = absolutePath.lastIndexOf("/", x)) != -1) {
            String copyright = _fileUtil.read(String.valueOf(absolutePath.substring(0, x + 1)) + "copyright.txt");
            if (Validator.isNotNull((String)copyright)) {
                return copyright;
            }
            --x;
        }
        return null;
    }

    private static List<String> _getJSPDuplicateImports(String fileName, String content, List<String> importLines) {
        ArrayList<String> duplicateImports = new ArrayList<String>();
        for (String importLine : importLines) {
            int y;
            int x = content.indexOf("<%@ include file=");
            if (x == -1 || (y = content.indexOf("<%@ page import=")) == -1 || x >= y || !SourceFormatter._isJSPDuplicateImport(fileName, importLine, false)) continue;
            duplicateImports.add(importLine);
        }
        return duplicateImports;
    }

    private static int _getLineLength(String line) {
        int lineLength = 0;
        int tabLength = 4;
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\t') {
                int i = 0;
                while (i < tabLength) {
                    ++lineLength;
                    ++i;
                }
                tabLength = 4;
            } else {
                ++lineLength;
                if (--tabLength <= 0) {
                    tabLength = 4;
                }
            }
            ++n2;
        }
        return lineLength;
    }

    private static String _getOldCopyright() throws IOException {
        String copyright = _fileUtil.read("old-copyright.txt");
        if (Validator.isNull((String)copyright)) {
            copyright = _fileUtil.read("../old-copyright.txt");
        }
        if (Validator.isNull((String)copyright)) {
            copyright = _fileUtil.read("../../old-copyright.txt");
        }
        return copyright;
    }

    private static Collection<String> _getPluginJavaFiles() {
        String basedir = "./";
        TreeSet<String> fileNames = new TreeSet<String>();
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        Object[] excludes = new String[]{"**\\bin\\**", "**\\model\\*Clp.java", "**\\model\\impl\\*BaseImpl.java", "**\\model\\impl\\*Model.java", "**\\model\\impl\\*ModelImpl.java", "**\\service\\**\\model\\*Model.java", "**\\service\\**\\model\\*Soap.java", "**\\service\\**\\model\\*Wrapper.java", "**\\service\\**\\service\\*Service.java", "**\\service\\**\\service\\*ServiceClp.java", "**\\service\\**\\service\\*ServiceFactory.java", "**\\service\\**\\service\\*ServiceUtil.java", "**\\service\\**\\service\\*ServiceWrapper.java", "**\\service\\**\\service\\ClpSerializer.java", "**\\service\\**\\service\\messaging\\*ClpMessageListener.java", "**\\service\\**\\service\\persistence\\*Finder.java", "**\\service\\**\\service\\persistence\\*Persistence.java", "**\\service\\**\\service\\persistence\\*Util.java", "**\\service\\base\\*ServiceBaseImpl.java", "**\\service\\http\\*JSONSerializer.java", "**\\service\\http\\*ServiceHttp.java", "**\\service\\http\\*ServiceJSON.java", "**\\service\\http\\*ServiceSoap.java", "**\\service\\persistence\\*PersistenceImpl.java", "**\\tmp\\**"};
        excludes = (String[])ArrayUtil.append((Object[])excludes, (Object[])_excludes);
        directoryScanner.setExcludes((String[])excludes);
        directoryScanner.setIncludes(new String[]{"**\\*.java"});
        fileNames.addAll(_sourceFormatterHelper.scanForFiles(directoryScanner));
        return fileNames;
    }

    private static Collection<String> _getPortalJavaFiles() {
        String basedir = "./";
        TreeSet<String> fileNames = new TreeSet<String>();
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        Object[] excludes = new String[]{"**\\InstanceWrapperBuilder.java", "**\\*_IW.java", "**\\PropsKeys.java", "**\\PropsValues.java", "**\\ServiceBuilder.java", "**\\SourceFormatter.java", "**\\WebKeys.java", "**\\bin\\**", "**\\classes\\*", "**\\counter\\service\\**", "**\\jsp\\*", "**\\model\\impl\\*BaseImpl.java", "**\\model\\impl\\*Model.java", "**\\model\\impl\\*ModelImpl.java", "**\\portal\\service\\**", "**\\portal-client\\**", "**\\portal-service\\**\\model\\*Model.java", "**\\portal-service\\**\\model\\*Soap.java", "**\\portal-service\\**\\model\\*Wrapper.java", "**\\portal-web\\classes\\**\\*.java", "**\\portal-web\\test\\**\\*Test.java", "**\\portlet\\**\\service\\**", "**\\tmp\\**", "**\\tools\\tck\\**"};
        excludes = (String[])ArrayUtil.append((Object[])excludes, (Object[])_excludes);
        directoryScanner.setExcludes((String[])excludes);
        directoryScanner.setIncludes(new String[]{"**\\*.java"});
        fileNames.addAll(_sourceFormatterHelper.scanForFiles(directoryScanner));
        directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        excludes = new String[]{"**\\bin\\**", "**\\portal-client\\**", "**\\tools\\ext_tmpl\\**", "**\\*_IW.java", "**\\test\\**\\*PersistenceTest.java"};
        excludes = (String[])ArrayUtil.append((Object[])excludes, (Object[])_excludes);
        directoryScanner.setExcludes((String[])excludes);
        directoryScanner.setIncludes(new String[]{"**\\com\\liferay\\portal\\service\\ServiceContext*.java", "**\\model\\BaseModel.java", "**\\model\\impl\\BaseModelImpl.java", "**\\service\\PersistedModelLocalService*.java", "**\\service\\base\\PrincipalBean.java", "**\\service\\http\\*HttpTest.java", "**\\service\\http\\*SoapTest.java", "**\\service\\http\\TunnelUtil.java", "**\\service\\impl\\*.java", "**\\service\\jms\\*.java", "**\\service\\permission\\*.java", "**\\service\\persistence\\BasePersistence.java", "**\\service\\persistence\\BatchSession*.java", "**\\service\\persistence\\*FinderImpl.java", "**\\service\\persistence\\*Query.java", "**\\service\\persistence\\impl\\BasePersistenceImpl.java", "**\\portal-impl\\test\\**\\*.java", "**\\portal-service\\**\\liferay\\documentlibrary\\**.java", "**\\portal-service\\**\\liferay\\lock\\**.java", "**\\portal-service\\**\\liferay\\mail\\**.java", "**\\util-bridges\\**\\*.java"});
        fileNames.addAll(_sourceFormatterHelper.scanForFiles(directoryScanner));
        return fileNames;
    }

    private static String _getTaglibRegex(String quoteType) {
        StringBuilder sb = new StringBuilder();
        sb.append("<(");
        int i = 0;
        while (i < _TAG_LIBRARIES.length) {
            sb.append(_TAG_LIBRARIES[i]);
            sb.append("|");
            ++i;
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("):([^>]|%>)*");
        sb.append(quoteType);
        sb.append("<%=.*");
        sb.append(quoteType);
        sb.append(".*%>");
        sb.append(quoteType);
        sb.append("([^>]|%>)*>");
        return sb.toString();
    }

    private static boolean _isGenerated(String content) {
        return content.contains("* @generated") || content.contains("$ANTLR");
    }

    private static boolean _isJSPDuplicateImport(String fileName, String importLine, boolean checkFile) {
        String content = _jspContents.get(fileName);
        if (Validator.isNull((String)content)) {
            return false;
        }
        int x = importLine.indexOf("page");
        if (x == -1) {
            return false;
        }
        if (checkFile && content.contains(importLine.substring(x))) {
            return true;
        }
        int y = content.indexOf("<%@ include file=");
        if (y == -1) {
            return false;
        }
        if ((y = content.indexOf("\"", y)) == -1) {
            return false;
        }
        int z = content.indexOf("\"", y + 1);
        if (z == -1) {
            return false;
        }
        String includeFileName = content.substring(y + 1, z);
        String docrootPath = fileName.substring(0, fileName.indexOf("docroot") + 7);
        includeFileName = String.valueOf(docrootPath) + includeFileName;
        return SourceFormatter._isJSPDuplicateImport(includeFileName, importLine, true);
    }

    private static boolean _isJSPImportRequired(String fileName, String className, Set<String> includeFileNames, Set<String> checkedFileNames) {
        String[] includeFileNamesArray;
        if (checkedFileNames.contains(fileName)) {
            return false;
        }
        checkedFileNames.add(fileName);
        String content = _jspContents.get(fileName);
        if (Validator.isNull((String)content)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[^A-Za-z0-9_]" + className + "[^A-Za-z0-9_\"]");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return true;
        }
        SourceFormatter._addJSPIncludeFileNames(fileName, includeFileNames);
        String docrootPath = fileName.substring(0, fileName.indexOf("docroot") + 7);
        fileName = fileName.replaceFirst(docrootPath, "");
        if (fileName.endsWith("init.jsp") || fileName.contains("init-ext.jsp")) {
            SourceFormatter._addJSPReferenceFileNames(fileName, includeFileNames);
        }
        String[] stringArray = includeFileNamesArray = includeFileNames.toArray(new String[includeFileNames.size()]);
        int n = includeFileNamesArray.length;
        int n2 = 0;
        while (n2 < n) {
            String includeFileName = stringArray[n2];
            if (!checkedFileNames.contains(includeFileName) && SourceFormatter._isJSPImportRequired(includeFileName, className, includeFileNames, checkedFileNames)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void _readExclusions() throws IOException {
        String sourceFormatterExclusions;
        _exclusionsProperties = new Properties();
        ClassLoader classLoader = SourceFormatter.class.getClassLoader();
        URL url = classLoader.getResource(sourceFormatterExclusions = System.getProperty("source-formatter-exclusions", "com/liferay/portal/tools/dependencies/source_formatter_exclusions.properties"));
        if (url == null) {
            return;
        }
        InputStream inputStream = url.openStream();
        _exclusionsProperties.load(inputStream);
        inputStream.close();
    }

    private static String _replacePrimitiveWrapperInstantiation(String fileName, String line, int lineCount) {
        return line;
    }

    private static String _stripJSPImports(String fileName, String content) throws IOException {
        String afterImports;
        if (!(fileName = fileName.replace('\\', '/')).contains("docroot") || fileName.endsWith("init-ext.jsp")) {
            return content;
        }
        Matcher matcher = _jspImportPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String imports = matcher.group();
        imports = StringUtil.replace((String)imports, (String[])new String[]{"%><%@\r\n", "%><%@\n"}, (String[])new String[]{"%>\r\n<%@ ", "%>\n<%@ "});
        if (!fileName.endsWith("html/common/init.jsp") && !fileName.endsWith("html/portal/init.jsp")) {
            ArrayList<String> importLines = new ArrayList<String>();
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(imports));
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (!line.contains("import=")) continue;
                importLines.add(line);
            }
            List<String> unneededImports = SourceFormatter._getJSPDuplicateImports(fileName, content, importLines);
            SourceFormatter._addJSPUnusedImports(fileName, importLines, unneededImports);
            for (String unneededImport : unneededImports) {
                imports = StringUtil.replace((String)imports, (String)unneededImport, (String)"");
            }
        }
        imports = SourceFormatter._formatImports(imports, 17);
        String beforeImports = content.substring(0, matcher.start());
        if (Validator.isNull((String)imports)) {
            beforeImports = StringUtil.replaceLast((String)beforeImports, (String)"\n", (String)"");
        }
        if (Validator.isNull((String)(afterImports = content.substring(matcher.end())))) {
            imports = StringUtil.replaceLast((String)imports, (String)"\n", (String)"");
            content = String.valueOf(beforeImports) + imports;
            return content;
        }
        content = String.valueOf(beforeImports) + imports + "\n" + afterImports;
        return content;
    }
}

