/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.util.FastDateFormatFactory;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.scripting.ruby.RubyExecutor;
import com.liferay.portal.servlet.filters.minifier.MinifierFilter;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.util.FastDateFormatFactoryImpl;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.Portal;
import com.liferay.portal.util.PortalImpl;
import com.liferay.portal.util.PortalUtil;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SassToCssBuilder {
    private RubyExecutor _rubyExecutor;
    private String _rubyScript;
    private String _tempDir;

    public static File getCacheFile(String fileName) {
        fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
        int pos = fileName.lastIndexOf("/");
        String cacheFileName = String.valueOf(fileName.substring(0, pos + 1)) + ".sass-cache/" + fileName.substring(pos + 1);
        return new File(cacheFileName);
    }

    public static void main(String[] args) {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        ArrayList<String> dirNames = new ArrayList<String>();
        String dirName = arguments.get("sass.dir");
        if (Validator.isNotNull((String)dirName)) {
            dirNames.add(dirName);
        } else {
            int i = 0;
            while (Validator.isNotNull((String)(dirName = arguments.get("sass.dir." + i)))) {
                dirNames.add(dirName);
                ++i;
            }
        }
        try {
            new SassToCssBuilder(dirNames);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String parseStaticTokens(String content) {
        return StringUtil.replace((String)content, (String[])new String[]{"@model_hints_constants_text_display_height@", "@model_hints_constants_text_display_width@", "@model_hints_constants_textarea_display_height@", "@model_hints_constants_textarea_display_width@"}, (String[])new String[]{"15", "350", "100", "500"});
    }

    public SassToCssBuilder(List<String> dirNames) throws Exception {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        this._initUtil(classLoader);
        this._rubyScript = StringUtil.read((ClassLoader)classLoader, (String)"com/liferay/portal/servlet/filters/dynamiccss/main.rb");
        this._tempDir = SystemProperties.get((String)"java.io.tmpdir");
        for (String dirName : dirNames) {
            this._rubyExecutor = new RubyExecutor();
            this._parseSassDirectory(dirName);
        }
    }

    private String _getContent(File file) throws Exception {
        String content = FileUtil.read((File)file);
        content = MinifierFilter.aggregateCss(file.getParent(), content);
        return SassToCssBuilder.parseStaticTokens(content);
    }

    private String _getCssThemePath(String fileName) {
        int pos = fileName.lastIndexOf("/css/");
        return fileName.substring(0, pos + 4);
    }

    private void _initUtil(ClassLoader classLoader) {
        FastDateFormatFactoryUtil fastDateFormatFactoryUtil = new FastDateFormatFactoryUtil();
        fastDateFormatFactoryUtil.setFastDateFormatFactory((FastDateFormatFactory)new FastDateFormatFactoryImpl());
        FileUtil fileUtil = new FileUtil();
        fileUtil.setFile((com.liferay.portal.kernel.util.File)new FileImpl());
        PortalClassLoaderUtil.setClassLoader((ClassLoader)classLoader);
        PortalUtil portalUtil = new PortalUtil();
        portalUtil.setPortal((Portal)new PortalImpl());
    }

    private void _parseSassDirectory(String dirName) throws Exception {
        String[] fileNames;
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(dirName);
        directoryScanner.setExcludes(new String[]{"**\\_diffs\\**", "**\\.sass-cache*\\**", "**\\.sass_cache_*\\**", "**\\_sass_cache_*\\**", "**\\_styled\\**", "**\\_unstyled\\**"});
        directoryScanner.setIncludes(new String[]{"**\\*.css"});
        directoryScanner.scan();
        String[] stringArray = fileNames = directoryScanner.getIncludedFiles();
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            fileName = StringUtil.replace((String)(String.valueOf(dirName) + "/" + fileName), (String)"\\", (String)"/");
            try {
                long start = System.currentTimeMillis();
                if (this._parseSassFile(fileName)) {
                    long end = System.currentTimeMillis();
                    System.out.println("Parsed " + fileName + " in " + (end - start) + " ms");
                }
            }
            catch (Exception e) {
                System.out.println("Unable to parse " + fileName);
                e.printStackTrace();
            }
            ++n2;
        }
    }

    private boolean _parseSassFile(String fileName) throws Exception {
        File file = new File(fileName);
        File cacheFile = SassToCssBuilder.getCacheFile(fileName);
        if (file.lastModified() == cacheFile.lastModified()) {
            return false;
        }
        HashMap<String, Object> inputObjects = new HashMap<String, Object>();
        inputObjects.put("content", this._getContent(file));
        inputObjects.put("cssRealPath", fileName);
        inputObjects.put("cssThemePath", this._getCssThemePath(fileName));
        inputObjects.put("sassCachePath", this._tempDir);
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        UnsyncPrintWriter unsyncPrintWriter = UnsyncPrintWriterPool.borrow((OutputStream)unsyncByteArrayOutputStream);
        inputObjects.put("out", unsyncPrintWriter);
        this._rubyExecutor.eval(null, inputObjects, null, this._rubyScript);
        unsyncPrintWriter.flush();
        String parsedContent = unsyncByteArrayOutputStream.toString();
        FileUtil.write((File)cacheFile, (String)parsedContent);
        cacheFile.setLastModified(file.lastModified());
        return true;
    }
}

