/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.InitUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.tools.ant.DirectoryScanner;

public class PluginsSummaryBuilder {
    private Set<String> _distinctAuthors = new TreeSet<String>();
    private Set<String> _distinctLicenses = new TreeSet<String>();

    public static void main(String[] args) {
        InitUtil.initWithSpring();
        File pluginsDir = new File(System.getProperty("plugins.dir"));
        new PluginsSummaryBuilder(pluginsDir);
    }

    public PluginsSummaryBuilder(File pluginsDir) {
        try {
            this._createPluginsSummary(pluginsDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _createPluginsSummary(File pluginsDir) throws Exception {
        StringBundler sb = new StringBundler();
        sb.append("<plugins-summary>\n");
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(pluginsDir);
        ds.setIncludes(new String[]{"**\\liferay-plugin-package.properties", "**\\liferay-plugin-package.xml"});
        ds.scan();
        Object[] files = ds.getIncludedFiles();
        Arrays.sort(files);
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            this._createPluginSummary((String)file, sb);
            ++n2;
        }
        for (String author : this._distinctAuthors) {
            sb.append("\t<author>");
            sb.append(author);
            sb.append("</author>\n");
        }
        for (String license : this._distinctLicenses) {
            sb.append("\t<license>");
            sb.append(license);
            sb.append("</license>\n");
        }
        sb.append("</plugins-summary>");
        FileUtil.write((String)(pluginsDir + File.separator + "summary.xml"), (String)sb.toString());
    }

    private void _createPluginSummary(String file, StringBundler sb) throws Exception {
        String content = FileUtil.read((String)file);
        int x = file.indexOf(File.separatorChar);
        String type = file.substring(0, x);
        if (type.endsWith("s")) {
            type = type.substring(0, type.length() - 1);
        }
        x = file.indexOf(File.separator, x) + 1;
        int y = file.indexOf(File.separator, x);
        String artifactId = file.substring(x, y);
        String name = "";
        String tags = "";
        String shortDescription = "";
        String changeLog = "";
        String pageURL = "";
        String author = "";
        String licenses = "";
        if (file.endsWith(".properties")) {
            Properties properties = PropertiesUtil.load((String)content);
            name = this._readProperty(properties, "name");
            tags = this._readProperty(properties, "tags");
            shortDescription = this._readProperty(properties, "short-description");
            changeLog = this._readProperty(properties, "change-log");
            pageURL = this._readProperty(properties, "page-url");
            author = this._readProperty(properties, "author");
            licenses = this._readProperty(properties, "licenses");
        } else {
            Document doc = SAXReaderUtil.read((String)content);
            Element root = doc.getRootElement();
            name = root.elementText("name");
            tags = this._readList(root.element("tags"), "tag");
            shortDescription = root.elementText("short-description");
            changeLog = root.elementText("change-log");
            pageURL = root.elementText("page-url");
            author = root.elementText("author");
            licenses = this._readList(root.element("licenses"), "license");
        }
        this._distinctAuthors.add(author);
        this._distinctLicenses.add(licenses);
        sb.append("\t<plugin>\n");
        sb.append("\t\t<artifact-id>");
        sb.append(artifactId);
        sb.append("</artifact-id>\n");
        sb.append("\t\t<name>");
        sb.append(name);
        sb.append("</name>\n");
        sb.append("\t\t<type>");
        sb.append(type);
        sb.append("</type>\n");
        sb.append("\t\t<tags>");
        sb.append(tags);
        sb.append("</tags>\n");
        sb.append("\t\t<short-description>");
        sb.append(shortDescription);
        sb.append("</short-description>\n");
        sb.append("\t\t<change-log>");
        sb.append(changeLog);
        sb.append("</change-log>\n");
        sb.append("\t\t<page-url>");
        sb.append(pageURL);
        sb.append("</page-url>\n");
        sb.append("\t\t<author>");
        sb.append(author);
        sb.append("</author>\n");
        sb.append("\t\t<licenses>");
        sb.append(licenses);
        sb.append("</licenses>\n");
        sb.append("\t</plugin>\n");
    }

    private String _readList(Element parentEl, String name) {
        if (parentEl == null || parentEl.elements(name).isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(parentEl.elements(name).size() * 2 - 1);
        Iterator itr = parentEl.elements(name).iterator();
        while (itr.hasNext()) {
            Element el = (Element)itr.next();
            String text = el.getText().trim();
            sb.append(text);
            if (!itr.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public String _readProperty(Properties properties, String key) {
        return GetterUtil.getString((String)properties.getProperty(key));
    }
}

