/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.FileImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PluginsGitSvnSyncer {
    private static final String[] _PLUGIN_DIR_NAMES = new String[]{"", "/docroot", "/docroot/WEB-INF", "/docroot/WEB-INF/lib", "/docroot/WEB-INF/tld"};
    private static final String[] _PLUGIN_TYPES = new String[]{"clients", "ext", "hooks", "layouttpl", "portlets", "themes", "webs"};
    private static final String _SVN_DEL_IGNORES = "svn propdel svn:ignore ";
    private static final String _SVN_GET_IGNORES = "svn propget svn:ignore ";
    private static final String _SVN_SET_IGNORES = "svn propset svn:ignore ";
    private static FileImpl _fileUtil = FileImpl.getInstance();

    public static void main(String[] args) {
        String gitPluginsDirName = System.getProperty("git.plugins.dir");
        String svnPluginsDirName = System.getProperty("svn.plugins.dir");
        String syncTo = System.getProperty("sync.to");
        new PluginsGitSvnSyncer(gitPluginsDirName, svnPluginsDirName, syncTo);
    }

    public PluginsGitSvnSyncer(String gitPluginsDirName, String svnPluginsDirName, String syncTo) {
        try {
            if (!gitPluginsDirName.endsWith("/")) {
                gitPluginsDirName = String.valueOf(gitPluginsDirName) + "/";
            }
            if (!svnPluginsDirName.endsWith("/")) {
                svnPluginsDirName = String.valueOf(svnPluginsDirName) + "/";
            }
            if (syncTo.equals("git")) {
                this._updateGitIgnores(svnPluginsDirName, gitPluginsDirName);
            } else if (syncTo.equals("svn")) {
                this._updateSvnIgnores(gitPluginsDirName, svnPluginsDirName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String[] _exec(String cmd) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(cmd);
        String[] stdout = this._getExecOutput(process.getInputStream());
        String[] stderr = this._getExecOutput(process.getErrorStream());
        if (stderr.length > 0) {
            StringBundler sb = new StringBundler(stderr.length * 3 + 3);
            sb.append("Received errors in executing '");
            sb.append(cmd);
            sb.append("'\n");
            String[] stringArray = stderr;
            int n = stderr.length;
            int n2 = 0;
            while (n2 < n) {
                String err = stringArray[n2];
                sb.append("\t");
                sb.append(err);
                sb.append("\n");
                ++n2;
            }
            throw new Exception(sb.toString());
        }
        return stdout;
    }

    private String[] _getExecOutput(InputStream is) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        UnsyncBufferedReader unsyncBufferedReader = null;
        try {
            unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(is));
            String line = unsyncBufferedReader.readLine();
            while (line != null) {
                if (Validator.isNotNull((String)(line = line.trim()))) {
                    list.add(line);
                }
                line = unsyncBufferedReader.readLine();
            }
        }
        catch (Throwable throwable) {
            if (unsyncBufferedReader != null) {
                try {
                    unsyncBufferedReader.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (unsyncBufferedReader != null) {
            try {
                unsyncBufferedReader.close();
            }
            catch (Exception exception) {}
        }
        return list.toArray(new String[0]);
    }

    private void _updateGitIgnores(String srcDirName, String destDirName) throws Exception {
        String[] stringArray = _PLUGIN_TYPES;
        int n = _PLUGIN_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String[] dirNames;
            String pluginType = stringArray[n2];
            String[] stringArray2 = dirNames = _fileUtil.listDirs(String.valueOf(srcDirName) + pluginType);
            int n3 = dirNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String dirName = stringArray2[n4];
                if (!dirName.equals(".svn")) {
                    String[] stringArray3 = _PLUGIN_DIR_NAMES;
                    int n5 = _PLUGIN_DIR_NAMES.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String pluginDirName = stringArray3[n6];
                        this._updateGitIgnores(String.valueOf(srcDirName) + pluginType + "/", String.valueOf(destDirName) + pluginType + "/", String.valueOf(dirName) + pluginDirName + "/");
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void _updateGitIgnores(String srcDirName, String destDirName, String dirName) throws Exception {
        File gitIgnoreFile = new File(String.valueOf(destDirName) + dirName + ".gitignore");
        if (!_fileUtil.exists(String.valueOf(srcDirName) + dirName + ".svn")) {
            _fileUtil.delete(gitIgnoreFile);
            return;
        }
        List ignores = null;
        ignores = !dirName.contains("/docroot/") ? Collections.emptyList() : ListUtil.fromArray((Object[])this._exec(_SVN_GET_IGNORES + srcDirName + dirName));
        Collections.sort(ignores);
        Iterator itr = ignores.iterator();
        while (itr.hasNext()) {
            String ignore = (String)itr.next();
            if (!ignore.equals("classes")) continue;
            itr.remove();
        }
        if (!ignores.isEmpty()) {
            Object[] ignoresArray = ignores.toArray(new String[ignores.size()]);
            int i = 0;
            while (i < ignoresArray.length) {
                String ignore = ignoresArray[i];
                if (Validator.isNotNull((String)ignore) && !ignore.startsWith("/")) {
                    ignoresArray[i] = "/" + ignore;
                }
                ++i;
            }
            _fileUtil.write(String.valueOf(destDirName) + dirName + ".gitignore", StringUtil.merge((Object[])ignoresArray, (String)"\n"));
        } else {
            _fileUtil.delete(gitIgnoreFile);
        }
    }

    private void _updateSvnIgnores(String srcDirName, String destDirName) throws Exception {
        String[] stringArray = _PLUGIN_TYPES;
        int n = _PLUGIN_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String[] dirNames;
            String pluginType = stringArray[n2];
            String[] stringArray2 = dirNames = _fileUtil.listDirs(String.valueOf(srcDirName) + pluginType);
            int n3 = dirNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String dirName = stringArray2[n4];
                String[] stringArray3 = _PLUGIN_DIR_NAMES;
                int n5 = _PLUGIN_DIR_NAMES.length;
                int n6 = 0;
                while (n6 < n5) {
                    String pluginDirName = stringArray3[n6];
                    this._updateSvnIgnores(String.valueOf(srcDirName) + pluginType + "/", String.valueOf(destDirName) + pluginType + "/", String.valueOf(dirName) + pluginDirName + "/");
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void _updateSvnIgnores(String srcDirName, String destDirName, String dirName) throws Exception {
        if (!_fileUtil.exists(String.valueOf(destDirName) + dirName)) {
            return;
        }
        File gitIgnoreFile = new File(String.valueOf(srcDirName) + dirName + ".gitignore");
        File svnDir = new File(String.valueOf(destDirName) + dirName + ".svn");
        if (gitIgnoreFile.exists() && !svnDir.exists()) {
            System.out.println("Invalid SVN directory " + destDirName + dirName);
            return;
        }
        ArrayList<String> ignores = null;
        if (!dirName.contains("/docroot")) {
            ignores = new ArrayList<String>();
            ignores.add("bin");
            ignores.add("classes");
            ignores.add("tmp");
        } else {
            ignores = ListUtil.fromFile((File)gitIgnoreFile);
            int i = 0;
            while (i < ignores.size()) {
                String ignore = (String)ignores.get(i);
                if (ignore.startsWith("/")) {
                    ignore = ignore.substring(1);
                }
                ignores.set(i, ignore);
                ++i;
            }
            if (dirName.endsWith("/docroot/WEB-INF/") && !ignores.contains("classes")) {
                ignores.add("classes");
            }
        }
        Collections.sort(ignores);
        if (ignores.isEmpty() && !svnDir.exists()) {
            return;
        }
        if (ignores.isEmpty()) {
            block14: {
                try {
                    this._exec(_SVN_DEL_IGNORES + destDirName + dirName);
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    if (message.contains("svn: Attempting to delete nonexistent property 'svn:ignore'")) break block14;
                    throw e;
                }
            }
            return;
        }
        File tempFile = File.createTempFile("svn-ignores-", null, null);
        try {
            Object[] ignoresArray = ignores.toArray(new String[ignores.size()]);
            _fileUtil.write(tempFile, StringUtil.merge((Object[])ignoresArray, (String)"\n"));
            this._exec("svn propset svn:ignore -F \"" + tempFile.getCanonicalPath() + "\" \"" + destDirName + dirName + "\"");
        }
        finally {
            _fileUtil.delete(tempFile);
        }
    }
}

