/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.UniqueList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.oro.io.GlobFilenameFilter;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginsEnvironmentBuilder {
    private static final String _BRANCH = "trunk";
    private static final String[] _SOURCE_DIR_NAMES = new String[]{"docroot/WEB-INF/ext-impl/src", "docroot/WEB-INF/ext-service/src", "docroot/WEB-INF/ext-util-bridges/src", "docroot/WEB-INF/ext-util-java/src", "docroot/WEB-INF/ext-util-taglib/src", "docroot/WEB-INF/service", "docroot/WEB-INF/src"};
    private static FileImpl _fileUtil = FileImpl.getInstance();

    public static void main(String[] args) throws Exception {
        try {
            File dir = new File(System.getProperty("plugins.env.dir"));
            new PluginsEnvironmentBuilder(dir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PluginsEnvironmentBuilder(File dir) throws Exception {
        String[] fileNames;
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(dir);
        ds.setIncludes(new String[]{"**\\liferay-plugin-package.properties"});
        ds.scan();
        String dirName = dir.getCanonicalPath();
        String[] stringArray = fileNames = ds.getIncludedFiles();
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            this.setupProject(dirName, fileName);
            ++n2;
        }
    }

    protected void addClasspathEntry(StringBundler sb, String jar) {
        this.addClasspathEntry(sb, jar, null);
    }

    protected void addClasspathEntry(StringBundler sb, String jar, Map<String, String> attributes) {
        sb.append("\t<classpathentry kind=\"lib\" path=\"");
        sb.append(jar);
        if (attributes == null || attributes.isEmpty()) {
            sb.append("\" />\n");
            return;
        }
        sb.append("\">\n\t\t<attributes>\n");
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            sb.append("\t\t\t<attribute name=\"");
            sb.append(entry.getKey());
            sb.append("\" value=\"");
            sb.append(entry.getValue());
            sb.append("\" />\n");
        }
        sb.append("\t\t</attributes>\n\t</classpathentry>\n");
    }

    protected void setupProject(String dirName, String fileName) throws Exception {
        File propertiesFile = new File(String.valueOf(dirName) + "/" + fileName);
        File libDir = new File(String.valueOf(propertiesFile.getParent()) + "/lib");
        String libDirPath = StringUtil.replace((String)libDir.getPath(), (String)"\\", (String)"/");
        if (libDirPath.contains("/themes/")) {
            return;
        }
        File projectDir = new File(String.valueOf(propertiesFile.getParent()) + "/../..");
        Properties properties = new Properties();
        properties.load(new FileInputStream(propertiesFile));
        Object[] dependencyJars = StringUtil.split((String)properties.getProperty("portal-dependency-jars", properties.getProperty("portal.dependency.jars")));
        List jars = ListUtil.toList((Object[])dependencyJars);
        jars.add("commons-logging.jar");
        jars.add("log4j.jar");
        jars.add("util-bridges.jar");
        jars.add("util-java.jar");
        jars.add("util-taglib.jar");
        Collections.sort(jars);
        this.writeEclipseFiles(libDir, projectDir, (String[])dependencyJars);
        List ignores = ListUtil.fromFile((String)(String.valueOf(libDir.getCanonicalPath()) + "/../.gitignore"));
        if (!libDirPath.contains("/ext/") && !ignores.contains("/lib")) {
            File gitignoreFile = new File(String.valueOf(libDir.getCanonicalPath()) + "/.gitignore");
            System.out.println("Updating " + gitignoreFile);
            Object[] gitIgnores = jars.toArray(new String[jars.size()]);
            int i = 0;
            while (i < gitIgnores.length) {
                String gitIgnore = gitIgnores[i];
                if (Validator.isNotNull((String)gitIgnore) && !gitIgnore.startsWith("/")) {
                    gitIgnores[i] = "/" + gitIgnore;
                }
                ++i;
            }
            _fileUtil.write(gitignoreFile, StringUtil.merge((Object[])gitIgnores, (String)"\n"));
        }
    }

    protected void writeClasspathFile(File libDir, String[] dependencyJars, String projectDirName, String projectName, boolean javaProject) throws Exception {
        File classpathFile = new File(String.valueOf(projectDirName) + "/.classpath");
        if (!javaProject) {
            classpathFile.delete();
            return;
        }
        UniqueList globalJars = new UniqueList();
        UniqueList portalJars = new UniqueList();
        UniqueList extGlobalJars = new UniqueList();
        UniqueList extPortalJars = new UniqueList();
        String libDirPath = StringUtil.replace((String)libDir.getPath(), (String)"\\", (String)"/");
        if (libDirPath.contains("/ext/")) {
            GlobFilenameFilter filenameFilter = new GlobFilenameFilter("*.jar");
            String[] stringArray = new String[]{"global", "portal"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] fileNames;
                File dir;
                String dirName = stringArray[n2];
                File file = new File(String.valueOf(libDirPath) + "/../ext-lib/" + dirName);
                List jars = ListUtil.toList((Object[])file.list((FilenameFilter)filenameFilter));
                if (dirName.equals("global")) {
                    extGlobalJars.addAll(ListUtil.sort((List)jars));
                    dir = new File(PropsValues.LIFERAY_LIB_GLOBAL_DIR);
                    fileNames = dir.list((FilenameFilter)filenameFilter);
                    globalJars.addAll(ListUtil.sort((List)ListUtil.toList((Object[])fileNames)));
                    globalJars.removeAll((Collection<?>)extGlobalJars);
                } else if (dirName.equals("portal")) {
                    extPortalJars.addAll(ListUtil.sort((List)jars));
                    dir = new File(PropsValues.LIFERAY_LIB_PORTAL_DIR);
                    fileNames = dir.list((FilenameFilter)filenameFilter);
                    portalJars.addAll(ListUtil.sort((List)ListUtil.toList((Object[])fileNames)));
                    portalJars.removeAll((Collection<?>)extPortalJars);
                }
                ++n2;
            }
        } else {
            globalJars.add("portlet.jar");
            portalJars.addAll(ListUtil.toList((Object[])dependencyJars));
            portalJars.add("commons-logging.jar");
            portalJars.add("log4j.jar");
            Collections.sort(portalJars);
        }
        Object[] customJarsArray = libDir.list((FilenameFilter)new GlobFilenameFilter("*.jar"));
        ArrayList customJars = null;
        if (customJarsArray != null) {
            customJars = ListUtil.toList((Object[])customJarsArray);
            for (String jar : portalJars) {
                customJars.remove(jar);
            }
            customJars.remove(String.valueOf(projectName) + "-service.jar");
            customJars.remove("util-bridges.jar");
            customJars.remove("util-java.jar");
            customJars.remove("util-taglib.jar");
            Collections.sort(customJars);
        } else {
            customJars = new ArrayList();
        }
        StringBundler sb = new StringBundler();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        sb.append("<classpath>\n");
        String[] stringArray = _SOURCE_DIR_NAMES;
        int n = _SOURCE_DIR_NAMES.length;
        int n3 = 0;
        while (n3 < n) {
            String sourceDirName = stringArray[n3];
            if (_fileUtil.exists(String.valueOf(projectDirName) + "/" + sourceDirName)) {
                sb.append("\t<classpathentry excluding=\"**/.svn/**|.svn/\" ");
                sb.append("kind=\"src\" path=\"" + sourceDirName + "\" />\n");
            }
            ++n3;
        }
        sb.append("\t<classpathentry kind=\"src\" path=\"/portal\" />\n");
        sb.append("\t<classpathentry kind=\"con\" ");
        sb.append("path=\"org.eclipse.jdt.launching.JRE_CONTAINER\" />\n");
        if (_fileUtil.exists(String.valueOf(projectDirName) + "/test")) {
            sb.append("\t<classpathentry excluding=\"**/.svn/**|.svn/\" ");
            sb.append("kind=\"src\" path=\"test\" />\n");
            this.addClasspathEntry(sb, "/portal/lib/development/junit.jar");
            this.addClasspathEntry(sb, "/portal/lib/portal/commons-io.jar");
        }
        this.addClasspathEntry(sb, "/portal/lib/development/activation.jar");
        this.addClasspathEntry(sb, "/portal/lib/development/annotations.jar");
        this.addClasspathEntry(sb, "/portal/lib/development/jsp-api.jar");
        this.addClasspathEntry(sb, "/portal/lib/development/mail.jar");
        this.addClasspathEntry(sb, "/portal/lib/development/servlet-api.jar");
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (libDirPath.contains("/ext/")) {
            attributes.put("optional", "true");
        }
        for (String jar : globalJars) {
            this.addClasspathEntry(sb, "/portal/lib/global/" + jar, attributes);
        }
        for (String jar : portalJars) {
            this.addClasspathEntry(sb, "/portal/lib/portal/" + jar, attributes);
        }
        this.addClasspathEntry(sb, "/portal/portal-service/portal-service.jar");
        this.addClasspathEntry(sb, "/portal/util-bridges/util-bridges.jar");
        this.addClasspathEntry(sb, "/portal/util-java/util-java.jar");
        this.addClasspathEntry(sb, "/portal/util-taglib/util-taglib.jar");
        for (String jar : extGlobalJars) {
            this.addClasspathEntry(sb, "docroot/WEB-INF/ext-lib/global/" + jar);
        }
        for (String jar : extPortalJars) {
            this.addClasspathEntry(sb, "docroot/WEB-INF/ext-lib/portal/" + jar);
        }
        for (String jar : customJars) {
            if (libDirPath.contains("/tmp/WEB-INF/lib")) {
                this.addClasspathEntry(sb, "tmp/WEB-INF/lib/" + jar);
                continue;
            }
            this.addClasspathEntry(sb, "docroot/WEB-INF/lib/" + jar);
        }
        sb.append("\t<classpathentry kind=\"output\" path=\"bin\" />\n");
        sb.append("</classpath>");
        System.out.println("Updating " + classpathFile);
        String content = StringUtil.replace((String)sb.toString(), (String)"\"/portal", (String)"\"/portal-trunk");
        _fileUtil.write(classpathFile, content);
    }

    protected void writeEclipseFiles(File libDir, File projectDir, String[] dependencyJars) throws Exception {
        String sourceDirName;
        String projectDirName = projectDir.getCanonicalPath();
        String projectName = StringUtil.extractLast((String)projectDirName, (char)File.separatorChar);
        boolean javaProject = false;
        String[] stringArray = _SOURCE_DIR_NAMES;
        int n = _SOURCE_DIR_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            sourceDirName = stringArray[n2];
            if (_fileUtil.exists(String.valueOf(projectDirName) + "/" + sourceDirName)) {
                javaProject = true;
                break;
            }
            ++n2;
        }
        if (!javaProject) {
            System.out.println("Eclipse Java project will not be used because a source folder does not exist");
        }
        this.writeProjectFile(projectDirName, projectName, javaProject);
        this.writeClasspathFile(libDir, dependencyJars, projectDirName, projectName, javaProject);
        stringArray = _SOURCE_DIR_NAMES;
        n = _SOURCE_DIR_NAMES.length;
        n2 = 0;
        while (n2 < n) {
            block11: {
                ArrayList<String> gitIgnores;
                block13: {
                    block16: {
                        block15: {
                            block14: {
                                block12: {
                                    sourceDirName = stringArray[n2];
                                    if (!_fileUtil.exists(String.valueOf(projectDirName) + "/" + sourceDirName)) break block11;
                                    gitIgnores = new ArrayList<String>();
                                    if (!sourceDirName.endsWith("ext-impl/src")) break block12;
                                    gitIgnores.add("/classes");
                                    gitIgnores.add("/ext-impl.jar");
                                    break block13;
                                }
                                if (!sourceDirName.endsWith("ext-service/src")) break block14;
                                gitIgnores.add("/classes");
                                gitIgnores.add("/ext-service.jar");
                                break block13;
                            }
                            if (!sourceDirName.endsWith("ext-util-bridges/src")) break block15;
                            gitIgnores.add("/classes");
                            gitIgnores.add("/ext-util-bridges.jar");
                            break block13;
                        }
                        if (!sourceDirName.endsWith("ext-util-java/src")) break block16;
                        gitIgnores.add("/classes");
                        gitIgnores.add("/ext-util-java.jar");
                        break block13;
                    }
                    if (!sourceDirName.endsWith("ext-util-taglib/src")) break block11;
                    gitIgnores.add("/classes");
                    gitIgnores.add("/ext-util-taglib.jar");
                }
                String dirName = String.valueOf(projectDirName) + "/" + sourceDirName + "/../";
                if (gitIgnores.isEmpty()) {
                    _fileUtil.delete(String.valueOf(dirName) + ".gitignore");
                } else {
                    String gitIgnoresString = StringUtil.merge(gitIgnores, (String)"\n");
                    _fileUtil.write(String.valueOf(dirName) + ".gitignore", gitIgnoresString);
                }
            }
            ++n2;
        }
        if (_fileUtil.exists(String.valueOf(projectDirName) + "/test")) {
            _fileUtil.write(String.valueOf(projectDirName) + "/.gitignore", "/test-classes\n/test-results");
        } else {
            _fileUtil.delete(String.valueOf(projectDirName) + "/.gitignore");
        }
    }

    protected void writeProjectFile(String projectDirName, String projectName, boolean javaProject) throws Exception {
        StringBundler sb = new StringBundler(17);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        sb.append("<projectDescription>\n");
        sb.append("\t<name>");
        sb.append(projectName);
        sb.append("-");
        sb.append(_BRANCH);
        sb.append("</name>\n");
        sb.append("\t<comment></comment>\n");
        sb.append("\t<projects></projects>\n");
        sb.append("\t<buildSpec>\n");
        if (javaProject) {
            sb.append("\t\t<buildCommand>\n");
            sb.append("\t\t\t<name>org.eclipse.jdt.core.javabuilder</name>\n");
            sb.append("\t\t\t<arguments></arguments>\n");
            sb.append("\t\t</buildCommand>\n");
        }
        sb.append("\t</buildSpec>\n");
        sb.append("\t<natures>\n");
        if (javaProject) {
            sb.append("\t\t<nature>org.eclipse.jdt.core.javanature</nature>\n");
        }
        sb.append("\t</natures>\n");
        sb.append("</projectDescription>");
        File projectFile = new File(String.valueOf(projectDirName) + "/.project");
        System.out.println("Updating " + projectFile);
        _fileUtil.write(projectFile, sb.toString());
    }
}

