/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.OutputStreamWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.util.InitUtil;
import com.liferay.portlet.translator.model.Translation;
import com.liferay.portlet.translator.util.TranslationWebCacheItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LangBuilder {
    public static final String AUTOMATIC_COPY = " (Automatic Copy)";
    public static final String AUTOMATIC_TRANSLATION = " (Automatic Translation)";
    private String _langDir;
    private String _langFile;
    private boolean _langTranslate;
    private Properties _portalLanguageProperties;
    private Properties _renameKeys;

    public static void main(String[] args) {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        System.setProperty("line.separator", "\n");
        InitUtil.initWithSpring();
        String langDir = arguments.get("lang.dir");
        String langFile = arguments.get("lang.file");
        boolean langPlugin = GetterUtil.getBoolean((String)arguments.get("lang.plugin"));
        boolean langTranslate = GetterUtil.getBoolean((String)arguments.get("lang.translate"), (boolean)true);
        try {
            new LangBuilder(langDir, langFile, langPlugin, langTranslate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LangBuilder(String langDir, String langFile, boolean langPlugin, boolean langTranslate) throws Exception {
        File renameKeysFile;
        this._langDir = langDir;
        this._langFile = langFile;
        this._langTranslate = langTranslate;
        if (langPlugin) {
            this._portalLanguageProperties = new Properties();
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("content/Language.properties");
            this._portalLanguageProperties.load(inputStream);
        }
        if ((renameKeysFile = new File(String.valueOf(this._langDir) + "/rename.properties")).exists()) {
            this._renameKeys = PropertiesUtil.load((String)FileUtil.read((File)renameKeysFile));
        }
        String content = this._orderProperties(new File(String.valueOf(this._langDir) + "/" + this._langFile + ".properties"));
        this._orderProperties(new File(String.valueOf(this._langDir) + "/" + this._langFile + "_en_GB.properties"));
        this._createProperties(content, "ar");
        this._createProperties(content, "eu");
        this._createProperties(content, "bg");
        this._createProperties(content, "ca");
        this._createProperties(content, "zh_CN");
        this._createProperties(content, "zh_TW");
        this._createProperties(content, "hr");
        this._createProperties(content, "cs");
        this._createProperties(content, "nl");
        this._createProperties(content, "nl_BE", "nl");
        this._createProperties(content, "et");
        this._createProperties(content, "fi");
        this._createProperties(content, "fr");
        this._createProperties(content, "gl");
        this._createProperties(content, "de");
        this._createProperties(content, "el");
        this._createProperties(content, "iw");
        this._createProperties(content, "hi_IN");
        this._createProperties(content, "hu");
        this._createProperties(content, "in");
        this._createProperties(content, "it");
        this._createProperties(content, "ja");
        this._createProperties(content, "ko");
        this._createProperties(content, "nb");
        this._createProperties(content, "fa");
        this._createProperties(content, "pl");
        this._createProperties(content, "pt_BR");
        this._createProperties(content, "pt_PT", "pt_BR");
        this._createProperties(content, "ro");
        this._createProperties(content, "ru");
        this._createProperties(content, "sr_RS");
        this._createProperties(content, "sr_RS_latin");
        this._createProperties(content, "sk");
        this._createProperties(content, "sl");
        this._createProperties(content, "es");
        this._createProperties(content, "sv");
        this._createProperties(content, "tr");
        this._createProperties(content, "uk");
        this._createProperties(content, "vi");
    }

    private void _createProperties(String content, String languageId) throws IOException {
        this._createProperties(content, languageId, null);
    }

    private void _createProperties(String content, String languageId, String parentLanguageId) throws IOException {
        String translationId;
        File parentPropertiesFile;
        File propertiesFile = new File(String.valueOf(this._langDir) + "/" + this._langFile + "_" + languageId + ".properties");
        Properties properties = new Properties();
        if (propertiesFile.exists()) {
            properties = PropertiesUtil.load((InputStream)new FileInputStream(propertiesFile), (String)"UTF-8");
        }
        Properties parentProperties = null;
        if (parentLanguageId != null && (parentPropertiesFile = new File(String.valueOf(this._langDir) + "/" + this._langFile + "_" + parentLanguageId + ".properties")).exists()) {
            parentProperties = new Properties();
            parentProperties = PropertiesUtil.load((InputStream)new FileInputStream(parentPropertiesFile), (String)"UTF-8");
        }
        if ((translationId = "en_" + languageId).equals("en_pt_BR")) {
            translationId = "en_pt";
        } else if (translationId.equals("en_pt_PT")) {
            translationId = "en_pt";
        } else if (translationId.equals("en_zh_CN")) {
            translationId = "en_zh";
        } else if (translationId.equals("en_zh_TW")) {
            translationId = "en_zt";
        } else if (translationId.equals("en_hi_IN")) {
            translationId = "en_hi";
        }
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        UnsyncBufferedWriter unsyncBufferedWriter = new UnsyncBufferedWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(propertiesFile), "UTF-8"));
        int state = 0;
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            int pos = (line = line.trim()).indexOf("=");
            if (pos != -1) {
                String renameKey;
                String key = line.substring(0, pos);
                String value = line.substring(pos + 1, line.length());
                if (state == 1 && !key.startsWith("lang.") || state == 2 && !key.startsWith("javax.portlet.") || state == 3 && !key.startsWith("category.") || state == 4 && !key.startsWith("model.resource.") || state == 5 && !key.startsWith("action.") || state == 7 && !key.startsWith("currency.") || state != 7 && key.startsWith("currency.")) {
                    throw new RuntimeException("File " + languageId + " with state " + state + " has key " + key);
                }
                String translatedText = properties.getProperty(key);
                if (translatedText == null && parentProperties != null) {
                    translatedText = parentProperties.getProperty(key);
                }
                if (translatedText == null && this._renameKeys != null && (renameKey = this._renameKeys.getProperty(key)) != null && (translatedText = properties.getProperty(key)) == null && parentProperties != null) {
                    translatedText = parentProperties.getProperty(key);
                }
                if (translatedText != null) {
                    if (translatedText.contains("Babel Fish") || translatedText.contains("Yahoo! - 999")) {
                        translatedText = "";
                    } else if (translatedText.endsWith(AUTOMATIC_COPY)) {
                        translatedText = String.valueOf(value) + AUTOMATIC_COPY;
                    }
                }
                if (translatedText == null || translatedText.equals("")) {
                    if (line.contains("{") || line.contains("<")) {
                        translatedText = String.valueOf(value) + AUTOMATIC_COPY;
                    } else if (line.contains("[")) {
                        pos = line.indexOf("[");
                        String baseKey = line.substring(0, pos);
                        translatedText = String.valueOf(properties.getProperty(baseKey)) + AUTOMATIC_COPY;
                    } else {
                        translatedText = key.equals("lang.dir") ? "ltr" : (key.equals("lang.line.begin") ? "left" : (key.equals("lang.line.end") ? "right" : (translationId.equals("en_el") && (key.equals("enabled") || key.equals("on") || key.equals("on-date")) ? "" : (translationId.equals("en_es") && key.equals("am") ? "" : (translationId.equals("en_it") && key.equals("am") ? "" : (translationId.equals("en_ja") && (key.equals("any") || key.equals("anytime") || key.equals("down") || key.equals("on") || key.equals("on-date") || key.equals("the")) ? "" : (translationId.equals("en_ko") && key.equals("the") ? "" : (Validator.isNull((String)(translatedText = this._translate(translationId, key, value, 0))) ? String.valueOf(value) + AUTOMATIC_COPY : String.valueOf(translatedText) + AUTOMATIC_TRANSLATION))))))));
                    }
                }
                if (!Validator.isNotNull((String)translatedText)) continue;
                if (translatedText.contains("Babel Fish") || translatedText.contains("Yahoo! - 999")) {
                    throw new IOException("IP was blocked because of over usage. Please use another IP.");
                }
                translatedText = this._fixTranslation(translatedText);
                unsyncBufferedWriter.write(String.valueOf(key) + "=" + translatedText);
                unsyncBufferedWriter.newLine();
                unsyncBufferedWriter.flush();
                continue;
            }
            if (line.startsWith("## Language settings")) {
                if (state == 1) {
                    throw new RuntimeException(languageId);
                }
                state = 1;
            } else if (line.startsWith("## Portlet descriptions and titles")) {
                if (state == 2) {
                    throw new RuntimeException(languageId);
                }
                state = 2;
            } else if (line.startsWith("## Category titles")) {
                if (state == 3) {
                    throw new RuntimeException(languageId);
                }
                state = 3;
            } else if (line.startsWith("## Model resources")) {
                if (state == 4) {
                    throw new RuntimeException(languageId);
                }
                state = 4;
            } else if (line.startsWith("## Action names")) {
                if (state == 5) {
                    throw new RuntimeException(languageId);
                }
                state = 5;
            } else if (line.startsWith("## Messages")) {
                if (state == 6) {
                    throw new RuntimeException(languageId);
                }
                state = 6;
            } else if (line.startsWith("## Currency")) {
                if (state == 7) {
                    throw new RuntimeException(languageId);
                }
                state = 7;
            }
            unsyncBufferedWriter.write(line);
            unsyncBufferedWriter.newLine();
            unsyncBufferedWriter.flush();
        }
        unsyncBufferedReader.close();
        unsyncBufferedWriter.close();
    }

    private String _fixEnglishTranslation(String key, String value) {
        if (!(!value.contains(" this ") || value.contains(".") || value.contains("?") || value.contains(":") || key.equals("the-url-of-the-page-comparing-this-page-content-with-the-previous-version"))) {
            value = StringUtil.replace((String)value, (String)" this ", (String)" This ");
        }
        return value;
    }

    private String _fixTranslation(String value) {
        value = StringUtil.replace((String)value.trim(), (String[])new String[]{"  ", "<b>", "</b>", "<i>", "</i>", " url ", "&#39;", "&#39 ;", "&quot;", "&quot ;"}, (String[])new String[]{" ", "<strong>", "</strong>", "<em>", "</em>", " URL ", "'", "'", "\"", "\""});
        return value;
    }

    private String _orderProperties(File propertiesFile) throws IOException {
        if (!propertiesFile.exists()) {
            return null;
        }
        String content = FileUtil.read((File)propertiesFile);
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        UnsyncBufferedWriter unsyncBufferedWriter = new UnsyncBufferedWriter((Writer)new FileWriter(propertiesFile));
        TreeSet<String> messages = new TreeSet<String>();
        boolean begin = false;
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            int pos = line.indexOf("=");
            if (pos != -1) {
                String portalValue;
                String key = line.substring(0, pos);
                String value = this._fixTranslation(line.substring(pos + 1, line.length()));
                value = this._fixEnglishTranslation(key, value);
                if (this._portalLanguageProperties != null && value.equals(portalValue = String.valueOf(this._portalLanguageProperties.get(key)))) {
                    System.out.println("Duplicate key " + key);
                }
                messages.add(String.valueOf(key) + "=" + value);
            } else {
                if (begin && line.equals("")) {
                    this._sortAndWrite(unsyncBufferedWriter, messages);
                }
                if (line.equals("")) {
                    begin = !begin;
                }
                unsyncBufferedWriter.write(line);
                unsyncBufferedWriter.newLine();
            }
            unsyncBufferedWriter.flush();
        }
        if (messages.size() > 0) {
            this._sortAndWrite(unsyncBufferedWriter, messages);
        }
        unsyncBufferedReader.close();
        unsyncBufferedWriter.close();
        return FileUtil.read((File)propertiesFile);
    }

    private void _sortAndWrite(UnsyncBufferedWriter unsyncBufferedWriter, Set<String> messages) throws IOException {
        String[] messagesArray = messages.toArray(new String[messages.size()]);
        int i = 0;
        while (i < messagesArray.length) {
            unsyncBufferedWriter.write(messagesArray[i]);
            unsyncBufferedWriter.newLine();
            ++i;
        }
        messages.clear();
    }

    private String _translate(String translationId, String key, String fromText, int limit) {
        if (translationId.equals("en_ar") || translationId.equals("en_eu") || translationId.equals("en_bg") || translationId.equals("en_ca") || translationId.equals("en_hr") || translationId.equals("en_cs") || translationId.equals("en_fi") || translationId.equals("en_gl") || translationId.equals("en_iw") || translationId.equals("en_hi") || translationId.equals("en_hu") || translationId.equals("en_in") || translationId.equals("en_nb") || translationId.equals("en_fa") || translationId.equals("en_pl") || translationId.equals("en_ro") || translationId.equals("en_ru") || translationId.equals("en_sr_RS") || translationId.equals("en_sr_RS_latin") || translationId.equals("en_sk") || translationId.equals("en_sl") || translationId.equals("en_sv") || translationId.equals("en_tr") || translationId.equals("en_uk") || translationId.equals("en_vi") || translationId.equals("en_et")) {
            return null;
        }
        if (!this._langTranslate) {
            return null;
        }
        if (limit == 3) {
            return null;
        }
        String toText = null;
        try {
            System.out.println("Translating " + translationId + " " + key + " " + fromText);
            TranslationWebCacheItem wci = new TranslationWebCacheItem(translationId, fromText);
            Translation translation = (Translation)wci.convert("");
            toText = translation.getToText();
            if (toText != null && toText.contains("Babel Fish")) {
                toText = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (toText == null) {
            return this._translate(translationId, key, fromText, ++limit);
        }
        return toText;
    }
}

