/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;

public class EARBuilder {
    public static void main(String[] args) {
        InitUtil.initWithSpring();
        if (args.length != 2) {
            throw new IllegalArgumentException();
        }
        new EARBuilder(args[0], StringUtil.split((String)args[1]));
    }

    public EARBuilder(String originalApplicationXML, String[] pluginFileNames) {
        try {
            Document document = SAXReaderUtil.read((File)new File(originalApplicationXML));
            Element rootElement = document.getRootElement();
            String[] stringArray = pluginFileNames;
            int n = pluginFileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String pluginFileName = stringArray[n2];
                Element moduleElement = rootElement.addElement("module");
                Element webElement = moduleElement.addElement("web");
                Element webURIElement = webElement.addElement("web-uri");
                webURIElement.addText(pluginFileName);
                Element contextRootElement = webElement.addElement("context-root");
                String contextRoot = this._getContextRoot(pluginFileName);
                contextRootElement.addText(contextRoot);
                ++n2;
            }
            FileUtil.write((String)originalApplicationXML, (String)document.formattedString(), (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String _getContextRoot(String pluginFileName) {
        String contextRoot = pluginFileName;
        int pos = contextRoot.lastIndexOf(".war");
        if (pos != -1) {
            contextRoot = contextRoot.substring(0, pos);
        }
        if (contextRoot.equals("liferay-portal")) {
            contextRoot = PropsValues.PORTAL_CTX;
            if (contextRoot.equals("/")) {
                contextRoot = "";
            } else if (contextRoot.startsWith("/")) {
                contextRoot = contextRoot.substring(1);
            }
        }
        return "/".concat(contextRoot);
    }
}

