/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.theme;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;

public class ThemeLoader {
    private static Log _log = LogFactoryUtil.getLog(ThemeLoader.class);
    private String _servletContextName;
    private ServletContext _servletContext;
    private String _themesPath;
    private File _fileStorage;
    private boolean _loadFromServletContext = true;
    private Map<String, Long> _lastModifiedMap = new HashMap<String, Long>();

    public String getServletContextName() {
        return this._servletContextName;
    }

    public String getThemesPath() {
        return this._themesPath;
    }

    public File getFileStorage() {
        return this._fileStorage;
    }

    public synchronized void loadThemes() {
        File[] files;
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Loading themes in " + this._fileStorage));
        }
        if ((files = this._fileStorage.listFiles()) == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("There are no directories to process for " + this._fileStorage));
            }
            return;
        }
        int i = 0;
        while (i < files.length) {
            File liferayLookAndFeelXML;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Process directory " + files[i]));
            }
            if ((liferayLookAndFeelXML = new File(files[i] + "/liferay-look-and-feel.xml")).exists()) {
                String lastModifiedKey = liferayLookAndFeelXML.toString();
                Long prevLastModified = this._lastModifiedMap.get(lastModifiedKey);
                long lastModified = liferayLookAndFeelXML.lastModified();
                if (prevLastModified == null || prevLastModified < lastModified) {
                    this.registerTheme(liferayLookAndFeelXML);
                    this._lastModifiedMap.put(lastModifiedKey, lastModified);
                } else if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Do not refresh " + liferayLookAndFeelXML + " because it is has not been modified"));
                }
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)(liferayLookAndFeelXML + " does not exist"));
            }
            ++i;
        }
    }

    protected ThemeLoader(String servletContextName, ServletContext servletContext, String[] xmls) {
        this._servletContextName = servletContextName;
        this._servletContext = servletContext;
        try {
            Document doc = SAXReaderUtil.read((String)xmls[0], (boolean)true);
            Element root = doc.getRootElement();
            this._themesPath = GetterUtil.getString((String)root.elementText("themes-path"), (String)"/themes");
            String fileStorageValue = PropsValues.THEME_LOADER_STORAGE_PATH;
            fileStorageValue = GetterUtil.getString((String)root.elementText("file-storage"), (String)fileStorageValue);
            if (Validator.isNotNull((String)fileStorageValue)) {
                this._fileStorage = new File(fileStorageValue);
                this._loadFromServletContext = false;
            } else {
                this._fileStorage = new File(servletContext.getRealPath(this._themesPath));
                this._loadFromServletContext = true;
            }
            if (!this._fileStorage.exists()) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("File storage " + this._fileStorage + " does not exist"));
                }
                if (!this._fileStorage.mkdirs()) {
                    _log.error((Object)("Unable to create theme loader file storage at " + this._fileStorage));
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        this.loadThemes();
    }

    protected void destroy() {
    }

    protected void registerTheme(File liferayLookAndFeelXML) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Registering " + liferayLookAndFeelXML));
        }
        try {
            String content = FileUtil.read((File)liferayLookAndFeelXML);
            ThemeLocalServiceUtil.init((String)this._servletContextName, (ServletContext)this._servletContext, (String)this._themesPath, (boolean)this._loadFromServletContext, (String[])new String[]{content}, null);
        }
        catch (Exception e) {
            _log.error((Object)("Error registering theme " + liferayLookAndFeelXML.toString()), (Throwable)e);
        }
    }
}

