/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.struts.InitializableActionForm;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.struts.PortletActionAdapter;
import com.liferay.portal.struts.StrutsActionRegistryUtil;
import com.liferay.portal.struts.StrutsURLEncoder;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.portlet.PortletConfigImpl;
import com.liferay.portlet.PortletRequestDispatcherImpl;
import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.tiles.TilesRequestProcessor;
import org.apache.struts.util.MessageResources;

public class PortletRequestProcessor
extends TilesRequestProcessor {
    private static final String _PATH_PORTAL_PORTLET_ACCESS_DENIED = "/portal/portlet_access_denied";
    private static final String _PATH_PORTAL_PORTLET_INACTIVE = "/portal/portlet_inactive";
    private static Log _log = LogFactoryUtil.getLog(PortletRequestProcessor.class);

    public static PortletRequestProcessor getInstance(ActionServlet servlet, ModuleConfig moduleConfig) throws ServletException {
        try {
            String className = PropsValues.STRUTS_PORTLET_REQUEST_PROCESSOR;
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(ActionServlet.class, ModuleConfig.class);
            PortletRequestProcessor portletReqProcessor = (PortletRequestProcessor)((Object)constructor.newInstance(servlet, moduleConfig));
            return portletReqProcessor;
        }
        catch (Exception e) {
            _log.error((Throwable)e);
            return new PortletRequestProcessor(servlet, moduleConfig);
        }
    }

    public PortletRequestProcessor(ActionServlet actionServlet, ModuleConfig moduleConfig) throws ServletException {
        this.init(actionServlet, moduleConfig);
    }

    public void process(ActionRequest actionRequest, ActionResponse actionResponse, String path) throws IOException, ServletException {
        HttpServletResponse response;
        ActionResponseImpl actionResponseImpl = (ActionResponseImpl)actionResponse;
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        ActionMapping actionMapping = this.processMapping(request, response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse), path);
        if (actionMapping == null) {
            return;
        }
        if (!this.processRoles(request, response, actionMapping, true)) {
            return;
        }
        ActionForm actionForm = this.processActionForm(request, response, actionMapping);
        this.processPopulate(request, response, actionForm, actionMapping);
        if (!this.processValidateAction(request, response, actionForm, actionMapping)) {
            return;
        }
        PortletAction portletAction = (PortletAction)this.processActionCreate(request, response, actionMapping);
        if (portletAction == null) {
            return;
        }
        PortletConfigImpl portletConfigImpl = (PortletConfigImpl)actionRequest.getAttribute("javax.portlet.config");
        try {
            if (portletAction.isCheckMethodOnProcessAction() && !PortalUtil.isMethodPost((PortletRequest)actionRequest)) {
                String currentURL = PortalUtil.getCurrentURL((PortletRequest)actionRequest);
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("This URL can only be invoked using POST: " + currentURL));
                }
                throw new PrincipalException(currentURL);
            }
            portletAction.processAction(actionMapping, actionForm, (PortletConfig)portletConfigImpl, actionRequest, actionResponse);
        }
        catch (Exception e) {
            String exceptionId = "PORTLET_STRUTS_EXCEPTION." + portletConfigImpl.getPortletId();
            actionRequest.setAttribute(exceptionId, (Object)e);
        }
        String forward = (String)actionRequest.getAttribute(PortletAction.getForwardKey((PortletRequest)actionRequest));
        if (forward != null) {
            ActionForward actionForward;
            String queryString = "";
            int pos = forward.indexOf(63);
            if (pos != -1) {
                queryString = forward.substring(pos + 1, forward.length());
                forward = forward.substring(0, pos);
            }
            if ((actionForward = actionMapping.findForward(forward)) != null && actionForward.getRedirect()) {
                String forwardPath = actionForward.getPath();
                if (forwardPath.startsWith("/")) {
                    LiferayPortletURL forwardURL = (LiferayPortletURL)actionResponseImpl.createRenderURL();
                    forwardURL.setParameter("struts_action", forwardPath);
                    StrutsURLEncoder.setParameters(forwardURL, queryString);
                    forwardPath = forwardURL.toString();
                }
                actionResponse.sendRedirect(forwardPath);
            }
        }
    }

    public void process(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, ServletException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)renderResponse);
        this.process(request, response);
    }

    public void process(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, ServletException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)resourceRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)resourceResponse);
        this.process(request, response);
    }

    protected void doForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doInclude(uri, request, response);
    }

    protected void doInclude(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PortletConfigImpl portletConfigImpl = (PortletConfigImpl)request.getAttribute("javax.portlet.config");
        PortletContext portletContext = portletConfigImpl.getPortletContext();
        PortletRequest portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request");
        PortletResponse portletResponse = (PortletResponse)request.getAttribute("javax.portlet.response");
        PortletRequestDispatcherImpl portletRequestDispatcher = (PortletRequestDispatcherImpl)portletContext.getRequestDispatcher("/html" + uri);
        try {
            if (portletRequestDispatcher == null) {
                _log.error((Object)(String.valueOf(uri) + " is not a valid include"));
            } else {
                portletRequestDispatcher.include(portletRequest, portletResponse, true);
            }
        }
        catch (PortletException pe) {
            Throwable cause = pe.getCause();
            if (cause instanceof ServletException) {
                throw (ServletException)cause;
            }
            _log.error((Object)cause, cause);
        }
    }

    protected Action processActionCreate(HttpServletRequest request, HttpServletResponse response, ActionMapping actionMapping) throws IOException {
        PortletActionAdapter portletActionAdapter = (PortletActionAdapter)StrutsActionRegistryUtil.getAction(actionMapping.getPath());
        if (portletActionAdapter != null) {
            ActionConfig actionConfig = this.moduleConfig.findActionConfig(actionMapping.getPath());
            if (actionConfig != null) {
                PortletAction originalPortletAction = (PortletAction)super.processActionCreate(request, response, actionMapping);
                portletActionAdapter.setOriginalPortletAction(originalPortletAction);
            }
            return portletActionAdapter;
        }
        return super.processActionCreate(request, response, actionMapping);
    }

    protected ActionForm processActionForm(HttpServletRequest request, HttpServletResponse response, ActionMapping actionMapping) {
        ActionForm actionForm = super.processActionForm(request, response, actionMapping);
        if (actionForm instanceof InitializableActionForm) {
            InitializableActionForm initializableActionForm = (InitializableActionForm)actionForm;
            initializableActionForm.init(request, response, actionMapping);
        }
        return actionForm;
    }

    protected ActionForward processActionPerform(HttpServletRequest request, HttpServletResponse response, Action action, ActionForm actionForm, ActionMapping actionMapping) throws IOException, ServletException {
        PortletConfigImpl portletConfigImpl = (PortletConfigImpl)request.getAttribute("javax.portlet.config");
        String exceptionId = "PORTLET_STRUTS_EXCEPTION." + portletConfigImpl.getPortletId();
        Exception e = (Exception)request.getAttribute(exceptionId);
        if (e != null) {
            return this.processException(request, response, e, actionForm, actionMapping);
        }
        return super.processActionPerform(request, response, action, actionForm, actionMapping);
    }

    protected void processForwardConfig(HttpServletRequest request, HttpServletResponse response, ForwardConfig forward) throws IOException, ServletException {
        if (forward == null) {
            _log.error((Object)"Forward does not exist");
        } else if (forward.getPath().equals("/common/null.jsp")) {
            return;
        }
        super.processForwardConfig(request, response, forward);
    }

    public ActionMapping processMapping(HttpServletRequest request, HttpServletResponse response, String path) {
        if (path == null) {
            return null;
        }
        ActionMapping actionMapping = null;
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        PortletConfigImpl portletConfigImpl = (PortletConfigImpl)request.getAttribute("javax.portlet.config");
        try {
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletConfigImpl.getPortletId());
            if (StrutsActionRegistryUtil.getAction(path) != null) {
                actionMapping = (ActionMapping)this.moduleConfig.findActionConfig(path);
                if (actionMapping == null) {
                    actionMapping = new ActionMapping();
                    actionMapping.setModuleConfig(this.moduleConfig);
                    actionMapping.setPath(path);
                    request.setAttribute("org.apache.struts.action.mapping.instance", (Object)actionMapping);
                }
            } else if (this.moduleConfig.findActionConfig(path) != null) {
                actionMapping = super.processMapping(request, response, path);
            } else if (Validator.isNotNull((String)portlet.getParentStrutsPath())) {
                int pos = path.indexOf("/", 1);
                String parentPath = "/" + portlet.getParentStrutsPath() + path.substring(pos, path.length());
                if (StrutsActionRegistryUtil.getAction(parentPath) != null) {
                    actionMapping = (ActionMapping)this.moduleConfig.findActionConfig(path);
                    if (actionMapping == null) {
                        actionMapping = new ActionMapping();
                        actionMapping.setModuleConfig(this.moduleConfig);
                        actionMapping.setPath(parentPath);
                        request.setAttribute("org.apache.struts.action.mapping.instance", (Object)actionMapping);
                    }
                } else if (this.moduleConfig.findActionConfig(parentPath) != null) {
                    actionMapping = super.processMapping(request, response, parentPath);
                }
            }
        }
        catch (Exception exception) {}
        if (actionMapping == null) {
            MessageResources messageResources = this.getInternal();
            String msg = messageResources.getMessage("processInvalid");
            _log.error((Object)("User ID " + request.getRemoteUser()));
            _log.error((Object)("Current URL " + PortalUtil.getCurrentURL((HttpServletRequest)request)));
            _log.error((Object)("Referer " + request.getHeader("Referer")));
            _log.error((Object)("Remote address " + request.getRemoteAddr()));
            _log.error((Object)(String.valueOf(msg) + " " + path));
        }
        return actionMapping;
    }

    protected HttpServletRequest processMultipart(HttpServletRequest request) {
        return request;
    }

    protected String processPath(HttpServletRequest request, HttpServletResponse response) {
        String path = request.getParameter("struts_action");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Getting request parameter path " + path));
        }
        if (Validator.isNull((String)path)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Getting request attribute path " + path));
            }
            path = (String)request.getAttribute("PORTLET_STRUTS_ACTION");
        }
        if (path == null) {
            PortletConfigImpl portletConfigImpl = (PortletConfigImpl)request.getAttribute("javax.portlet.config");
            _log.error((Object)(String.valueOf(portletConfigImpl.getPortletName()) + " does not have any paths specified"));
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing path " + path));
        }
        return path;
    }

    protected boolean processRoles(HttpServletRequest request, HttpServletResponse response, ActionMapping actionMapping) throws IOException, ServletException {
        return this.processRoles(request, response, actionMapping, false);
    }

    protected boolean processRoles(HttpServletRequest request, HttpServletResponse response, ActionMapping actionMapping, boolean action) throws IOException, ServletException {
        Portlet portlet;
        String path;
        block13: {
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            path = actionMapping.getPath();
            try {
                PortletConfigImpl portletConfigImpl = (PortletConfigImpl)request.getAttribute("javax.portlet.config");
                portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletConfigImpl.getPortletId());
                if (portlet != null) break block13;
                return false;
            }
            catch (Exception e) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)e.getMessage());
                }
                ActionForward forwardConfig = actionMapping.findForward(_PATH_PORTAL_PORTLET_ACCESS_DENIED);
                if (!action) {
                    this.processForwardConfig(request, response, (ForwardConfig)forwardConfig);
                }
                return false;
            }
        }
        String strutsPath = path.substring(1, path.lastIndexOf(47));
        if (!strutsPath.equals(portlet.getStrutsPath()) && !strutsPath.equals(portlet.getParentStrutsPath())) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("The struts path " + strutsPath + " does not belong " + "to portlet " + portlet.getPortletId() + ". " + "Check the definition in liferay-portlet.xml"));
            }
            throw new PrincipalException();
        }
        if (portlet.isActive()) {
            if (PortalUtil.isAllowAddPortletDefaultResource((HttpServletRequest)request, (Portlet)portlet)) {
                PortalUtil.addPortletDefaultResource((HttpServletRequest)request, (Portlet)portlet);
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            Layout layout = themeDisplay.getLayout();
            PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
            if (!PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (Portlet)portlet, (String)"VIEW")) {
                throw new PrincipalException();
            }
        } else if (!portlet.isActive()) {
            ActionForward forwardConfig = actionMapping.findForward(_PATH_PORTAL_PORTLET_INACTIVE);
            if (!action) {
                this.processForwardConfig(request, response, (ForwardConfig)forwardConfig);
            }
            return false;
        }
        return true;
    }

    protected boolean processValidateAction(HttpServletRequest request, HttpServletResponse response, ActionForm actionForm, ActionMapping actionMapping) {
        String input;
        if (actionForm == null) {
            return true;
        }
        if (request.getAttribute("org.apache.struts.action.CANCEL") != null) {
            return true;
        }
        if (!actionMapping.getValidate()) {
            return true;
        }
        ActionErrors errors = actionForm.validate(actionMapping, request);
        if (errors == null || errors.isEmpty()) {
            return true;
        }
        if (actionForm.getMultipartRequestHandler() != null) {
            actionForm.getMultipartRequestHandler().rollback();
        }
        if ((input = actionMapping.getInput()) == null) {
            _log.error((Object)"Validation failed but no input form is available");
            return false;
        }
        request.setAttribute("org.apache.struts.action.ERROR", (Object)errors);
        request.setAttribute(PortletAction.getForwardKey(request), (Object)input);
        return false;
    }
}

