/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.staging;

import com.liferay.portal.kernel.staging.LayoutStaging;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutStagingHandler;
import java.lang.reflect.InvocationHandler;

public class LayoutStagingImpl
implements LayoutStaging {
    public LayoutRevision getLayoutRevision(Layout layout) {
        LayoutStagingHandler layoutStagingHandler = this.getLayoutStagingHandler(layout);
        if (layoutStagingHandler == null) {
            return null;
        }
        return layoutStagingHandler.getLayoutRevision();
    }

    public LayoutStagingHandler getLayoutStagingHandler(Layout layout) {
        if (!ProxyUtil.isProxyClass(layout.getClass())) {
            return null;
        }
        InvocationHandler invocationHandler = ProxyUtil.getInvocationHandler((Object)layout);
        if (!(invocationHandler instanceof LayoutStagingHandler)) {
            return null;
        }
        return (LayoutStagingHandler)invocationHandler;
    }

    public boolean isBranchingLayout(Layout layout) {
        try {
            return this.isBranchingLayoutSet(layout.getGroup(), layout.isPrivateLayout());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isBranchingLayoutSet(Group group, boolean privateLayout) {
        boolean isStagingGroup = false;
        if (group.isStagingGroup()) {
            isStagingGroup = true;
            group = group.getLiveGroup();
        }
        UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
        boolean branchingEnabled = false;
        branchingEnabled = privateLayout ? GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("branchingPrivate")) : GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("branchingPublic"));
        if (group.isStaged() && branchingEnabled) {
            return group.isStagedRemotely() || isStagingGroup;
        }
        return false;
    }
}

