/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.SortedProperties;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Enumeration;
import java.util.Properties;
import javax.sql.DataSource;
import jodd.bean.BeanUtil;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.HibernateTransactionManager;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;

public class TransactionManagerFactory {
    private static Log _log = LogFactoryUtil.getLog(TransactionManagerFactory.class);

    public static AbstractPlatformTransactionManager createTransactionManager(DataSource dataSource, SessionFactory sessionFactory) throws Exception {
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        AbstractPlatformTransactionManager abstractPlatformTransactionManager = (AbstractPlatformTransactionManager)classLoader.loadClass(PropsValues.TRANSACTION_MANAGER_IMPL).newInstance();
        Properties properties = PropsUtil.getProperties("transaction.manager.property.", true);
        Enumeration<?> enu = properties.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            String value = properties.getProperty(key);
            BeanUtil.setProperty((Object)abstractPlatformTransactionManager, (String)key, (Object)value);
        }
        if (abstractPlatformTransactionManager instanceof HibernateTransactionManager) {
            HibernateTransactionManager hibernateTransactionManager = (HibernateTransactionManager)abstractPlatformTransactionManager;
            hibernateTransactionManager.setDataSource(dataSource);
            hibernateTransactionManager.setSessionFactory(sessionFactory);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Created transaction manager " + abstractPlatformTransactionManager.getClass().getName()));
            SortedProperties sortedProperties = new SortedProperties(properties);
            sortedProperties.list(System.out);
        }
        return abstractPlatformTransactionManager;
    }
}

