/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.jpa;

import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.springframework.orm.jpa.vendor.Database;

public class DatabaseDetector {
    private static Log _log = LogFactoryUtil.getLog(DatabaseDetector.class);

    public static Database determineDatabase(DataSource dataSource) {
        String type;
        Database database;
        block31: {
            database = null;
            type = null;
            Connection connection = null;
            try {
                try {
                    connection = dataSource.getConnection();
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    String dbName = databaseMetaData.getDatabaseProductName();
                    int dbMajorVersion = databaseMetaData.getDatabaseMajorVersion();
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Determining DB type for " + dbName + " " + dbMajorVersion));
                    }
                    if (dbName.equals("Apache Derby")) {
                        database = Database.DERBY;
                        type = "derby";
                    } else if (dbName.startsWith("DB2/")) {
                        database = Database.DB2;
                        type = "db2";
                    } else if (dbName.equals("HSQL Database Engine")) {
                        if (_log.isWarnEnabled()) {
                            StringBundler sb = new StringBundler(6);
                            sb.append("Liferay is configured to use Hypersonic as ");
                            sb.append("its database. Do NOT use Hypersonic in ");
                            sb.append("production. Hypersonic is an embedded ");
                            sb.append("database useful for development and demo'ing ");
                            sb.append("purposes. The database settings can be ");
                            sb.append("changed in portal-ext.properties.");
                            _log.warn((Object)sb.toString());
                        }
                        database = Database.HSQL;
                        type = "hypersonic";
                    } else if (dbName.equals("Informix Dynamic Server")) {
                        database = Database.INFORMIX;
                        type = "informix";
                    } else if (dbName.startsWith("Microsoft SQL Server")) {
                        database = Database.SQL_SERVER;
                        type = "sqlserver";
                    } else if (dbName.equals("MySQL")) {
                        database = Database.MYSQL;
                        type = "mysql";
                    } else if (dbName.equals("Oracle")) {
                        database = Database.ORACLE;
                        type = "oracle";
                    } else if (dbName.equals("PostgreSQL")) {
                        database = Database.POSTGRESQL;
                        type = "postgresql";
                    } else if (dbName.equals("Sybase SQL Server")) {
                        database = Database.SYBASE;
                        type = "sybase";
                    }
                    if (dbName.equals("ASE") && dbMajorVersion == 15) {
                        database = Database.SYBASE;
                        type = "sybase";
                    }
                }
                catch (Exception e) {
                    String msg = GetterUtil.getString((String)e.getMessage());
                    if (msg.indexOf("explicitly set for database: DB2") != -1) {
                        database = Database.DB2;
                        type = "db2";
                    } else {
                        _log.error((Object)e, (Throwable)e);
                    }
                    DataAccess.cleanUp((Connection)connection);
                    break block31;
                }
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)connection);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)connection);
        }
        if (database == null) {
            throw new RuntimeException("Unable to detect the database");
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Detected database " + database.toString()));
        }
        if (Validator.isNotNull((String)PropsValues.JPA_DATABASE_TYPE)) {
            DBFactoryUtil.setDB((String)PropsValues.JPA_DATABASE_TYPE);
        } else {
            DBFactoryUtil.setDB((String)type);
        }
        return database;
    }
}

