/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.hibernate;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Converter;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.hibernate.DialectDetector;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javassist.util.proxy.ProxyFactory;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalHibernateConfiguration
extends LocalSessionFactoryBean {
    private static Log _log = LogFactoryUtil.getLog(PortalHibernateConfiguration.class);
    private Converter<String> _hibernateConfigurationConverter;

    public SessionFactory buildSessionFactory() throws Exception {
        ProxyFactory.classLoaderProvider = new ProxyFactory.ClassLoaderProvider(){

            public ClassLoader get(ProxyFactory proxyFactory) {
                return Thread.currentThread().getContextClassLoader();
            }
        };
        return super.buildSessionFactory();
    }

    public void setHibernateConfigurationConverter(Converter<String> hibernateConfigurationConverter) {
        this._hibernateConfigurationConverter = hibernateConfigurationConverter;
    }

    protected String determineDialect() {
        return DialectDetector.determineDialect(this.getDataSource());
    }

    protected ClassLoader getConfigurationClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    protected String[] getConfigurationResources() {
        return PropsUtil.getArray("hibernate.configs");
    }

    protected Configuration newConfiguration() {
        Configuration configuration = new Configuration();
        try {
            String[] resources;
            String[] stringArray = resources = this.getConfigurationResources();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                block8: {
                    String resource = stringArray[n2];
                    try {
                        this.readResource(configuration, resource);
                    }
                    catch (Exception e2) {
                        if (!_log.isWarnEnabled()) break block8;
                        _log.warn((Object)e2, (Throwable)e2);
                    }
                }
                ++n2;
            }
            configuration.setProperties(PropsUtil.getProperties());
            if (Validator.isNull((String)PropsValues.HIBERNATE_DIALECT)) {
                String dialect = this.determineDialect();
                configuration.setProperty("hibernate.dialect", dialect);
            }
            DB db = DBFactoryUtil.getDB();
            String dbType = db.getType();
            dbType.equals("hypersonic");
        }
        catch (Exception e1) {
            _log.error((Object)e1, (Throwable)e1);
        }
        Properties hibernateProperties = this.getHibernateProperties();
        if (hibernateProperties != null) {
            for (Map.Entry<Object, Object> entry : hibernateProperties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                configuration.setProperty(key, value);
            }
        }
        return configuration;
    }

    protected void postProcessConfiguration(Configuration configuration) {
        String connectionReleaseMode = PropsUtil.get("hibernate.connection.release_mode");
        if (Validator.isNotNull((String)connectionReleaseMode)) {
            configuration.setProperty("hibernate.connection.release_mode", connectionReleaseMode);
        }
    }

    protected void readResource(Configuration configuration, String resource) throws Exception {
        ClassLoader classLoader = this.getConfigurationClassLoader();
        InputStream is = classLoader.getResourceAsStream(resource);
        if (is == null) {
            return;
        }
        if (this._hibernateConfigurationConverter != null) {
            String configurationString = StringUtil.read((InputStream)is);
            is.close();
            configurationString = (String)this._hibernateConfigurationConverter.convert((Object)configurationString);
            is = new UnsyncByteArrayInputStream(configurationString.getBytes());
        }
        configuration = configuration.addInputStream(is);
        is.close();
    }
}

