/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.aspectj.AspectJPointcutAdvisor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;

public class PortletBeanFactoryCleaner
implements BeanFactoryAware {
    private static Log _log = LogFactoryUtil.getLog(PortletBeanFactoryCleaner.class);
    private static Set<AspectJExpressionPointcut> _aspectJExpressionPointcuts = new HashSet<AspectJExpressionPointcut>();
    private static BeanFactory _beanFactory;
    private static Set<BeanFactoryAware> _beanFactoryAwares;
    private static Field _shadowMatchCacheField;

    static {
        _beanFactoryAwares = new HashSet<BeanFactoryAware>();
        try {
            _shadowMatchCacheField = ReflectionUtil.getDeclaredField(AspectJExpressionPointcut.class, (String)"shadowMatchCache");
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public static void readBeans() {
        String[] names;
        if (_beanFactory == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"BeanFactory is null");
            }
            return;
        }
        if (!(_beanFactory instanceof ListableBeanFactory)) {
            return;
        }
        ListableBeanFactory listableBeanFactory = (ListableBeanFactory)_beanFactory;
        String[] stringArray = names = listableBeanFactory.getBeanDefinitionNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                PortletBeanFactoryCleaner._readBean(listableBeanFactory, name);
            }
            catch (Exception exception) {}
            ++n2;
        }
    }

    public void destroy() {
        for (BeanFactoryAware beanFactoryAware : _beanFactoryAwares) {
            try {
                beanFactoryAware.setBeanFactory(null);
            }
            catch (Exception exception) {}
        }
        _beanFactoryAwares.clear();
        for (AspectJExpressionPointcut aspectJExpressionPointcut : _aspectJExpressionPointcuts) {
            try {
                Map shadowMatchCache = (Map)_shadowMatchCacheField.get(aspectJExpressionPointcut);
                shadowMatchCache.clear();
            }
            catch (Exception exception) {}
        }
        _aspectJExpressionPointcuts.clear();
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        _beanFactory = beanFactory;
    }

    private static void _readBean(ListableBeanFactory listableBeanFactory, String name) throws Exception {
        Object bean = listableBeanFactory.getBean(name);
        if (bean instanceof AspectJPointcutAdvisor) {
            AspectJPointcutAdvisor aspectJPointcutAdvisor = (AspectJPointcutAdvisor)bean;
            Pointcut pointcut = aspectJPointcutAdvisor.getPointcut();
            ClassFilter classFilter = pointcut.getClassFilter();
            if (classFilter instanceof AspectJExpressionPointcut) {
                AspectJExpressionPointcut aspectJExpressionPointcut = (AspectJExpressionPointcut)classFilter;
                _beanFactoryAwares.add((BeanFactoryAware)aspectJExpressionPointcut);
                _aspectJExpressionPointcuts.add(aspectJExpressionPointcut);
            }
        } else if (bean instanceof BeanFactoryAware) {
            _beanFactoryAwares.add((BeanFactoryAware)bean);
        }
    }
}

