/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.cache.ehcache.ClearEhcacheThreadUtil;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.cache.ThreadLocalCacheManager;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.servlet.DirectServletRegistry;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.CharBufferPool;
import com.liferay.portal.kernel.util.ClearThreadLocalUtil;
import com.liferay.portal.kernel.util.ClearTimerThreadUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.MethodCache;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.webcache.WebCachePoolUtil;
import com.liferay.portal.osgi.service.OSGiServiceUtil;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portal.spring.context.PortalContextLoaderLifecycleThreadLocal;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portal.velocity.LiferayResourceCacheUtil;
import com.liferay.portlet.PortletContextBagPool;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import java.lang.reflect.Field;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public class PortalContextLoaderListener
extends ContextLoaderListener {
    private static Field _filteredPropertyDescriptorsCacheField;
    private static Log _log;

    static {
        _log = LogFactoryUtil.getLog(PortalContextLoaderListener.class);
        try {
            _filteredPropertyDescriptorsCacheField = ReflectionUtil.getDeclaredField(AbstractAutowireCapableBeanFactory.class, (String)"filteredPropertyDescriptorsCache");
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        PortalContextLoaderLifecycleThreadLocal.setDestroying(true);
        ThreadLocalCacheManager.destroy();
        try {
            ClearThreadLocalUtil.clearThreadLocal();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        try {
            ClearTimerThreadUtil.clearTimerThread();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        try {
            ClearEhcacheThreadUtil.clearEhcacheReplicationThread();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        try {
            OSGiServiceUtil.stopRuntime();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        try {
            super.contextDestroyed(event);
            try {
                OSGiServiceUtil.stopFramework();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        finally {
            PortalContextLoaderLifecycleThreadLocal.setDestroying(false);
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        HotDeployUtil.reset();
        InstancePool.reset();
        MethodCache.reset();
        PortletBagPool.reset();
        ReferenceRegistry.releaseReferences();
        InitUtil.init();
        ServletContext servletContext = servletContextEvent.getServletContext();
        ClassPathUtil.initializeClassPaths((ServletContext)servletContext);
        DirectServletRegistry.clearServlets();
        CacheRegistryUtil.clear();
        CharBufferPool.cleanUp();
        PortletContextBagPool.clear();
        WebAppPool.clear();
        if (PropsValues.OSGI_ENABLED) {
            try {
                OSGiServiceUtil.init();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        PortalContextLoaderLifecycleThreadLocal.setInitializing(true);
        try {
            super.contextInitialized(servletContextEvent);
        }
        finally {
            PortalContextLoaderLifecycleThreadLocal.setInitializing(false);
        }
        FinderCacheUtil.clearCache();
        FinderCacheUtil.clearLocalCache();
        EntityCacheUtil.clearCache();
        EntityCacheUtil.clearLocalCache();
        LiferayResourceCacheUtil.clear();
        PermissionCacheUtil.clearCache();
        PermissionCacheUtil.clearLocalCache();
        WikiCacheUtil.clearCache(0L);
        ServletContextPool.clear();
        CacheUtil.clearCache();
        MultiVMPoolUtil.clear();
        SingleVMPoolUtil.clear();
        WebCachePoolUtil.clear();
        WebApplicationContext applicationContext = ContextLoader.getCurrentWebApplicationContext();
        ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
        BeanLocatorImpl beanLocator = new BeanLocatorImpl(portalClassLoader, (ApplicationContext)applicationContext);
        PortalBeanLocatorUtil.setBeanLocator((BeanLocator)beanLocator);
        ClassLoader classLoader = portalClassLoader;
        while (classLoader != null) {
            CachedIntrospectionResults.clearClassLoader((ClassLoader)classLoader);
            classLoader = classLoader.getParent();
        }
        AutowireCapableBeanFactory autowireCapableBeanFactory = applicationContext.getAutowireCapableBeanFactory();
        this.clearFilteredPropertyDescriptorsCache(autowireCapableBeanFactory);
        if (PropsValues.OSGI_ENABLED) {
            try {
                OSGiServiceUtil.registerContext(servletContext);
                OSGiServiceUtil.registerContext(applicationContext);
                OSGiServiceUtil.start();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    protected void clearFilteredPropertyDescriptorsCache(AutowireCapableBeanFactory autowireCapableBeanFactory) {
        try {
            Map filteredPropertyDescriptorsCache = (Map)_filteredPropertyDescriptorsCacheField.get(autowireCapableBeanFactory);
            filteredPropertyDescriptorsCache.clear();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }
}

