/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.portal.spring.aop.ServiceBeanAopProxy;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.AopProxyFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.autoproxy.AbstractAdvisorAutoProxyCreator;

public class ServiceBeanAutoProxyCreator
extends AbstractAdvisorAutoProxyCreator {
    private static final String _SERVICE_SUFFIX = "Service";
    private MethodInterceptor _methodInterceptor;

    public void setMethodInterceptor(MethodInterceptor methodInterceptor) {
        this._methodInterceptor = methodInterceptor;
    }

    protected void customizeProxyFactory(ProxyFactory proxyFactory) {
        proxyFactory.setAopProxyFactory(new AopProxyFactory(){

            public AopProxy createAopProxy(AdvisedSupport advisedSupport) throws AopConfigException {
                return new ServiceBeanAopProxy(advisedSupport, ServiceBeanAutoProxyCreator.this._methodInterceptor);
            }
        });
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class beanClass, String beanName, TargetSource targetSource) {
        Object[] advices = DO_NOT_PROXY;
        if (beanName.endsWith(_SERVICE_SUFFIX) && (advices = super.getAdvicesAndAdvisorsForBean(beanClass, beanName, targetSource)) == DO_NOT_PROXY) {
            advices = PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS;
        }
        return advices;
    }
}

