/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.sharepoint;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.sharepoint.SharepointRequest;
import com.liferay.portal.sharepoint.SharepointServlet;
import com.liferay.portal.sharepoint.SharepointStorage;
import com.liferay.portal.sharepoint.SharepointUtil;
import com.liferay.portal.sharepoint.dws.MemberResponseElement;
import com.liferay.portal.sharepoint.dws.RoleResponseElement;
import com.liferay.portal.util.PortalUtil;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SharepointDocumentWorkspaceServlet
extends HttpServlet {
    private static Log _log = LogFactoryUtil.getLog(SharepointServlet.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.getDwsMetaDataResponse(request, response);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void getDwsMetaDataResponse(HttpServletRequest request, HttpServletResponse response) throws Exception {
        StringBundler sb = new StringBundler(12);
        sb.append("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"");
        sb.append("http://schemas.xmlsoap.org/soap/envelope/\">");
        sb.append("<SOAP-ENV:Header/>");
        sb.append("<SOAP-ENV:Body>");
        sb.append("<GetDwsMetaDataResponse xmlns=\"");
        sb.append("http://schemas.microsoft.com/sharepoint/soap/dws/\">");
        sb.append("<GetDwsMetaDataResult>");
        String results = this.getResults(request);
        int pos = results.indexOf("\n");
        if (pos != -1) {
            results = results.substring(pos + 1);
        }
        results = results.replaceAll("<", "&lt;");
        results = results.replaceAll(">", "&gt;");
        sb.append(results);
        sb.append("</GetDwsMetaDataResult>");
        sb.append("</GetDwsMetaDataResponse>");
        sb.append("</SOAP-ENV:Body>");
        sb.append("</SOAP-ENV:Envelope>");
        response.setContentType("text/xml; charset=UTF-8");
        ServletResponseUtil.write((HttpServletResponse)response, (String)sb.toString());
    }

    protected String getResults(HttpServletRequest request) throws Exception {
        String xml = StringUtil.read((InputStream)request.getInputStream());
        String documentName = null;
        int beginPos = xml.lastIndexOf("<document>");
        int endPos = xml.lastIndexOf("</document>");
        if (beginPos != -1) {
            documentName = xml.substring(beginPos + 10, endPos);
            documentName = HttpUtil.decodeURL((String)documentName);
        }
        String path = documentName;
        int pos = documentName.lastIndexOf("sharepoint/");
        if (pos != -1) {
            path = path.substring(pos + 11);
        }
        Group group = GroupServiceUtil.getGroup((long)SharepointUtil.getGroupId(path));
        boolean minimal = false;
        beginPos = xml.lastIndexOf("<minimal>");
        endPos = xml.lastIndexOf("</minimal>");
        if (beginPos != -1) {
            minimal = GetterUtil.getBoolean((String)xml.substring(beginPos + 9, endPos));
        }
        Document doc = SAXReaderUtil.createDocument();
        Element root = doc.addElement("Results");
        String url = "http://" + request.getLocalAddr() + ":" + request.getServerPort() + "/sharepoint";
        root.addElement("SubscribeUrl").setText(url);
        root.addElement("MtgInstance");
        root.addElement("SettingUrl").setText(url);
        root.addElement("PermsUrl").setText(url);
        root.addElement("UserInfoUrl").setText(url);
        Element rolesEl = root.addElement("Roles");
        List roles = RoleLocalServiceUtil.getRoles((long)PortalUtil.getCompanyId((HttpServletRequest)request));
        for (Role role : roles) {
            RoleResponseElement responseElement = new RoleResponseElement(role);
            responseElement.addElement(rolesEl);
        }
        if (!minimal) {
            Element schemaEl = root.addElement("Schema");
            schemaEl.addAttribute("Name", "Documents");
            schemaEl.addAttribute("Url", group.getName());
            Element fieldEl = schemaEl.addElement("Field");
            fieldEl.addAttribute("Name", "FileLeafRef");
            fieldEl.addAttribute("Required", "true");
            fieldEl.addAttribute("Type", "Invalid");
            fieldEl.addElement("Choices");
            fieldEl = schemaEl.addElement("Field");
            fieldEl.addAttribute("Name", "_SourceUrl");
            fieldEl.addAttribute("Required", "false");
            fieldEl.addAttribute("Type", "Text");
            fieldEl.addElement("Choices");
            fieldEl = schemaEl.addElement("Field");
            fieldEl.addAttribute("Name", "_SharedFileIndex");
            fieldEl.addAttribute("Required", "false");
            fieldEl.addAttribute("Type", "Text");
            fieldEl.addElement("Choices");
            fieldEl = schemaEl.addElement("Field");
            fieldEl.addAttribute("Name", "Order");
            fieldEl.addAttribute("Required", "false");
            fieldEl.addAttribute("Type", "Number");
            fieldEl.addElement("Choices");
            fieldEl = schemaEl.addElement("Field");
            fieldEl.addAttribute("Name", "Title");
            fieldEl.addAttribute("Required", "false");
            fieldEl.addAttribute("Type", "Text");
            fieldEl.addElement("Choices");
            Element listInfoEl = root.addElement("ListInfo");
            listInfoEl.addAttribute("Name", "Links");
            listInfoEl.addElement("Moderated").setText(String.valueOf(false));
            Element listPermissionsEl = listInfoEl.addElement("ListPermissions");
            listPermissionsEl.addElement("DeleteListItems");
            listPermissionsEl.addElement("EditListItems");
            listPermissionsEl.addElement("InsertListItems");
            listPermissionsEl.addElement("ManageRoles");
            listPermissionsEl.addElement("ManageWeb");
        }
        Element permissionsEl = root.addElement("Permissions");
        if (!minimal) {
            permissionsEl.addElement("DeleteListItems");
            permissionsEl.addElement("EditListItems");
            permissionsEl.addElement("InsertListItems");
            permissionsEl.addElement("ManageRoles");
            permissionsEl.addElement("ManageWeb");
        }
        root.addElement("HasUniquePerm").setText(String.valueOf(true));
        root.addElement("WorkspaceType").setText("DWS");
        root.addElement("IsADMode").setText(String.valueOf(false));
        root.addElement("DocUrl").setText(documentName);
        root.addElement("Minimal").setText(String.valueOf(true));
        Element resultsEl = root.addElement("Results");
        resultsEl.addElement("Title").setText(group.getName());
        resultsEl.addElement("LastUpdate");
        User user = (User)request.getSession().getAttribute("USER");
        MemberResponseElement responseElement = new MemberResponseElement(user, false);
        responseElement.addElement(resultsEl);
        Element membersEl = resultsEl.addElement("Members");
        List users = UserLocalServiceUtil.getGroupUsers((long)group.getGroupId());
        for (User member : users) {
            responseElement = new MemberResponseElement(member, true);
            responseElement.addElement(membersEl);
        }
        if (!minimal) {
            Element assigneesEl = resultsEl.addElement("Assignees");
            for (User member : users) {
                responseElement = new MemberResponseElement(member, true);
                responseElement.addElement(assigneesEl);
            }
            Element listEl = resultsEl.addElement("List");
            listEl.addAttribute("Name", "Documents");
            listEl.addElement("ID");
            String parentFolderPath = path;
            pos = parentFolderPath.lastIndexOf("/");
            if (pos != -1) {
                parentFolderPath = parentFolderPath.substring(0, pos);
            }
            SharepointStorage storage = SharepointUtil.getStorage(parentFolderPath);
            SharepointRequest sharepointRequest = new SharepointRequest(parentFolderPath);
            storage.addDocumentElements(sharepointRequest, listEl);
        }
        return doc.asXML();
    }
}

