/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.setup;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.dao.jdbc.util.DataSourceSwapper;
import com.liferay.portal.events.StartupAction;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dao.jdbc.DataSourceFactoryUtil;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.CentralizedThreadLocal;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webcache.WebCachePoolUtil;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.FullNameGenerator;
import com.liferay.portal.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.security.auth.ScreenNameGenerator;
import com.liferay.portal.security.auth.ScreenNameGeneratorFactory;
import com.liferay.portal.service.AccountLocalServiceUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.QuartzLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.sql.Connection;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;

public class SetupWizardUtil {
    public static final String PROPERTIES_FILE_NAME = "portal-setup-wizard.properties";
    private static final String _PROPERTIES_PREFIX = "properties--";
    private static Log _log = LogFactoryUtil.getLog(SetupWizardUtil.class);
    private static boolean _setupFinished = false;

    public static boolean isDefaultDatabase(HttpServletRequest request) {
        boolean hsqldb = ParamUtil.getBoolean((HttpServletRequest)request, (String)"defaultDatabase", (boolean)PropsValues.JDBC_DEFAULT_URL.contains("hsqldb"));
        boolean jndi = Validator.isNotNull((String)PropsValues.JDBC_DEFAULT_JNDI_NAME);
        return hsqldb && !jndi;
    }

    public static boolean isSetupFinished() {
        if (PropsValues.SETUP_WIZARD_ENABLED) {
            return _setupFinished;
        }
        return true;
    }

    public static void setSetupFinished(boolean setupFinished) {
        _setupFinished = setupFinished;
    }

    public static void testDatabase(HttpServletRequest request) throws Exception {
        String driverClassName = SetupWizardUtil._getParameter(request, "jdbc.default.driverClassName", PropsValues.JDBC_DEFAULT_DRIVER_CLASS_NAME);
        String url = SetupWizardUtil._getParameter(request, "jdbc.default.url", null);
        String userName = SetupWizardUtil._getParameter(request, "jdbc.default.username", null);
        String password = SetupWizardUtil._getParameter(request, "jdbc.default.password", null);
        SetupWizardUtil._testConnection(driverClassName, url, userName, password);
    }

    public static void updateLanguage(HttpServletRequest request, HttpServletResponse response) {
        String languageId = SetupWizardUtil._getParameter(request, "company.default.locale", PropsValues.COMPANY_DEFAULT_LOCALE);
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        List availableLocales = ListUtil.fromArray((Object[])LanguageUtil.getAvailableLocales());
        if (!availableLocales.contains(locale)) {
            return;
        }
        PropsValues.COMPANY_DEFAULT_LOCALE = languageId;
        HttpSession session = request.getSession();
        session.setAttribute("org.apache.struts.action.LOCALE", (Object)locale);
        session.setAttribute("SETUP_WIZARD_DEFAULT_LOCALE", (Object)languageId);
        LanguageUtil.updateCookie((HttpServletRequest)request, (HttpServletResponse)response, (Locale)locale);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        themeDisplay.setLanguageId(languageId);
        themeDisplay.setLocale(locale);
    }

    public static void updateSetup(HttpServletRequest request, HttpServletResponse response) throws Exception {
        UnicodeProperties unicodeProperties = PropertiesParamUtil.getProperties((HttpServletRequest)request, (String)_PROPERTIES_PREFIX);
        unicodeProperties.setProperty("liferay.home", SystemProperties.get((String)"liferay.home"));
        boolean databaseConfigured = SetupWizardUtil._isDatabaseConfigured(unicodeProperties);
        SetupWizardUtil._processAdminProperties(request, unicodeProperties);
        SetupWizardUtil._processDatabaseProperties(request, unicodeProperties, databaseConfigured);
        SetupWizardUtil.updateLanguage(request, response);
        unicodeProperties.put("setup.wizard.enabled", String.valueOf(false));
        PropsUtil.addProperties(unicodeProperties);
        HttpSession session = request.getSession();
        session.setAttribute("SETUP_WIZARD_PROPERTIES", (Object)unicodeProperties);
        boolean propertiesFileUpdated = SetupWizardUtil._writePropertiesFile(unicodeProperties);
        session.setAttribute("SETUP_WIZARD_PROPERTIES_UPDATED", (Object)propertiesFileUpdated);
        if (!databaseConfigured) {
            SetupWizardUtil._reloadServletContext(request, unicodeProperties);
        }
        SetupWizardUtil._updateCompany();
        SetupWizardUtil._updateAdminUser(request);
        SetupWizardUtil._initPlugins();
    }

    private static String _getParameter(HttpServletRequest request, String name, String defaultValue) {
        name = _PROPERTIES_PREFIX.concat(name).concat("--");
        return ParamUtil.getString((HttpServletRequest)request, (String)name, (String)defaultValue);
    }

    private static void _initPlugins() {
        HotDeployUtil.setCapturePrematureEvents((boolean)false);
        PortalLifecycleUtil.flushInits();
    }

    private static boolean _isDatabaseConfigured(UnicodeProperties unicodeProperties) {
        String defaultDriverClassName = (String)unicodeProperties.get((Object)"jdbc.default.driverClassName");
        String defaultPassword = (String)unicodeProperties.get((Object)"jdbc.default.password");
        String defaultURL = (String)unicodeProperties.get((Object)"jdbc.default.url");
        String defaultUsername = (String)unicodeProperties.get((Object)"jdbc.default.username");
        return PropsValues.JDBC_DEFAULT_DRIVER_CLASS_NAME.equals(defaultDriverClassName) && PropsValues.JDBC_DEFAULT_PASSWORD.equals(defaultPassword) && PropsValues.JDBC_DEFAULT_URL.equals(defaultURL) && PropsValues.JDBC_DEFAULT_USERNAME.equals(defaultUsername);
    }

    private static void _processAdminProperties(HttpServletRequest request, UnicodeProperties unicodeProperties) throws Exception {
        String emailAddress;
        String fullName;
        String lastName;
        String firstName;
        String companyName;
        PropsValues.COMPANY_DEFAULT_NAME = companyName = SetupWizardUtil._getParameter(request, "company.default.name", "Liferay");
        FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
        PropsValues.DEFAULT_ADMIN_FIRST_NAME = firstName = SetupWizardUtil._getParameter(request, "default.admin.first.name", "Test");
        PropsValues.DEFAULT_ADMIN_LAST_NAME = lastName = SetupWizardUtil._getParameter(request, "default.admin.last.name", "Test");
        PropsValues.ADMIN_EMAIL_FROM_NAME = fullName = fullNameGenerator.getFullName(firstName, null, lastName);
        unicodeProperties.put("admin.email.from.name", fullName);
        PropsValues.ADMIN_EMAIL_FROM_ADDRESS = emailAddress = SetupWizardUtil._getParameter(request, "admin.email.from.address", "test@liferay.com");
        PropsValues.DEFAULT_ADMIN_EMAIL_ADDRESS = emailAddress;
        unicodeProperties.put("default.admin.email.address", emailAddress);
        ScreenNameGenerator screenNameGenerator = ScreenNameGeneratorFactory.getInstance();
        String screenName = null;
        try {
            screenName = screenNameGenerator.generate(0L, 0L, emailAddress);
        }
        catch (Exception exception) {
            screenName = "test";
        }
        PropsValues.DEFAULT_ADMIN_SCREEN_NAME = screenName;
        unicodeProperties.put("default.admin.screen.name", screenName);
    }

    private static void _processDatabaseProperties(HttpServletRequest request, UnicodeProperties unicodeProperties, boolean databaseConfigured) throws Exception {
        boolean defaultDatabase = ParamUtil.getBoolean((HttpServletRequest)request, (String)"defaultDatabase", (boolean)true);
        if (defaultDatabase || databaseConfigured) {
            unicodeProperties.remove((Object)"jdbc.default.url");
            unicodeProperties.remove((Object)"jdbc.default.driverClassName");
            unicodeProperties.remove((Object)"jdbc.default.username");
            unicodeProperties.remove((Object)"jdbc.default.password");
        }
    }

    private static void _reloadServletContext(HttpServletRequest request, UnicodeProperties unicodeProperties) throws Exception {
        Properties jdbcProperties = new Properties();
        jdbcProperties.putAll((Map<?, ?>)unicodeProperties);
        jdbcProperties = PropertiesUtil.getProperties((Properties)jdbcProperties, (String)"jdbc.default.", (boolean)true);
        DataSourceSwapper.swapCounterDataSource(jdbcProperties);
        DataSourceSwapper.swapLiferayDataSource(jdbcProperties);
        CacheRegistryUtil.clear();
        MultiVMPoolUtil.clear();
        WebCachePoolUtil.clear();
        CentralizedThreadLocal.clearShortLivedThreadLocals();
        QuartzLocalServiceUtil.checkQuartzTables();
        StartupAction startupAction = new StartupAction();
        startupAction.run(null);
        HttpSession session = request.getSession();
        PortalInstances.reload(session.getServletContext());
    }

    private static void _testConnection(String driverClassName, String url, String userName, String password) throws Exception {
        Class.forName(driverClassName);
        Connection connection = null;
        try {
            DataSource dataSource = DataSourceFactoryUtil.initDataSource((String)driverClassName, (String)url, (String)userName, (String)password);
            connection = dataSource.getConnection();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(connection);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)connection);
    }

    private static void _updateAdminUser(HttpServletRequest request) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        User user = null;
        try {
            user = UserLocalServiceUtil.getUserByEmailAddress((long)PortalUtil.getDefaultCompanyId(), (String)PropsValues.ADMIN_EMAIL_FROM_ADDRESS);
        }
        catch (NoSuchUserException noSuchUserException) {
            user = UserLocalServiceUtil.getUserByEmailAddress((long)PortalUtil.getDefaultCompanyId(), (String)"test@liferay.com");
            user = UserLocalServiceUtil.updateEmailAddress((long)user.getUserId(), (String)"", (String)PropsValues.ADMIN_EMAIL_FROM_ADDRESS, (String)PropsValues.ADMIN_EMAIL_FROM_ADDRESS);
        }
        String greeting = LanguageUtil.format((Locale)themeDisplay.getLocale(), (String)"welcome-x", (Object)(" " + PropsValues.ADMIN_EMAIL_FROM_NAME), (boolean)false);
        Contact contact = user.getContact();
        Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
        birthdayCal.setTime(contact.getBirthday());
        int birthdayMonth = birthdayCal.get(2);
        int birthdayDay = birthdayCal.get(5);
        int birthdayYear = birthdayCal.get(1);
        user = UserLocalServiceUtil.updateUser((long)user.getUserId(), (String)"", (String)"", (String)"", (boolean)false, (String)user.getReminderQueryQuestion(), (String)user.getReminderQueryAnswer(), (String)user.getScreenName(), (String)user.getEmailAddress(), (long)user.getFacebookId(), (String)user.getOpenId(), (String)themeDisplay.getLanguageId(), (String)user.getTimeZoneId(), (String)greeting, (String)user.getComments(), (String)PropsValues.DEFAULT_ADMIN_FIRST_NAME, (String)user.getMiddleName(), (String)PropsValues.DEFAULT_ADMIN_LAST_NAME, (int)contact.getPrefixId(), (int)contact.getSuffixId(), (boolean)contact.isMale(), (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)contact.getSmsSn(), (String)contact.getAimSn(), (String)contact.getFacebookSn(), (String)contact.getIcqSn(), (String)contact.getJabberSn(), (String)contact.getMsnSn(), (String)contact.getMySpaceSn(), (String)contact.getSkypeSn(), (String)contact.getTwitterSn(), (String)contact.getYmSn(), (String)contact.getJobTitle(), null, null, null, null, null, (ServiceContext)new ServiceContext());
        user = UserLocalServiceUtil.updatePasswordReset((long)user.getUserId(), (boolean)true);
        HttpSession session = request.getSession();
        session.setAttribute("SETUP_WIZARD_PASSWORD_UPDATED", (Object)true);
    }

    private static void _updateCompany() throws Exception {
        Company company = CompanyLocalServiceUtil.getCompanyById((long)PortalInstances.getDefaultCompanyId());
        Account account = company.getAccount();
        String name = account.getName();
        if (!name.equals(PropsValues.COMPANY_DEFAULT_NAME)) {
            account.setName(PropsValues.COMPANY_DEFAULT_NAME);
            AccountLocalServiceUtil.updateAccount((Account)account);
        }
    }

    private static boolean _writePropertiesFile(UnicodeProperties unicodeProperties) {
        try {
            FileUtil.write((String)PropsValues.LIFERAY_HOME, (String)PROPERTIES_FILE_NAME, (String)unicodeProperties.toString());
            return true;
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
            return false;
        }
    }
}

