/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.themepreview;

import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.StringServletResponse;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.strip.StripFilter;
import com.liferay.portal.theme.ThemeDisplay;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ThemePreviewFilter
extends BasePortalFilter {
    private static final String _THEME_PREVIEW = "themePreview";

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        return this.isThemePreview(request);
    }

    protected String getContent(HttpServletRequest request, String content) {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        Pattern cssPattern = Pattern.compile(themeDisplay.getPathThemeCss());
        Matcher cssMatcher = cssPattern.matcher(content);
        content = cssMatcher.replaceAll("css");
        Pattern imagePattern = Pattern.compile(themeDisplay.getPathThemeImages());
        Matcher imageMatcher = imagePattern.matcher(content);
        content = imageMatcher.replaceAll("images");
        return content;
    }

    protected boolean isThemePreview(HttpServletRequest request) {
        return ParamUtil.getBoolean((HttpServletRequest)request, (String)_THEME_PREVIEW);
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        request.setAttribute(StripFilter.SKIP_FILTER, (Object)Boolean.TRUE);
        StringServletResponse stringServerResponse = new StringServletResponse(response);
        this.processFilter(ThemePreviewFilter.class, request, (HttpServletResponse)stringServerResponse, filterChain);
        String content = this.getContent(request, stringServerResponse.getString());
        ServletResponseUtil.write((HttpServletResponse)response, (String)content);
    }
}

