/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.sso.opensso;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.sso.opensso.OpenSSOUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class OpenSSOFilter
extends BasePortalFilter {
    private static final String _SUBJECT_ID_KEY = "open.sso.subject.id";
    private static Log _log = LogFactoryUtil.getLog(OpenSSOFilter.class);

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        try {
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            boolean enabled = PrefsPropsUtil.getBoolean(companyId, "open.sso.auth.enabled", PropsValues.OPEN_SSO_AUTH_ENABLED);
            String loginUrl = PrefsPropsUtil.getString(companyId, "open.sso.login.url", PropsValues.OPEN_SSO_LOGIN_URL);
            String logoutUrl = PrefsPropsUtil.getString(companyId, "open.sso.logout.url", PropsValues.OPEN_SSO_LOGOUT_URL);
            String serviceUrl = PrefsPropsUtil.getString(companyId, "open.sso.service.url", PropsValues.OPEN_SSO_SERVICE_URL);
            if (enabled && Validator.isNotNull((String)loginUrl) && Validator.isNotNull((String)logoutUrl) && Validator.isNotNull((String)serviceUrl)) {
                return true;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return false;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        String currentURL;
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        String loginUrl = PrefsPropsUtil.getString(companyId, "open.sso.login.url", PropsValues.OPEN_SSO_LOGIN_URL);
        String logoutUrl = PrefsPropsUtil.getString(companyId, "open.sso.logout.url", PropsValues.OPEN_SSO_LOGOUT_URL);
        String serviceUrl = PrefsPropsUtil.getString(companyId, "open.sso.service.url", PropsValues.OPEN_SSO_SERVICE_URL);
        String requestURI = GetterUtil.getString((String)request.getRequestURI());
        if (requestURI.endsWith("/portal/logout")) {
            HttpSession session = request.getSession();
            session.invalidate();
            response.sendRedirect(logoutUrl);
            return;
        }
        boolean authenticated = false;
        try {
            authenticated = OpenSSOUtil.isAuthenticated(request, serviceUrl);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            this.processFilter(OpenSSOFilter.class, request, response, filterChain);
            return;
        }
        if (authenticated) {
            String newSubjectId = OpenSSOUtil.getSubjectId(request, serviceUrl);
            HttpSession session = request.getSession();
            String oldSubjectId = (String)session.getAttribute(_SUBJECT_ID_KEY);
            if (oldSubjectId == null) {
                session.setAttribute(_SUBJECT_ID_KEY, (Object)newSubjectId);
            } else if (!newSubjectId.equals(oldSubjectId)) {
                session.invalidate();
                session = request.getSession();
                session.setAttribute(_SUBJECT_ID_KEY, (Object)newSubjectId);
            }
            this.processFilter(OpenSSOFilter.class, request, response, filterChain);
            return;
        }
        if (!PropsValues.AUTH_FORWARD_BY_LAST_PATH || !loginUrl.contains("/portal/login")) {
            response.sendRedirect(loginUrl);
            return;
        }
        String redirect = currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
        if (currentURL.contains("/portal/login") && Validator.isNull((String)(redirect = ParamUtil.getString((HttpServletRequest)request, (String)"redirect")))) {
            redirect = PortalUtil.getPathMain();
        }
        redirect = String.valueOf(loginUrl) + HttpUtil.encodeURL((String)("?redirect=" + HttpUtil.encodeURL((String)redirect)));
        response.sendRedirect(redirect);
    }
}

