/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.secure;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ProtectedServletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.secure.NonceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SecureFilter
extends BasePortalFilter {
    public static final String _AUTHENTICATED_USER = SecureFilter.class + "_AUTHENTICATED_USER";
    private static final String _BASIC_REALM = "Basic realm=\"PortalRealm\"";
    private static final String _DIGEST_REALM = "Digest realm=\"PortalRealm\"";
    private static final String _SERVER_IP = "SERVER_IP";
    private static Log _log = LogFactoryUtil.getLog(SecureFilter.class);
    private boolean _basicAuthEnabled;
    private boolean _digestAuthEnabled;
    private Set<String> _hostsAllowed = new HashSet<String>();
    private boolean _httpsRequired;
    private boolean _usePermissionChecker;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._basicAuthEnabled = GetterUtil.getBoolean((String)filterConfig.getInitParameter("basic_auth"));
        this._digestAuthEnabled = GetterUtil.getBoolean((String)filterConfig.getInitParameter("digest_auth"));
        String propertyPrefix = filterConfig.getInitParameter("portal_property_prefix");
        String[] hostsAllowedArray = null;
        if (Validator.isNull((String)propertyPrefix)) {
            hostsAllowedArray = StringUtil.split((String)filterConfig.getInitParameter("hosts.allowed"));
            this._httpsRequired = GetterUtil.getBoolean((String)filterConfig.getInitParameter("https.required"));
        } else {
            hostsAllowedArray = PropsUtil.getArray(String.valueOf(propertyPrefix) + "hosts.allowed");
            this._httpsRequired = GetterUtil.getBoolean((String)PropsUtil.get(String.valueOf(propertyPrefix) + "https.required"));
        }
        int i = 0;
        while (i < hostsAllowedArray.length) {
            this._hostsAllowed.add(hostsAllowedArray[i]);
            ++i;
        }
    }

    protected boolean isAccessAllowed(HttpServletRequest request) {
        if (this._hostsAllowed.isEmpty()) {
            return true;
        }
        String remoteAddr = request.getRemoteAddr();
        if (this._hostsAllowed.contains(remoteAddr)) {
            return true;
        }
        String computerAddress = PortalUtil.getComputerAddress();
        return computerAddress.equals(remoteAddr) && this._hostsAllowed.contains(_SERVER_IP);
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        String remoteAddr = request.getRemoteAddr();
        if (this.isAccessAllowed(request)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Access allowed for " + remoteAddr));
            }
        } else {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Access denied for " + remoteAddr));
            }
            response.sendError(403, "Access denied for " + remoteAddr);
            return;
        }
        if (_log.isDebugEnabled()) {
            if (this._httpsRequired) {
                _log.debug((Object)"https is required");
            } else {
                _log.debug((Object)"https is not required");
            }
        }
        if (this._httpsRequired && !request.isSecure()) {
            if (_log.isDebugEnabled()) {
                String completeURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
                _log.debug((Object)("Securing " + completeURL));
            }
            StringBundler redirectURL = new StringBundler(5);
            redirectURL.append("https://");
            redirectURL.append(request.getServerName());
            redirectURL.append(request.getServletPath());
            String queryString = request.getQueryString();
            if (Validator.isNotNull((String)queryString)) {
                redirectURL.append("?");
                redirectURL.append(request.getQueryString());
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Redirect to " + redirectURL));
            }
            response.sendRedirect(redirectURL.toString());
        } else {
            if (_log.isDebugEnabled()) {
                String completeURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
                _log.debug((Object)("Not securing " + completeURL));
            }
            if (!PropsValues.PORTAL_JAAS_ENABLE) {
                User user = PortalUtil.getUser((HttpServletRequest)request);
                if (user != null && !user.isDefaultUser()) {
                    request = this.setCredentials(request, request.getSession(), user.getUserId());
                } else if (this._digestAuthEnabled) {
                    request = this.digestAuth(request, response);
                } else if (this._basicAuthEnabled) {
                    request = this.basicAuth(request, response);
                }
            }
            if (request != null) {
                this.processFilter(((Object)((Object)this)).getClass(), request, response, filterChain);
            }
        }
    }

    protected HttpServletRequest basicAuth(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        session.setAttribute("BASIC_AUTH_ENABLED", (Object)Boolean.TRUE);
        long userId = GetterUtil.getLong((String)((String)session.getAttribute(_AUTHENTICATED_USER)));
        if (userId > 0L) {
            request = new ProtectedServletRequest(request, String.valueOf(userId));
        } else {
            try {
                userId = PortalUtil.getBasicAuthUserId((HttpServletRequest)request);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            if (userId > 0L) {
                request = this.setCredentials(request, session, userId);
            } else {
                response.setHeader("WWW-Authenticate", _BASIC_REALM);
                response.setStatus(401);
                return null;
            }
        }
        return request;
    }

    protected HttpServletRequest digestAuth(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        long userId = GetterUtil.getLong((String)((String)session.getAttribute(_AUTHENTICATED_USER)));
        if (userId > 0L) {
            request = new ProtectedServletRequest(request, String.valueOf(userId));
        } else {
            try {
                userId = PortalUtil.getDigestAuthUserId((HttpServletRequest)request);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            if (userId > 0L) {
                request = this.setCredentials(request, session, userId);
            } else {
                long companyId = PortalInstances.getCompanyId(request);
                String remoteAddress = request.getRemoteAddr();
                String nonce = NonceUtil.generate(companyId, remoteAddress);
                StringBundler sb = new StringBundler(4);
                sb.append(_DIGEST_REALM);
                sb.append(", nonce=\"");
                sb.append(nonce);
                sb.append("\"");
                response.setHeader("WWW-Authenticate", sb.toString());
                response.setStatus(401);
                return null;
            }
        }
        return request;
    }

    protected HttpServletRequest setCredentials(HttpServletRequest request, HttpSession session, long userId) throws Exception {
        User user = UserLocalServiceUtil.getUser((long)userId);
        String userIdString = String.valueOf(userId);
        request = new ProtectedServletRequest(request, userIdString);
        session.setAttribute("USER", (Object)user);
        session.setAttribute(_AUTHENTICATED_USER, (Object)userIdString);
        if (this._usePermissionChecker) {
            PrincipalThreadLocal.setName((long)userId);
            PrincipalThreadLocal.setPassword((String)PortalUtil.getUserPassword((HttpServletRequest)request));
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user, (boolean)false);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
        return request;
    }

    protected void setUsePermissionChecker(boolean usePermissionChecker) {
        this._usePermissionChecker = usePermissionChecker;
    }
}

