/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.gzip;

import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;

public class GZipServletOutputStream
extends ServletOutputStream {
    private GZIPOutputStream _gZipOutputStream;

    public GZipServletOutputStream(OutputStream outputStream) throws IOException {
        this._gZipOutputStream = new GZIPOutputStream(outputStream){
            {
                this.def.setLevel(PropsValues.GZIP_COMPRESSION_LEVEL);
            }
        };
    }

    public void close() throws IOException {
        this._gZipOutputStream.close();
    }

    public void flush() throws IOException {
        this._gZipOutputStream.flush();
    }

    public void write(byte[] bytes) throws IOException {
        this._gZipOutputStream.write(bytes);
    }

    public void write(byte[] bytes, int offset, int length) throws IOException {
        this._gZipOutputStream.write(bytes, offset, length);
    }

    public void write(int b) throws IOException {
        this._gZipOutputStream.write(b);
    }
}

