/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.dynamiccss;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.SessionParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Theme;
import com.liferay.portal.scripting.ruby.RubyExecutor;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.servlet.filters.dynamiccss.DynamicCSSFilter;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.tools.SassToCssBuilder;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.time.StopWatch;

public class DynamicCSSUtil {
    private static final String _CSS_IMPORT_BEGIN = "@import url(";
    private static final String _CSS_IMPORT_END = ");";
    private static final String _SASS_DIR = String.valueOf(SystemProperties.get((String)"java.io.tmpdir")) + "/liferay/sass";
    private static Log _log = LogFactoryUtil.getLog(DynamicCSSUtil.class);
    private static Pattern _pluginThemePattern = Pattern.compile("\\/([^\\/]+)-theme\\/", 2);
    private static Pattern _portalThemePattern = Pattern.compile("themes\\/([^\\/]+)\\/css", 2);
    private static RubyExecutor _rubyExecutor = new RubyExecutor();
    private static String _rubyScript;

    public static void init() {
        try {
            _rubyScript = StringUtil.read((ClassLoader)PortalClassLoaderUtil.getClassLoader(), (String)"com/liferay/portal/servlet/filters/dynamiccss/main.rb");
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public static String parseSass(HttpServletRequest request, String cssRealPath, String content) throws Exception {
        if (!DynamicCSSFilter.ENABLED) {
            return content;
        }
        StopWatch stopWatch = null;
        if (_log.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        if (request == null) {
            return content;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        Theme theme = null;
        if (themeDisplay == null && (theme = DynamicCSSUtil._getTheme(request, cssRealPath)) == null) {
            String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No theme found for " + currentURL));
            }
            return content;
        }
        String parsedContent = null;
        boolean themeCssFastLoad = DynamicCSSUtil._isThemeCssFastLoad(request, themeDisplay);
        File cssRealFile = new File(cssRealPath);
        File cacheCssRealFile = SassToCssBuilder.getCacheFile(cssRealPath);
        if (themeCssFastLoad && cacheCssRealFile.exists() && cacheCssRealFile.lastModified() == cssRealFile.lastModified()) {
            parsedContent = FileUtil.read((File)cacheCssRealFile);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Loading SASS cache from " + cacheCssRealFile + " takes " + stopWatch.getTime() + " ms"));
            }
        } else {
            content = SassToCssBuilder.parseStaticTokens(content);
            String queryString = request.getQueryString();
            if (!themeCssFastLoad && Validator.isNotNull((String)queryString)) {
                content = DynamicCSSUtil._propagateQueryString(content, queryString);
            }
            parsedContent = DynamicCSSUtil._parseSass(request, themeDisplay, theme, cssRealPath, content);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Parsing SASS for " + cssRealPath + " takes " + stopWatch.getTime() + " ms"));
            }
        }
        if (Validator.isNull((String)parsedContent)) {
            return content;
        }
        parsedContent = StringUtil.replace((String)parsedContent, (String[])new String[]{"@portal_ctx@", "@theme_image_path@"}, (String[])new String[]{PortalUtil.getPathContext(), DynamicCSSUtil._getThemeImagesPath(request, themeDisplay, theme)});
        return parsedContent;
    }

    private static String _getCssThemePath(HttpServletRequest request, ThemeDisplay themeDisplay, Theme theme) throws Exception {
        String cssThemePath = null;
        if (themeDisplay != null) {
            cssThemePath = themeDisplay.getPathThemeCss();
        } else {
            String cdnHost = PortalUtil.getCDNHost((HttpServletRequest)request);
            String themeStaticResourcePath = theme.getStaticResourcePath();
            cssThemePath = String.valueOf(cdnHost) + themeStaticResourcePath + theme.getCssPath();
        }
        return cssThemePath;
    }

    private static Theme _getTheme(HttpServletRequest request, String cssRealPath) {
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        String themeId = ParamUtil.getString((HttpServletRequest)request, (String)"themeId");
        Matcher portalThemeMatcher = _portalThemePattern.matcher(cssRealPath);
        if (portalThemeMatcher.find()) {
            String themePathId = portalThemeMatcher.group(1);
            themePathId = StringUtil.replace((String)themePathId, (String)"_", (String)"");
            themeId = PortalUtil.getJsSafePortletId((String)themePathId);
        } else {
            Matcher pluginThemeMatcher = _pluginThemePattern.matcher(cssRealPath);
            if (pluginThemeMatcher.find()) {
                String themePathId = pluginThemeMatcher.group(1);
                themePathId = StringUtil.replace((String)themePathId, (String)"_", (String)"");
                StringBundler sb = new StringBundler(4);
                sb.append(themePathId);
                sb.append("_WAR_");
                sb.append(themePathId);
                sb.append("theme");
                themePathId = sb.toString();
                themeId = PortalUtil.getJsSafePortletId((String)themePathId);
            }
        }
        if (Validator.isNull((String)themeId)) {
            return null;
        }
        try {
            Theme theme = ThemeLocalServiceUtil.getTheme((long)companyId, (String)themeId, (boolean)false);
            return theme;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    private static String _getThemeImagesPath(HttpServletRequest request, ThemeDisplay themeDisplay, Theme theme) throws Exception {
        String themeImagesPath = null;
        if (themeDisplay != null) {
            themeImagesPath = themeDisplay.getPathThemeImages();
        } else {
            String cdnHost = PortalUtil.getCDNHost((HttpServletRequest)request);
            String themeStaticResourcePath = theme.getStaticResourcePath();
            themeImagesPath = String.valueOf(cdnHost) + themeStaticResourcePath + theme.getImagesPath();
        }
        return themeImagesPath;
    }

    private static boolean _isThemeCssFastLoad(HttpServletRequest request, ThemeDisplay themeDisplay) {
        if (themeDisplay != null) {
            return themeDisplay.isThemeCssFastLoad();
        }
        return SessionParamUtil.getBoolean((HttpServletRequest)request, (String)"css_fast_load", (boolean)PropsValues.THEME_CSS_FAST_LOAD);
    }

    private static String _parseSass(HttpServletRequest request, ThemeDisplay themeDisplay, Theme theme, String cssRealPath, String content) throws Exception {
        HashMap<String, Object> inputObjects = new HashMap<String, Object>();
        inputObjects.put("content", content);
        inputObjects.put("cssRealPath", cssRealPath);
        inputObjects.put("cssThemePath", DynamicCSSUtil._getCssThemePath(request, themeDisplay, theme));
        inputObjects.put("sassCachePath", _SASS_DIR);
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        UnsyncPrintWriter unsyncPrintWriter = UnsyncPrintWriterPool.borrow((OutputStream)unsyncByteArrayOutputStream);
        inputObjects.put("out", unsyncPrintWriter);
        _rubyExecutor.eval(null, inputObjects, null, _rubyScript);
        unsyncPrintWriter.flush();
        return unsyncByteArrayOutputStream.toString();
    }

    private static String _propagateQueryString(String content, String queryString) {
        StringBuilder sb = new StringBuilder(content.length());
        int pos = 0;
        while (true) {
            int importX = content.indexOf(_CSS_IMPORT_BEGIN, pos);
            int importY = content.indexOf(_CSS_IMPORT_END, importX + _CSS_IMPORT_BEGIN.length());
            if (importX == -1 || importY == -1) break;
            sb.append(content.substring(pos, importY));
            sb.append('?');
            sb.append(queryString);
            sb.append(_CSS_IMPORT_END);
            pos = importY + _CSS_IMPORT_END.length();
        }
        sb.append(content.substring(pos, content.length()));
        return sb.toString();
    }
}

