/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.dynamiccss.DynamicCSSUtil;
import com.liferay.portal.util.MinifierUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ComboServlet
extends HttpServlet {
    private static final String _CSS_EXTENSION = "css";
    private static final String _CSS_MINIFIED_SUFFIX = "-min.css";
    private static final FileContentBag _EMPTY_FILE_CONTENT_BAG = new FileContentBag(new byte[0], 0L);
    private static final String _JAVASCRIPT_DIR = "html/js";
    private static final String _JAVASCRIPT_MINIFIED_SUFFIX = "-min.js";
    private static Log _log = LogFactoryUtil.getLog(ComboServlet.class);
    private ConcurrentMap<String, byte[][]> _byteArrays = new ConcurrentHashMap<String, byte[][]>();
    private ConcurrentMap<String, FileContentBag> _fileContentBags = new ConcurrentHashMap<String, FileContentBag>();

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.doService(request, response);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            PortalUtil.sendError((int)500, (Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String contextPath = PortalUtil.getPathContext();
        Object[] modulePaths = request.getParameterValues("m");
        if (modulePaths == null || modulePaths.length == 0) {
            response.sendError(400);
            return;
        }
        Arrays.sort(modulePaths);
        String modulePathsString = null;
        Object bytesArray = null;
        if (!PropsValues.COMBO_CHECK_TIMESTAMP) {
            modulePathsString = Arrays.toString(modulePaths);
            bytesArray = (byte[][])this._byteArrays.get(modulePathsString);
        }
        Object firstModulePath = modulePaths[0];
        String extension = FileUtil.getExtension((String)firstModulePath);
        if (bytesArray == null) {
            String p = ParamUtil.getString((HttpServletRequest)request, (String)"p");
            String minifierType = ParamUtil.getString((HttpServletRequest)request, (String)"minifierType");
            if (Validator.isNull((String)minifierType)) {
                minifierType = "js";
                if (extension.equalsIgnoreCase(_CSS_EXTENSION)) {
                    minifierType = _CSS_EXTENSION;
                }
            }
            int length = modulePaths.length;
            bytesArray = new byte[length][];
            Object[] objectArray = modulePaths;
            int n = modulePaths.length;
            int n2 = 0;
            while (n2 < n) {
                Object modulePath = objectArray[n2];
                if (!this.validateModuleExtension((String)modulePath)) {
                    PortalUtil.sendError((int)404, (Exception)new IOException(), (HttpServletRequest)request, (HttpServletResponse)response);
                    return;
                }
                byte[] bytes = new byte[]{};
                if (Validator.isNotNull((String)modulePath)) {
                    modulePath = StringUtil.replaceFirst((String)p.concat((String)modulePath), (String)contextPath, (String)"");
                    bytes = this.getFileContent(request, response, (String)modulePath, minifierType);
                }
                bytesArray[--length] = bytes;
                ++n2;
            }
            if (modulePathsString != null) {
                this._byteArrays.put(modulePathsString, (byte[][])bytesArray);
            }
        }
        String contentType = "text/javascript";
        if (extension.equalsIgnoreCase(_CSS_EXTENSION)) {
            contentType = "text/css";
        }
        response.setContentType(contentType);
        ServletResponseUtil.write((HttpServletResponse)response, (byte[][])bytesArray);
    }

    protected File getFile(String path) throws IOException {
        ServletContext servletContext = this.getServletContext();
        String basePath = ServletContextUtil.getRealPath((ServletContext)servletContext, (String)_JAVASCRIPT_DIR);
        if (basePath == null) {
            return null;
        }
        File baseDir = new File(basePath = StringUtil.replace((String)basePath, (char)'\\', (char)'/'));
        if (!baseDir.exists()) {
            return null;
        }
        String filePath = ServletContextUtil.getRealPath((ServletContext)servletContext, (String)path);
        if (filePath == null) {
            return null;
        }
        File file = new File(filePath = StringUtil.replace((String)filePath, (char)'\\', (char)'/'));
        if (!file.exists()) {
            return null;
        }
        String baseCanonicalPath = baseDir.getCanonicalPath();
        String fileCanonicalPath = file.getCanonicalPath();
        if (fileCanonicalPath.indexOf(baseCanonicalPath) == 0) {
            return file;
        }
        return null;
    }

    protected byte[] getFileContent(HttpServletRequest request, HttpServletResponse response, String path, String minifierType) throws IOException {
        String fileContentKey = path.concat("?").concat(minifierType);
        FileContentBag fileContentBag = (FileContentBag)this._fileContentBags.get(fileContentKey);
        if (fileContentBag != null && !PropsValues.COMBO_CHECK_TIMESTAMP) {
            return fileContentBag._fileContent;
        }
        File file = this.getFile(path);
        if (fileContentBag != null && PropsValues.COMBO_CHECK_TIMESTAMP) {
            long elapsedTime = System.currentTimeMillis() - fileContentBag._lastModified;
            if (file != null && elapsedTime <= PropsValues.COMBO_CHECK_TIMESTAMP_INTERVAL && file.lastModified() == fileContentBag._lastModified) {
                return fileContentBag._fileContent;
            }
            this._fileContentBags.remove(fileContentKey, fileContentBag);
        }
        if (file == null) {
            fileContentBag = _EMPTY_FILE_CONTENT_BAG;
        } else {
            String stringFileContent = FileUtil.read((File)file);
            if (!StringUtil.endsWith((String)path, (String)_CSS_MINIFIED_SUFFIX) && !StringUtil.endsWith((String)path, (String)_JAVASCRIPT_MINIFIED_SUFFIX)) {
                if (minifierType.equals(_CSS_EXTENSION)) {
                    String cssRealPath = file.getAbsolutePath();
                    try {
                        stringFileContent = DynamicCSSUtil.parseSass(request, cssRealPath, stringFileContent);
                    }
                    catch (Exception e) {
                        _log.error((Object)("Unable to parse SASS on CSS " + cssRealPath), (Throwable)e);
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)stringFileContent);
                        }
                        response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
                    }
                    stringFileContent = MinifierUtil.minifyCss(stringFileContent);
                } else if (minifierType.equals("js")) {
                    stringFileContent = MinifierUtil.minifyJavaScript(stringFileContent);
                }
            }
            fileContentBag = new FileContentBag(stringFileContent.getBytes("UTF-8"), file.lastModified());
        }
        FileContentBag oldFileContentBag = this._fileContentBags.putIfAbsent(fileContentKey, fileContentBag);
        if (oldFileContentBag != null) {
            fileContentBag = oldFileContentBag;
        }
        return fileContentBag._fileContent;
    }

    protected boolean validateModuleExtension(String moduleName) throws Exception {
        boolean validModuleExtension = false;
        String[] fileExtensions = PrefsPropsUtil.getStringArray("combo.allowed.file.extensions", ",");
        int i = 0;
        while (i < fileExtensions.length) {
            if ("*".equals(fileExtensions[i]) || StringUtil.endsWith((String)moduleName, (String)fileExtensions[i])) {
                validModuleExtension = true;
                break;
            }
            ++i;
        }
        return validModuleExtension;
    }

    private static class FileContentBag {
        private byte[] _fileContent;
        private long _lastModified;

        public FileContentBag(byte[] fileContent, long lastModifiedTime) {
            this._fileContent = fileContent;
            this._lastModified = lastModifiedTime;
        }
    }
}

