/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalInstances;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AxisServlet
extends com.liferay.util.axis.AxisServlet {
    private static Log _log = LogFactoryUtil.getLog(AxisServlet.class);
    private ClassLoader _portletClassLoader;

    public void init(ServletConfig servletConfig) throws ServletException {
        ServletContext servletContext = servletConfig.getServletContext();
        this._portletClassLoader = (ClassLoader)servletContext.getAttribute("PORTLET_CLASS_LOADER");
        if (this._portletClassLoader == null) {
            super.init(servletConfig);
        } else {
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(this._portletClassLoader);
                super.init(servletConfig);
            }
            finally {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block10: {
            try {
                PortalInstances.getCompanyId(request);
                String remoteUser = request.getRemoteUser();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Remote user " + remoteUser));
                }
                if (remoteUser != null) {
                    PrincipalThreadLocal.setName((String)remoteUser);
                    long userId = GetterUtil.getLong((String)remoteUser);
                    User user = UserLocalServiceUtil.getUserById((long)userId);
                    PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user, (boolean)true);
                    PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
                }
                if (this._portletClassLoader == null) {
                    super.service(request, response);
                    break block10;
                }
                Thread currentThread = Thread.currentThread();
                ClassLoader contextClassLoader = currentThread.getContextClassLoader();
                try {
                    currentThread.setContextClassLoader(this._portletClassLoader);
                    super.service(request, response);
                }
                finally {
                    currentThread.setContextClassLoader(contextClassLoader);
                }
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (ServletException se) {
                throw se;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }
}

