/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.impl.GroupImpl;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portal.service.ResourceBlockLocalServiceUtil;
import com.liferay.portal.service.persistence.GroupFinder;
import com.liferay.portal.service.persistence.GroupUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupFinderImpl
extends BasePersistenceImpl<Group>
implements GroupFinder {
    public static String COUNT_BY_GROUP_ID = String.valueOf(GroupFinder.class.getName()) + ".countByGroupId";
    public static String COUNT_BY_C_N_D = String.valueOf(GroupFinder.class.getName()) + ".countByC_N_D";
    public static String FIND_BY_LIVE_GROUPS = String.valueOf(GroupFinder.class.getName()) + ".findByLiveGroups";
    public static String FIND_BY_NO_LAYOUTS = String.valueOf(GroupFinder.class.getName()) + ".findByNoLayouts";
    public static String FIND_BY_NULL_FRIENDLY_URL = String.valueOf(GroupFinder.class.getName()) + ".findByNullFriendlyURL";
    public static String FIND_BY_SYSTEM = String.valueOf(GroupFinder.class.getName()) + ".findBySystem";
    public static String FIND_BY_C_C = String.valueOf(GroupFinder.class.getName()) + ".findByC_C";
    public static String FIND_BY_C_N = String.valueOf(GroupFinder.class.getName()) + ".findByC_N";
    public static String FIND_BY_C_N_D = String.valueOf(GroupFinder.class.getName()) + ".findByC_N_D";
    public static String JOIN_BY_ACTIVE = String.valueOf(GroupFinder.class.getName()) + ".joinByActive";
    public static String JOIN_BY_CREATOR_USER_ID = String.valueOf(GroupFinder.class.getName()) + ".joinByCreatorUserId";
    public static String JOIN_BY_GROUP_ORG = String.valueOf(GroupFinder.class.getName()) + ".joinByGroupOrg";
    public static String JOIN_BY_GROUPS_ORGS = String.valueOf(GroupFinder.class.getName()) + ".joinByGroupsOrgs";
    public static String JOIN_BY_GROUPS_ROLES = String.valueOf(GroupFinder.class.getName()) + ".joinByGroupsRoles";
    public static String JOIN_BY_GROUPS_USER_GROUPS = String.valueOf(GroupFinder.class.getName()) + ".joinByGroupsUserGroups";
    public static String JOIN_BY_LAYOUT_SET = String.valueOf(GroupFinder.class.getName()) + ".joinByLayoutSet";
    public static String JOIN_BY_PAGE_COUNT = String.valueOf(GroupFinder.class.getName()) + ".joinByPageCount";
    public static String JOIN_BY_ROLE_PERMISSIONS = String.valueOf(GroupFinder.class.getName()) + ".joinByRolePermissions";
    public static String JOIN_BY_ROLE_RESOURCE_PERMISSIONS = String.valueOf(GroupFinder.class.getName()) + ".joinByRoleResourcePermissions";
    public static String JOIN_BY_ROLE_RESOURCE_TYPE_PERMISSIONS = String.valueOf(GroupFinder.class.getName()) + ".joinByRoleResourceTypePermissions";
    public static String JOIN_BY_SITE = String.valueOf(GroupFinder.class.getName()) + ".joinBySite";
    public static String JOIN_BY_TYPE = String.valueOf(GroupFinder.class.getName()) + ".joinByType";
    public static String JOIN_BY_USER_GROUP_ROLE = String.valueOf(GroupFinder.class.getName()) + ".joinByUserGroupRole";
    public static String JOIN_BY_USERS_GROUPS = String.valueOf(GroupFinder.class.getName()) + ".joinByUsersGroups";
    private LinkedHashMap<String, Object> _emptyLinkedHashMap = new LinkedHashMap(0);
    private Map<String, String> _findByCompanyIdSQLCache = new ConcurrentHashMap<String, String>();
    private Map<String, String> _findByC_C_N_DSQLCache = new ConcurrentHashMap<String, String>();
    private volatile long[] _groupOrganizationClassNameIds;
    private volatile Map<String, String> _joinMap;
    private Map<String, String> _replaceJoinAndWhereSQLCache = new ConcurrentHashMap<String, String>();
    private volatile Map<String, String> _whereMap;

    public int countByG_U(long groupId, long userId, boolean inherit) throws SystemException {
        LinkedHashMap<String, Object> params1 = new LinkedHashMap<String, Object>();
        params1.put("usersGroups", userId);
        LinkedHashMap<String, Object> params2 = new LinkedHashMap<String, Object>();
        params2.put("groupOrg", userId);
        LinkedHashMap<String, Object> params3 = new LinkedHashMap<String, Object>();
        params3.put("groupsOrgs", userId);
        LinkedHashMap<String, Object> params4 = new LinkedHashMap<String, Object>();
        params4.put("groupsUserGroups", userId);
        Session session = null;
        try {
            session = this.openSession();
            int count = this.countByGroupId(session, groupId, params1);
            if (inherit) {
                count += this.countByGroupId(session, groupId, params2);
                count += this.countByGroupId(session, groupId, params3);
                count += this.countByGroupId(session, groupId, params4);
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByC_N_D(long companyId, String name, String realName, String description, LinkedHashMap<String, Object> params) throws SystemException {
        return this.countByC_C_N_D(companyId, this._getGroupOrganizationClassNameIds(), name, realName, description, params);
    }

    public int countByC_C_N_D(long companyId, long[] classNameIds, String name, String realName, String description, LinkedHashMap<String, Object> params) throws SystemException {
        name = StringUtil.lowerCase((String)name);
        description = StringUtil.lowerCase((String)description);
        if (params == null) {
            params = this._emptyLinkedHashMap;
        }
        Long userId = (Long)params.get("usersGroups");
        boolean doUnion = Validator.isNotNull((Long)userId);
        LinkedHashMap<String, Object> params1 = params;
        LinkedHashMap<String, Object> params2 = null;
        LinkedHashMap<String, Object> params3 = null;
        LinkedHashMap<String, Object> params4 = null;
        if (doUnion) {
            params2 = new LinkedHashMap<String, Object>(params1);
            params2.remove("usersGroups");
            params2.put("groupOrg", userId);
            params3 = new LinkedHashMap<String, Object>(params1);
            params3.remove("usersGroups");
            params3.put("groupsOrgs", userId);
            params4 = new LinkedHashMap<String, Object>(params1);
            params4.remove("usersGroups");
            params4.put("groupsUserGroups", userId);
        }
        Session session = null;
        try {
            session = this.openSession();
            HashSet<Long> groupIds = new HashSet<Long>();
            groupIds.addAll(this.countByC_C_N_D(session, companyId, classNameIds, name, realName, description, params1));
            if (doUnion) {
                groupIds.addAll(this.countByC_C_N_D(session, companyId, classNameIds, name, realName, description, params2));
                groupIds.addAll(this.countByC_C_N_D(session, companyId, classNameIds, name, realName, description, params3));
                groupIds.addAll(this.countByC_C_N_D(session, companyId, classNameIds, name, realName, description, params4));
            }
            int n = groupIds.size();
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByLiveGroups() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_LIVE_GROUPS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByNoLayouts(long classNameId, boolean privateLayout, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_LAYOUTS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(classNameId);
            qPos.add(privateLayout);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByNullFriendlyURL() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NULL_FRIENDLY_URL);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findBySystem(long companyId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_SYSTEM);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Group> findByCompanyId(long companyId, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        if (params == null) {
            params = this._emptyLinkedHashMap;
        }
        Long userId = (Long)params.get("usersGroups");
        boolean inherit = GetterUtil.getBoolean((Object)params.get("inherit"), (boolean)true);
        boolean doUnion = Validator.isNotNull((Long)userId) && inherit;
        LinkedHashMap<String, Object> params1 = params;
        LinkedHashMap<String, Object> params2 = null;
        LinkedHashMap<String, Object> params3 = null;
        LinkedHashMap<String, Object> params4 = null;
        if (doUnion) {
            params2 = new LinkedHashMap<String, Object>(params1);
            params2.remove("usersGroups");
            params2.put("groupOrg", userId);
            params3 = new LinkedHashMap<String, Object>(params1);
            params3.remove("usersGroups");
            params3.put("groupsOrgs", userId);
            params4 = new LinkedHashMap<String, Object>(params1);
            params4.remove("usersGroups");
            params4.put("groupsUserGroups", userId);
        }
        String sql = null;
        String sqlKey = this._buildSQLKey(params1, params2, params3, params4, obc, doUnion);
        sql = this._findByCompanyIdSQLCache.get(sqlKey);
        if (sql == null) {
            String findByC_C_SQL = CustomSQLUtil.get((String)FIND_BY_C_C);
            if (params.get("active") == Boolean.TRUE) {
                findByC_C_SQL = StringUtil.replace((String)findByC_C_SQL, (String)"(Group_.liveGroupId = 0) AND", (String)"");
            }
            findByC_C_SQL = StringUtil.replace((String)findByC_C_SQL, (String)"Group_.classNameId = ?", (String)"Group_.classNameId = ".concat(StringUtil.merge((long[])this._getGroupOrganizationClassNameIds(), (String)" OR Group_.classNameId = ")));
            StringBundler sb = new StringBundler();
            sb.append("(");
            sb.append(this.replaceJoinAndWhere(findByC_C_SQL, params1));
            sb.append(")");
            if (doUnion) {
                sb.append(" UNION (");
                sb.append(this.replaceJoinAndWhere(findByC_C_SQL, params2));
                sb.append(") UNION (");
                sb.append(this.replaceJoinAndWhere(findByC_C_SQL, params3));
                sb.append(") UNION (");
                sb.append(this.replaceJoinAndWhere(findByC_C_SQL, params4));
                sb.append(")");
            }
            if (obc != null) {
                sb.append(" ORDER BY ");
                sb.append(obc.toString());
            }
            sql = sb.toString();
            this._findByCompanyIdSQLCache.put(sqlKey, sql);
        }
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("groupId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params1);
            qPos.add(companyId);
            if (doUnion) {
                this.setJoin(qPos, params2);
                qPos.add(companyId);
                this.setJoin(qPos, params3);
                qPos.add(companyId);
                this.setJoin(qPos, params4);
                qPos.add(companyId);
            }
            List groupIds = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            ArrayList<Group> groups = new ArrayList<Group>(groupIds.size());
            for (Long groupId : groupIds) {
                Group group = GroupUtil.findByPrimaryKey((long)groupId);
                groups.add(group);
            }
            ArrayList<Group> arrayList = groups;
            return arrayList;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public Group findByC_N(long companyId, String name) throws NoSuchGroupException, SystemException {
        name = StringUtil.lowerCase((String)name);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_N);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Group_", GroupImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(name);
            List groups = q.list();
            if (!groups.isEmpty()) {
                Group group = (Group)groups.get(0);
                return group;
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
        StringBundler sb = new StringBundler(5);
        sb.append("No Group exists with the key {companyId=");
        sb.append(companyId);
        sb.append(", name=");
        sb.append(name);
        sb.append("}");
        throw new NoSuchGroupException(sb.toString());
    }

    public List<Group> findByC_N_D(long companyId, String name, String realName, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        return this.findByC_C_N_D(companyId, this._getGroupOrganizationClassNameIds(), name, realName, description, params, start, end, obc);
    }

    public List<Group> findByC_C_N_D(long companyId, long[] classNameIds, String name, String realName, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        name = StringUtil.lowerCase((String)name);
        description = StringUtil.lowerCase((String)description);
        if (params == null) {
            params = this._emptyLinkedHashMap;
        }
        Long userId = (Long)params.get("usersGroups");
        boolean inherit = GetterUtil.getBoolean((Object)params.get("inherit"), (boolean)true);
        boolean doUnion = Validator.isNotNull((Long)userId) && inherit;
        LinkedHashMap<String, Object> params1 = params;
        LinkedHashMap<String, Object> params2 = null;
        LinkedHashMap<String, Object> params3 = null;
        LinkedHashMap<String, Object> params4 = null;
        if (doUnion) {
            params2 = new LinkedHashMap<String, Object>(params1);
            params2.remove("usersGroups");
            params2.put("groupOrg", userId);
            params3 = new LinkedHashMap<String, Object>(params1);
            params3.remove("usersGroups");
            params3.put("groupsOrgs", userId);
            params4 = new LinkedHashMap<String, Object>(params1);
            params4.remove("usersGroups");
            params4.put("groupsUserGroups", userId);
        }
        String sql = null;
        if (classNameIds == this._getGroupOrganizationClassNameIds()) {
            String sqlKey = this._buildSQLKey(params1, params2, params3, params4, obc, doUnion);
            sql = this._findByC_C_N_DSQLCache.get(sqlKey);
        }
        if (sql == null) {
            String findByC_N_D_SQL = CustomSQLUtil.get((String)FIND_BY_C_N_D);
            findByC_N_D_SQL = classNameIds == null ? StringUtil.replace((String)findByC_N_D_SQL, (String)"AND (Group_.classNameId = ?)", (String)"") : StringUtil.replace((String)findByC_N_D_SQL, (String)"Group_.classNameId = ?", (String)"Group_.classNameId = ".concat(StringUtil.merge((long[])classNameIds, (String)" OR Group_.classNameId = ")));
            StringBundler sb = new StringBundler();
            sb.append("(");
            sb.append(this.replaceJoinAndWhere(findByC_N_D_SQL, params1));
            sb.append(")");
            if (doUnion) {
                sb.append(" UNION (");
                sb.append(this.replaceJoinAndWhere(findByC_N_D_SQL, params2));
                sb.append(") UNION (");
                sb.append(this.replaceJoinAndWhere(findByC_N_D_SQL, params3));
                sb.append(") UNION (");
                sb.append(this.replaceJoinAndWhere(findByC_N_D_SQL, params4));
                sb.append(")");
            }
            if (obc != null) {
                sb.append(" ORDER BY ");
                sb.append(obc.toString());
            }
            sql = sb.toString();
            if (classNameIds == this._getGroupOrganizationClassNameIds()) {
                String sqlKey = this._buildSQLKey(params1, params2, params3, params4, obc, doUnion);
                this._findByC_C_N_DSQLCache.put(sqlKey, sql);
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("groupId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params1);
            qPos.add(companyId);
            qPos.add(name);
            qPos.add(realName);
            qPos.add(name);
            qPos.add(description);
            qPos.add(description);
            if (doUnion) {
                this.setJoin(qPos, params2);
                qPos.add(companyId);
                qPos.add(name);
                qPos.add(realName);
                qPos.add(name);
                qPos.add(description);
                qPos.add(description);
                this.setJoin(qPos, params3);
                qPos.add(companyId);
                qPos.add(name);
                qPos.add(realName);
                qPos.add(name);
                qPos.add(description);
                qPos.add(description);
                this.setJoin(qPos, params4);
                qPos.add(companyId);
                qPos.add(name);
                qPos.add(realName);
                qPos.add(name);
                qPos.add(description);
                qPos.add(description);
            }
            List groupIds = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            ArrayList<Group> groups = new ArrayList<Group>(groupIds.size());
            for (Long groupId : groupIds) {
                Group group = GroupUtil.findByPrimaryKey((long)groupId);
                groups.add(group);
            }
            ArrayList<Group> arrayList = groups;
            return arrayList;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int countByGroupId(Session session, long groupId, LinkedHashMap<String, Object> params) {
        Long count;
        String sql = CustomSQLUtil.get((String)COUNT_BY_GROUP_ID);
        sql = this.replaceJoinAndWhere(sql, params);
        SQLQuery q = session.createSQLQuery(sql);
        q.addScalar("COUNT_VALUE", Type.LONG);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        this.setJoin(qPos, params);
        qPos.add(groupId);
        Iterator itr = q.iterate();
        if (itr.hasNext() && (count = (Long)itr.next()) != null) {
            return count.intValue();
        }
        return 0;
    }

    protected List<Long> countByC_C_N_D(Session session, long companyId, long[] classNameIds, String name, String realName, String description, LinkedHashMap<String, Object> params) {
        String sql = CustomSQLUtil.get((String)COUNT_BY_C_N_D);
        sql = classNameIds == null ? StringUtil.replace((String)sql, (String)"AND (Group_.classNameId = ?)", (String)"") : StringUtil.replace((String)sql, (String)"Group_.classNameId = ?", (String)"Group_.classNameId = ".concat(StringUtil.merge((long[])classNameIds, (String)" OR Group_.classNameId = ")));
        sql = this.replaceJoinAndWhere(sql, params);
        SQLQuery q = session.createSQLQuery(sql);
        q.addScalar("groupId", Type.LONG);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        this.setJoin(qPos, params);
        qPos.add(companyId);
        qPos.add(name);
        qPos.add(realName);
        qPos.add(name);
        qPos.add(description);
        qPos.add(description);
        return q.list(true);
    }

    protected String getJoin(LinkedHashMap<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Map<String, String> joinMap;
            String joinValue;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (Validator.isNull((Object)value)) continue;
            if (key.equals("rolePermissions") && PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                List values = (List)value;
                String name = (String)values.get(0);
                key = ResourceBlockLocalServiceUtil.isSupported((String)name) ? "rolePermissions_6_block" : "rolePermissions_6";
            }
            if (!Validator.isNotNull((String)(joinValue = (joinMap = this._getJoinMap()).get(key)))) continue;
            sb.append(joinValue);
        }
        return sb.toString();
    }

    protected String getWhere(LinkedHashMap<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Map<String, String> whereMap;
            String whereValue;
            String key = entry.getKey();
            if (key.equals("types")) {
                List types = (List)entry.getValue();
                if (types.isEmpty()) continue;
                sb.append("(");
                int i = 0;
                while (i < types.size()) {
                    sb.append("(Group_.type_ = ?) ");
                    if (i + 1 < types.size()) {
                        sb.append("OR ");
                    }
                    ++i;
                }
                sb.append(") AND ");
                continue;
            }
            if (key.equals("rolePermissions") && PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                List values = (List)entry.getValue();
                String name = (String)values.get(0);
                key = ResourceBlockLocalServiceUtil.isSupported((String)name) ? "rolePermissions_6_block" : "rolePermissions_6";
            }
            if (!Validator.isNotNull((String)(whereValue = (whereMap = this._getWhereMap()).get(key)))) continue;
            sb.append(whereValue);
        }
        return sb.toString();
    }

    protected String replaceJoinAndWhere(String sql, LinkedHashMap<String, Object> params) {
        if (params.isEmpty()) {
            return StringUtil.replace((String)sql, (String[])new String[]{"[$JOIN$]", "[$WHERE$]"}, (String[])new String[]{"", ""});
        }
        String cacheKey = this._getCacheKey(sql, params);
        String resultSQL = this._replaceJoinAndWhereSQLCache.get(cacheKey);
        if (resultSQL == null) {
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
            resultSQL = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
            this._replaceJoinAndWhereSQLCache.put(cacheKey, resultSQL);
        }
        return resultSQL;
    }

    protected void setJoin(QueryPos qPos, LinkedHashMap<String, Object> params) {
        if (params == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String valueString;
            List values;
            Object value;
            String key = entry.getKey();
            if (key.equals("active") || key.equals("layoutSet") || key.equals("site")) {
                value = (Boolean)entry.getValue();
                qPos.add((Boolean)value);
                continue;
            }
            if (key.equals("pageCount")) continue;
            if (key.equals("rolePermissions")) {
                values = (List)entry.getValue();
                String name = (String)values.get(0);
                Integer scope = (Integer)values.get(1);
                String actionId = (String)values.get(2);
                Long roleId = (Long)values.get(3);
                if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6 && ResourceBlockLocalServiceUtil.isSupported((String)name)) {
                    qPos.add(name);
                    qPos.add(roleId);
                    qPos.add(actionId);
                    continue;
                }
                qPos.add(name);
                qPos.add(scope);
                qPos.add(actionId);
                qPos.add(roleId);
                continue;
            }
            if (key.equals("types")) {
                values = (List)entry.getValue();
                int i = 0;
                while (i < values.size()) {
                    Integer value2 = (Integer)values.get(i);
                    qPos.add(value2);
                    ++i;
                }
                continue;
            }
            if (key.equals("userGroupRole")) {
                values = (List)entry.getValue();
                Long userId = (Long)values.get(0);
                Long roleId = (Long)values.get(1);
                qPos.add(userId);
                qPos.add(roleId);
                continue;
            }
            value = entry.getValue();
            if (value instanceof Integer) {
                Integer valueInteger = (Integer)value;
                if (!Validator.isNotNull((Object)valueInteger)) continue;
                qPos.add(valueInteger);
                continue;
            }
            if (value instanceof Long) {
                Long valueLong = (Long)value;
                if (!Validator.isNotNull((Long)valueLong)) continue;
                qPos.add(valueLong);
                continue;
            }
            if (!(value instanceof String) || !Validator.isNotNull((String)(valueString = (String)value))) continue;
            qPos.add(valueString);
        }
    }

    private String _buildSQLKey(LinkedHashMap<String, Object> param1, LinkedHashMap<String, Object> param2, LinkedHashMap<String, Object> param3, LinkedHashMap<String, Object> param4, OrderByComparator obc, boolean doUnion) {
        StringBundler sb = null;
        if (doUnion) {
            sb = new StringBundler(param1.size() + param2.size() + param3.size() + param4.size() + 1);
            for (String key : param1.keySet()) {
                sb.append(key);
            }
            for (String key : param2.keySet()) {
                sb.append(key);
            }
            for (String key : param3.keySet()) {
                sb.append(key);
            }
            for (String key : param4.keySet()) {
                sb.append(key);
            }
        } else {
            sb = new StringBundler(param1.size() + 1);
            for (String key : param1.keySet()) {
                sb.append(key);
            }
        }
        sb.append(obc.getOrderBy());
        return sb.toString();
    }

    private String _getCacheKey(String sql, LinkedHashMap<String, Object> params) {
        StringBundler sb = new StringBundler(params.size() + 1);
        sb.append(sql);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            if (key.equals("rolePermissions") && PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                List values = (List)entry.getValue();
                String name = (String)values.get(0);
                key = ResourceBlockLocalServiceUtil.isSupported((String)name) ? "rolePermissions_6_block" : "rolePermissions_6";
            }
            sb.append(key);
        }
        return sb.toString();
    }

    private String _getCondition(String join) {
        if (Validator.isNotNull((String)join)) {
            int pos = join.indexOf("WHERE");
            join = pos != -1 ? join.substring(pos + 5, join.length()).concat(" AND ") : "";
        }
        return join;
    }

    private String _removeWhere(String join) {
        int pos;
        if (Validator.isNotNull((String)join) && (pos = join.indexOf("WHERE")) != -1) {
            join = join.substring(0, pos);
        }
        return join;
    }

    private long[] _getGroupOrganizationClassNameIds() {
        if (this._groupOrganizationClassNameIds == null) {
            this._groupOrganizationClassNameIds = new long[]{ClassNameLocalServiceUtil.getClassNameId(Group.class), ClassNameLocalServiceUtil.getClassNameId(Organization.class)};
        }
        return this._groupOrganizationClassNameIds;
    }

    private Map<String, String> _getJoinMap() {
        if (this._joinMap != null) {
            return this._joinMap;
        }
        HashMap<String, String> joinMap = new HashMap<String, String>();
        joinMap.put("active", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_ACTIVE)));
        joinMap.put("groupOrg", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_GROUP_ORG)));
        joinMap.put("groupsOrgs", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_GROUPS_ORGS)));
        joinMap.put("groupsRoles", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_GROUPS_ROLES)));
        joinMap.put("groupsUserGroups", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_GROUPS_USER_GROUPS)));
        joinMap.put("layoutSet", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_LAYOUT_SET)));
        joinMap.put("pageCount", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_PAGE_COUNT)));
        joinMap.put("rolePermissions", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_ROLE_PERMISSIONS)));
        joinMap.put("rolePermissions_6", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_ROLE_RESOURCE_PERMISSIONS)));
        joinMap.put("rolePermissions_6_block", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_ROLE_RESOURCE_TYPE_PERMISSIONS)));
        joinMap.put("site", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_SITE)));
        joinMap.put("type", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_TYPE)));
        joinMap.put("userGroupRole", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_USER_GROUP_ROLE)));
        joinMap.put("usersGroups", this._removeWhere(CustomSQLUtil.get((String)JOIN_BY_USERS_GROUPS)));
        this._joinMap = joinMap;
        return this._joinMap;
    }

    private Map<String, String> _getWhereMap() {
        if (this._whereMap != null) {
            return this._whereMap;
        }
        HashMap<String, String> whereMap = new HashMap<String, String>();
        whereMap.put("active", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_ACTIVE)));
        whereMap.put("creatorUserId", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_CREATOR_USER_ID)));
        whereMap.put("groupOrg", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_GROUP_ORG)));
        whereMap.put("groupsOrgs", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_GROUPS_ORGS)));
        whereMap.put("groupsRoles", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_GROUPS_ROLES)));
        whereMap.put("groupsUserGroups", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_GROUPS_USER_GROUPS)));
        whereMap.put("layoutSet", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_LAYOUT_SET)));
        whereMap.put("pageCount", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_PAGE_COUNT)));
        whereMap.put("rolePermissions", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_ROLE_PERMISSIONS)));
        whereMap.put("rolePermissions_6", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_ROLE_RESOURCE_PERMISSIONS)));
        whereMap.put("rolePermissions_6_block", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_ROLE_RESOURCE_TYPE_PERMISSIONS)));
        whereMap.put("site", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_SITE)));
        whereMap.put("type", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_TYPE)));
        whereMap.put("userGroupRole", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_USER_GROUP_ROLE)));
        whereMap.put("usersGroups", this._getCondition(CustomSQLUtil.get((String)JOIN_BY_USERS_GROUPS)));
        this._whereMap = whereMap;
        return this._whereMap;
    }
}

