/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.permission.GroupPermission;
import com.liferay.portal.service.permission.OrganizationPermissionUtil;
import java.util.List;

public class GroupPermissionImpl
implements GroupPermission {
    public void check(PermissionChecker permissionChecker, long groupId, String actionId) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, groupId, actionId)) {
            throw new PrincipalException();
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, String actionId) throws PortalException, SystemException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (group.isUser()) {
            long userId = group.getClassPK();
            List organizations = OrganizationLocalServiceUtil.getUserOrganizations((long)userId);
            for (Organization organization : organizations) {
                if (!OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)organization.getOrganizationId(), (String)"MANAGE_USERS")) continue;
                return true;
            }
        }
        if (actionId.equals("ADD_LAYOUT")) {
            if (permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "MANAGE_LAYOUTS")) {
                return true;
            }
        } else {
            if ((actionId.equals("EXPORT_IMPORT_LAYOUTS") || actionId.equals("EXPORT_IMPORT_PORTLET_INFO")) && permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "PUBLISH_STAGING")) {
                return true;
            }
            if (actionId.equals("VIEW_STAGING") && (permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "MANAGE_LAYOUTS") || permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "MANAGE_STAGING") || permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "PUBLISH_STAGING") || permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "UPDATE"))) {
                return true;
            }
        }
        return permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, actionId);
    }
}

