/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.RequiredUserException;
import com.liferay.portal.ReservedUserEmailAddressException;
import com.liferay.portal.UserEmailAddressException;
import com.liferay.portal.UserScreenNameException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.model.Website;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.UserServiceBaseImpl;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.service.permission.PasswordPolicyPermissionUtil;
import com.liferay.portal.service.permission.PortalPermissionUtil;
import com.liferay.portal.service.permission.RolePermissionUtil;
import com.liferay.portal.service.permission.TeamPermissionUtil;
import com.liferay.portal.service.permission.UserGroupPermissionUtil;
import com.liferay.portal.service.permission.UserGroupRolePermissionUtil;
import com.liferay.portal.service.permission.UserPermissionUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.announcements.model.AnnouncementsDelivery;
import com.liferay.portlet.usersadmin.util.UsersAdminUtil;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserServiceImpl
extends UserServiceBaseImpl {
    public void addGroupUsers(long groupId, long[] userIds, ServiceContext serviceContext) throws PortalException, SystemException {
        block6: {
            try {
                GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ASSIGN_MEMBERS");
            }
            catch (PrincipalException principalException) {
                User user;
                boolean hasPermission = false;
                if (userIds.length == 0) {
                    hasPermission = true;
                } else if (userIds.length == 1 && (user = this.getUser()).getUserId() == userIds[0]) {
                    int type;
                    Group group = this.groupPersistence.findByPrimaryKey(groupId);
                    if (user.getCompanyId() == group.getCompanyId() && (type = group.getType()) == 1) {
                        hasPermission = true;
                    }
                }
                if (hasPermission) break block6;
                throw new PrincipalException();
            }
        }
        this.userLocalService.addGroupUsers(groupId, userIds);
    }

    public void addOrganizationUsers(long organizationId, long[] userIds) throws PortalException, SystemException {
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"ASSIGN_MEMBERS");
        this.validateOrganizationUsers(userIds);
        this.userLocalService.addOrganizationUsers(organizationId, userIds);
    }

    public void addPasswordPolicyUsers(long passwordPolicyId, long[] userIds) throws PortalException, SystemException {
        PasswordPolicyPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)passwordPolicyId, (String)"ASSIGN_MEMBERS");
        this.userLocalService.addPasswordPolicyUsers(passwordPolicyId, userIds);
    }

    public void addRoleUsers(long roleId, long[] userIds) throws PortalException, SystemException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"ASSIGN_MEMBERS");
        this.userLocalService.addRoleUsers(roleId, userIds);
    }

    public void addTeamUsers(long teamId, long[] userIds) throws PortalException, SystemException {
        TeamPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)teamId, (String)"ASSIGN_MEMBERS");
        this.userLocalService.addTeamUsers(teamId, userIds);
    }

    public User addUser(long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, List<Address> addresses, List<EmailAddress> emailAddresses, List<Phone> phones, List<Website> websites, List<AnnouncementsDelivery> announcementsDelivers, boolean sendEmail, ServiceContext serviceContext) throws PortalException, SystemException {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)false);
            User user = this.addUserWithWorkflow(companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, addresses, emailAddresses, phones, websites, announcementsDelivers, sendEmail, serviceContext);
            return user;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    public User addUser(long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, boolean sendEmail, ServiceContext serviceContext) throws PortalException, SystemException {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)false);
            User user = this.addUserWithWorkflow(companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
            return user;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    public void addUserGroupUsers(long userGroupId, long[] userIds) throws PortalException, SystemException {
        UserGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userGroupId, (String)"ASSIGN_MEMBERS");
        this.userLocalService.addUserGroupUsers(userGroupId, userIds);
    }

    public User addUserWithWorkflow(long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, List<Address> addresses, List<EmailAddress> emailAddresses, List<Phone> phones, List<Website> websites, List<AnnouncementsDelivery> announcementsDelivers, boolean sendEmail, ServiceContext serviceContext) throws PortalException, SystemException {
        boolean indexingEnabled = serviceContext.isIndexingEnabled();
        serviceContext.setIndexingEnabled(false);
        try {
            User user = this.addUserWithWorkflow(companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
            UsersAdminUtil.updateAddresses((String)Contact.class.getName(), (long)user.getContactId(), addresses);
            UsersAdminUtil.updateEmailAddresses((String)Contact.class.getName(), (long)user.getContactId(), emailAddresses);
            UsersAdminUtil.updatePhones((String)Contact.class.getName(), (long)user.getContactId(), phones);
            UsersAdminUtil.updateWebsites((String)Contact.class.getName(), (long)user.getContactId(), websites);
            this.updateAnnouncementsDeliveries(user.getUserId(), announcementsDelivers);
            if (indexingEnabled) {
                Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
                indexer.reindex((Object)user);
            }
            User user2 = user;
            return user2;
        }
        finally {
            serviceContext.setIndexingEnabled(indexingEnabled);
        }
    }

    public User addUserWithWorkflow(long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, boolean sendEmail, ServiceContext serviceContext) throws PortalException, SystemException {
        long creatorUserId = 0L;
        try {
            creatorUserId = this.getUserId();
        }
        catch (PrincipalException principalException) {}
        this.checkAddUserPermission(creatorUserId, companyId, emailAddress, organizationIds, serviceContext);
        return this.userLocalService.addUserWithWorkflow(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
    }

    public void deletePortrait(long userId) throws PortalException, SystemException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"UPDATE");
        this.userLocalService.deletePortrait(userId);
    }

    public void deleteRoleUser(long roleId, long userId) throws PortalException, SystemException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"ASSIGN_MEMBERS");
        this.userLocalService.deleteRoleUser(roleId, userId);
    }

    public void deleteUser(long userId) throws PortalException, SystemException {
        if (this.getUserId() == userId) {
            throw new RequiredUserException();
        }
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"DELETE");
        this.userLocalService.deleteUser(userId);
    }

    public long getDefaultUserId(long companyId) throws PortalException, SystemException {
        return this.userLocalService.getDefaultUserId(companyId);
    }

    public long[] getGroupUserIds(long groupId) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"VIEW_MEMBERS");
        return this.userLocalService.getGroupUserIds(groupId);
    }

    public long[] getOrganizationUserIds(long organizationId) throws PortalException, SystemException {
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"VIEW_MEMBERS");
        return this.userLocalService.getOrganizationUserIds(organizationId);
    }

    public long[] getRoleUserIds(long roleId) throws PortalException, SystemException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"VIEW");
        return this.userLocalService.getRoleUserIds(roleId);
    }

    public User getUserByEmailAddress(long companyId, String emailAddress) throws PortalException, SystemException {
        User user = this.userLocalService.getUserByEmailAddress(companyId, emailAddress);
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)user.getUserId(), (String)"VIEW");
        return user;
    }

    public User getUserById(long userId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)user.getUserId(), (String)"VIEW");
        return user;
    }

    public User getUserByScreenName(long companyId, String screenName) throws PortalException, SystemException {
        User user = this.userLocalService.getUserByScreenName(companyId, screenName);
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)user.getUserId(), (String)"VIEW");
        return user;
    }

    public long getUserIdByEmailAddress(long companyId, String emailAddress) throws PortalException, SystemException {
        User user = this.getUserByEmailAddress(companyId, emailAddress);
        return user.getUserId();
    }

    public long getUserIdByScreenName(long companyId, String screenName) throws PortalException, SystemException {
        User user = this.getUserByScreenName(companyId, screenName);
        return user.getUserId();
    }

    public boolean hasGroupUser(long groupId, long userId) throws SystemException {
        return this.userLocalService.hasGroupUser(groupId, userId);
    }

    public boolean hasRoleUser(long roleId, long userId) throws SystemException {
        return this.userLocalService.hasRoleUser(roleId, userId);
    }

    public boolean hasRoleUser(long companyId, String name, long userId, boolean inherited) throws PortalException, SystemException {
        return this.userLocalService.hasRoleUser(companyId, name, userId, inherited);
    }

    public void setRoleUsers(long roleId, long[] userIds) throws PortalException, SystemException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"ASSIGN_MEMBERS");
        this.userLocalService.setRoleUsers(roleId, userIds);
    }

    public void setUserGroupUsers(long userGroupId, long[] userIds) throws PortalException, SystemException {
        UserGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userGroupId, (String)"ASSIGN_MEMBERS");
        this.userLocalService.setUserGroupUsers(userGroupId, userIds);
    }

    public void unsetGroupUsers(long groupId, long[] userIds, ServiceContext serviceContext) throws PortalException, SystemException {
        block6: {
            try {
                GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ASSIGN_MEMBERS");
            }
            catch (PrincipalException principalException) {
                User user;
                boolean hasPermission = false;
                if (userIds.length == 0) {
                    hasPermission = true;
                } else if (userIds.length == 1 && (user = this.getUser()).getUserId() == userIds[0]) {
                    int type;
                    Group group = this.groupPersistence.findByPrimaryKey(groupId);
                    if (user.getCompanyId() == group.getCompanyId() && ((type = group.getType()) == 1 || type == 2)) {
                        hasPermission = true;
                    }
                }
                if (hasPermission) break block6;
                throw new PrincipalException();
            }
        }
        this.userLocalService.unsetGroupUsers(groupId, userIds, serviceContext);
    }

    public void unsetOrganizationUsers(long organizationId, long[] userIds) throws PortalException, SystemException {
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"ASSIGN_MEMBERS");
        this.userLocalService.unsetOrganizationUsers(organizationId, userIds);
    }

    public void unsetPasswordPolicyUsers(long passwordPolicyId, long[] userIds) throws PortalException, SystemException {
        PasswordPolicyPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)passwordPolicyId, (String)"ASSIGN_MEMBERS");
        this.userLocalService.unsetPasswordPolicyUsers(passwordPolicyId, userIds);
    }

    public void unsetRoleUsers(long roleId, long[] userIds) throws PortalException, SystemException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"ASSIGN_MEMBERS");
        this.userLocalService.unsetRoleUsers(roleId, userIds);
    }

    public void unsetTeamUsers(long teamId, long[] userIds) throws PortalException, SystemException {
        TeamPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)teamId, (String)"ASSIGN_MEMBERS");
        this.userLocalService.unsetTeamUsers(teamId, userIds);
    }

    public void unsetUserGroupUsers(long userGroupId, long[] userIds) throws PortalException, SystemException {
        UserGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userGroupId, (String)"ASSIGN_MEMBERS");
        this.userLocalService.unsetUserGroupUsers(userGroupId, userIds);
    }

    public User updateAgreedToTermsOfUse(long userId, boolean agreedToTermsOfUse) throws PortalException, SystemException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"UPDATE");
        return this.userLocalService.updateAgreedToTermsOfUse(userId, agreedToTermsOfUse);
    }

    public User updateEmailAddress(long userId, String password, String emailAddress1, String emailAddress2, ServiceContext serviceContext) throws PortalException, SystemException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"UPDATE");
        return this.userLocalService.updateEmailAddress(userId, password, emailAddress1, emailAddress2, serviceContext);
    }

    public User updateIncompleteUser(long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, boolean updateUserInformation, boolean sendEmail, ServiceContext serviceContext) throws PortalException, SystemException {
        long creatorUserId = 0L;
        try {
            creatorUserId = this.getUserId();
        }
        catch (PrincipalException principalException) {}
        this.checkAddUserPermission(creatorUserId, companyId, emailAddress, null, serviceContext);
        return this.userLocalService.updateIncompleteUser(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, updateUserInformation, sendEmail, serviceContext);
    }

    public User updateLockoutById(long userId, boolean lockout) throws PortalException, SystemException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"DELETE");
        return this.userLocalService.updateLockoutById(userId, lockout);
    }

    public User updateOpenId(long userId, String openId) throws PortalException, SystemException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"UPDATE");
        return this.userLocalService.updateOpenId(userId, openId);
    }

    public void updateOrganizations(long userId, long[] organizationIds, ServiceContext serviceContext) throws PortalException, SystemException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"UPDATE");
        this.userLocalService.updateOrganizations(userId, organizationIds, serviceContext);
    }

    public User updatePassword(long userId, String password1, String password2, boolean passwordReset) throws PortalException, SystemException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"UPDATE");
        return this.userLocalService.updatePassword(userId, password1, password2, passwordReset);
    }

    public User updatePortrait(long userId, byte[] bytes) throws PortalException, SystemException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"UPDATE");
        return this.userLocalService.updatePortrait(userId, bytes);
    }

    public User updateReminderQuery(long userId, String question, String answer) throws PortalException, SystemException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"UPDATE");
        return this.userLocalService.updateReminderQuery(userId, question, answer);
    }

    public User updateScreenName(long userId, String screenName) throws PortalException, SystemException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"UPDATE");
        return this.userLocalService.updateScreenName(userId, screenName);
    }

    public User updateStatus(long userId, int status) throws PortalException, SystemException {
        if (this.getUserId() == userId && status != 0) {
            throw new RequiredUserException();
        }
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"DELETE");
        return this.userLocalService.updateStatus(userId, status);
    }

    public User updateUser(long userId, String oldPassword, String newPassword1, String newPassword2, boolean passwordReset, String reminderQueryQuestion, String reminderQueryAnswer, String screenName, String emailAddress, long facebookId, String openId, String languageId, String timeZoneId, String greeting, String comments, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String aimSn, String facebookSn, String icqSn, String jabberSn, String msnSn, String mySpaceSn, String skypeSn, String twitterSn, String ymSn, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, List<UserGroupRole> userGroupRoles, long[] userGroupIds, List<Address> addresses, List<EmailAddress> emailAddresses, List<Phone> phones, List<Website> websites, List<AnnouncementsDelivery> announcementsDelivers, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        UsersAdminUtil.updateAddresses((String)Contact.class.getName(), (long)user.getContactId(), addresses);
        UsersAdminUtil.updateEmailAddresses((String)Contact.class.getName(), (long)user.getContactId(), emailAddresses);
        UsersAdminUtil.updatePhones((String)Contact.class.getName(), (long)user.getContactId(), phones);
        UsersAdminUtil.updateWebsites((String)Contact.class.getName(), (long)user.getContactId(), websites);
        this.updateAnnouncementsDeliveries(user.getUserId(), announcementsDelivers);
        user = this.updateUser(userId, oldPassword, newPassword1, newPassword2, passwordReset, reminderQueryQuestion, reminderQueryAnswer, screenName, emailAddress, facebookId, openId, languageId, timeZoneId, greeting, comments, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, smsSn, aimSn, facebookSn, icqSn, jabberSn, msnSn, mySpaceSn, skypeSn, twitterSn, ymSn, jobTitle, groupIds, organizationIds, roleIds, userGroupRoles, userGroupIds, serviceContext);
        return user;
    }

    public User updateUser(long userId, String oldPassword, String newPassword1, String newPassword2, boolean passwordReset, String reminderQueryQuestion, String reminderQueryAnswer, String screenName, String emailAddress, long facebookId, String openId, String languageId, String timeZoneId, String greeting, String comments, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String aimSn, String facebookSn, String icqSn, String jabberSn, String msnSn, String mySpaceSn, String skypeSn, String twitterSn, String ymSn, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, List<UserGroupRole> userGroupRoles, long[] userGroupIds, ServiceContext serviceContext) throws PortalException, SystemException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (long[])organizationIds, (String)"UPDATE");
        long curUserId = this.getUserId();
        if (curUserId == userId) {
            User user = this.userPersistence.findByPrimaryKey(userId);
            if (!(screenName = screenName.trim().toLowerCase()).equalsIgnoreCase(user.getScreenName())) {
                this.validateScreenName(user, screenName);
            }
            if (!(emailAddress = emailAddress.trim().toLowerCase()).equalsIgnoreCase(user.getEmailAddress())) {
                this.validateEmailAddress(user, emailAddress);
            }
        }
        if (groupIds != null) {
            groupIds = this.checkGroups(userId, groupIds);
        }
        if (organizationIds != null) {
            organizationIds = this.checkOrganizations(userId, organizationIds);
        }
        if (roleIds != null) {
            roleIds = this.checkRoles(userId, roleIds);
        }
        if (userGroupRoles != null) {
            userGroupRoles = this.checkUserGroupRoles(userId, userGroupRoles);
        }
        return this.userLocalService.updateUser(userId, oldPassword, newPassword1, newPassword2, passwordReset, reminderQueryQuestion, reminderQueryAnswer, screenName, emailAddress, facebookId, openId, languageId, timeZoneId, greeting, comments, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, smsSn, aimSn, facebookSn, icqSn, jabberSn, msnSn, mySpaceSn, skypeSn, twitterSn, ymSn, jobTitle, groupIds, organizationIds, roleIds, userGroupRoles, userGroupIds, serviceContext);
    }

    protected void checkAddUserPermission(long creatorUserId, long companyId, String emailAddress, long[] organizationIds, ServiceContext serviceContext) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        boolean anonymousUser = GetterUtil.getBoolean((Object)serviceContext.getAttribute("anonymousUser"));
        if (!(creatorUserId == 0L && (company.isStrangers() || anonymousUser) || PortalPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (String)"ADD_USER") || OrganizationPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long[])organizationIds, (String)"ASSIGN_MEMBERS"))) {
            throw new PrincipalException();
        }
        if (creatorUserId == 0L && !company.isStrangersWithMx() && company.hasCompanyMx(emailAddress)) {
            throw new ReservedUserEmailAddressException();
        }
    }

    protected long[] checkGroups(long userId, long[] groupIds) throws PortalException, SystemException {
        List oldGroups = this.groupLocalService.getUserGroups(userId);
        long[] oldGroupIds = new long[oldGroups.size()];
        int i = 0;
        while (i < oldGroups.size()) {
            Group group = (Group)oldGroups.get(i);
            if (!ArrayUtil.contains((long[])groupIds, (long)group.getGroupId()) && !GroupPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)group.getGroupId(), (String)"ASSIGN_MEMBERS")) {
                groupIds = ArrayUtil.append((long[])groupIds, (long)group.getGroupId());
            }
            oldGroupIds[i] = group.getGroupId();
            ++i;
        }
        long[] lArray = groupIds;
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            if (!ArrayUtil.contains((long[])oldGroupIds, (long)groupId)) {
                GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ASSIGN_MEMBERS");
            }
            ++n2;
        }
        return groupIds;
    }

    protected long[] checkOrganizations(long userId, long[] organizationIds) throws PortalException, SystemException {
        List oldOrganizations = this.organizationLocalService.getUserOrganizations(userId);
        long[] oldOrganizationIds = new long[oldOrganizations.size()];
        int i = 0;
        while (i < oldOrganizations.size()) {
            Organization organization = (Organization)oldOrganizations.get(i);
            if (!ArrayUtil.contains((long[])organizationIds, (long)organization.getOrganizationId()) && !OrganizationPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)organization.getOrganizationId(), (String)"ASSIGN_MEMBERS")) {
                organizationIds = ArrayUtil.append((long[])organizationIds, (long)organization.getOrganizationId());
            }
            oldOrganizationIds[i] = organization.getOrganizationId();
            ++i;
        }
        long[] lArray = organizationIds;
        int n = organizationIds.length;
        int n2 = 0;
        while (n2 < n) {
            long organizationId = lArray[n2];
            if (!ArrayUtil.contains((long[])oldOrganizationIds, (long)organizationId)) {
                OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"ASSIGN_MEMBERS");
            }
            ++n2;
        }
        return organizationIds;
    }

    protected long[] checkRoles(long userId, long[] roleIds) throws PrincipalException, SystemException {
        List oldRoles = this.roleLocalService.getUserRoles(userId);
        long[] oldRoleIds = new long[oldRoles.size()];
        int i = 0;
        while (i < oldRoles.size()) {
            Role role = (Role)oldRoles.get(i);
            if (!ArrayUtil.contains((long[])roleIds, (long)role.getRoleId()) && !RolePermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)role.getRoleId(), (String)"ASSIGN_MEMBERS")) {
                roleIds = ArrayUtil.append((long[])roleIds, (long)role.getRoleId());
            }
            oldRoleIds[i] = role.getRoleId();
            ++i;
        }
        long[] lArray = roleIds;
        int n = roleIds.length;
        int n2 = 0;
        while (n2 < n) {
            long roleId = lArray[n2];
            if (!ArrayUtil.contains((long[])oldRoleIds, (long)roleId)) {
                RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"ASSIGN_MEMBERS");
            }
            ++n2;
        }
        return roleIds;
    }

    protected List<UserGroupRole> checkUserGroupRoles(long userId, List<UserGroupRole> userGroupRoles) throws PortalException, SystemException {
        List oldUserGroupRoles = this.userGroupRoleLocalService.getUserGroupRoles(userId);
        for (UserGroupRole oldUserGroupRole : oldUserGroupRoles) {
            if (userGroupRoles.contains(oldUserGroupRole) || UserGroupRolePermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)oldUserGroupRole.getGroupId(), (long)oldUserGroupRole.getRoleId())) continue;
            userGroupRoles.add(oldUserGroupRole);
        }
        for (UserGroupRole userGroupRole : userGroupRoles) {
            if (oldUserGroupRoles.contains(userGroupRole)) continue;
            UserGroupRolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userGroupRole.getGroupId(), (long)userGroupRole.getRoleId());
        }
        return userGroupRoles;
    }

    protected void updateAnnouncementsDeliveries(long userId, List<AnnouncementsDelivery> announcementsDeliveries) throws PortalException, SystemException {
        for (AnnouncementsDelivery announcementsDelivery : announcementsDeliveries) {
            this.announcementsDeliveryService.updateDelivery(userId, announcementsDelivery.getType(), announcementsDelivery.getEmail(), announcementsDelivery.getSms(), announcementsDelivery.getWebsite());
        }
    }

    protected void validateEmailAddress(User user, String emailAddress) throws PortalException, SystemException {
        Company company;
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!UsersAdminUtil.hasUpdateEmailAddress((PermissionChecker)permissionChecker, (User)user)) {
            throw new UserEmailAddressException();
        }
        if (!user.hasCompanyMx() && user.hasCompanyMx(emailAddress) && !(company = this.companyPersistence.findByPrimaryKey(user.getCompanyId())).isStrangersWithMx()) {
            throw new ReservedUserEmailAddressException();
        }
    }

    protected void validateOrganizationUsers(long[] userIds) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!PropsValues.ORGANIZATIONS_ASSIGNMENT_STRICT || permissionChecker.isCompanyAdmin()) {
            return;
        }
        List organizations = this.organizationLocalService.getUserOrganizations(permissionChecker.getUserId());
        long[] lArray = userIds;
        int n = userIds.length;
        int n2 = 0;
        while (n2 < n) {
            long userId = lArray[n2];
            boolean allowed = false;
            for (Organization organization : organizations) {
                boolean manageUsers = OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (Organization)organization, (String)"MANAGE_USERS");
                boolean manageSuborganizations = OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (Organization)organization, (String)"MANAGE_SUBORGANIZATIONS");
                if (!manageUsers && !manageSuborganizations) continue;
                boolean inherited = false;
                boolean includeSpecifiedOrganization = false;
                if (manageUsers && manageSuborganizations) {
                    inherited = true;
                    includeSpecifiedOrganization = true;
                } else if (!manageUsers && manageSuborganizations) {
                    inherited = true;
                    includeSpecifiedOrganization = false;
                }
                if (!this.organizationLocalService.hasUserOrganization(userId, organization.getOrganizationId(), inherited, includeSpecifiedOrganization)) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                throw new PrincipalException();
            }
            ++n2;
        }
    }

    protected void validateScreenName(User user, String screenName) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!UsersAdminUtil.hasUpdateScreenName((PermissionChecker)permissionChecker, (User)user)) {
            throw new UserScreenNameException();
        }
    }
}

