/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Team;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.base.TeamServiceBaseImpl;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.TeamPermissionUtil;
import com.liferay.portal.service.permission.UserPermissionUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamServiceImpl
extends TeamServiceBaseImpl {
    public Team addTeam(long groupId, String name, String description) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_TEAMS");
        return this.teamLocalService.addTeam(this.getUserId(), groupId, name, description);
    }

    public void deleteTeam(long teamId) throws PortalException, SystemException {
        TeamPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)teamId, (String)"DELETE");
        this.teamLocalService.deleteTeam(teamId);
    }

    public List<Team> getGroupTeams(long groupId) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_TEAMS");
        return this.teamLocalService.getGroupTeams(groupId);
    }

    public Team getTeam(long teamId) throws PortalException, SystemException {
        TeamPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)teamId, (String)"VIEW");
        return this.teamLocalService.getTeam(teamId);
    }

    public Team getTeam(long groupId, String name) throws PortalException, SystemException {
        Team team = this.teamLocalService.getTeam(groupId, name);
        TeamPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Team)team, (String)"VIEW");
        return team;
    }

    public List<Team> getUserTeams(long userId) throws PortalException, SystemException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"UPDATE");
        return this.teamLocalService.getUserTeams(userId);
    }

    public List<Team> getUserTeams(long userId, long groupId) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_TEAMS");
        return this.teamLocalService.getUserTeams(userId, groupId);
    }

    public boolean hasUserTeam(long userId, long teamId) throws PortalException, SystemException {
        Team team;
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)(team = this.teamPersistence.findByPrimaryKey(teamId)).getGroupId(), (String)"MANAGE_TEAMS") && !UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)userId, (String)"UPDATE")) {
            throw new PrincipalException();
        }
        return this.userPersistence.containsTeam(userId, teamId);
    }

    public Team updateTeam(long teamId, String name, String description) throws PortalException, SystemException {
        TeamPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)teamId, (String)"UPDATE");
        return this.teamLocalService.updateTeam(teamId, name, description);
    }
}

