/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Subscription;
import com.liferay.portal.model.User;
import com.liferay.portal.service.base.SubscriptionLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionLocalServiceImpl
extends SubscriptionLocalServiceBaseImpl {
    public Subscription addSubscription(long userId, long groupId, String className, long classPK) throws PortalException, SystemException {
        return this.addSubscription(userId, groupId, className, classPK, "instant");
    }

    public Subscription addSubscription(long userId, long groupId, String className, long classPK, String frequency) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        Date now = new Date();
        long subscriptionId = this.counterLocalService.increment();
        Subscription subscription = this.subscriptionPersistence.fetchByC_U_C_C(user.getCompanyId(), userId, classNameId, classPK);
        if (subscription == null) {
            subscription = this.subscriptionPersistence.create(subscriptionId);
            subscription.setCompanyId(user.getCompanyId());
            subscription.setUserId(user.getUserId());
            subscription.setUserName(user.getFullName());
            subscription.setCreateDate(now);
            subscription.setModifiedDate(now);
            subscription.setClassNameId(classNameId);
            subscription.setClassPK(classPK);
            subscription.setFrequency(frequency);
            this.subscriptionPersistence.update((BaseModel)subscription, false);
        }
        if (groupId > 0L) {
            try {
                this.assetEntryLocalService.getEntry(className, classPK);
            }
            catch (Exception exception) {
                this.assetEntryLocalService.updateEntry(userId, groupId, className, classPK, null, 0L, null, null, false, null, null, null, null, null, String.valueOf(groupId), null, null, null, null, 0, 0, null, false);
            }
            if (className.equals(MBThread.class.getName())) {
                MBThread mbThread = this.mbThreadLocalService.getMBThread(classPK);
                JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
                extraDataJSONObject.put("threadId", classPK);
                this.socialActivityLocalService.addActivity(userId, groupId, MBMessage.class.getName(), mbThread.getRootMessageId(), 10002, extraDataJSONObject.toString(), 0L);
            } else {
                this.socialActivityLocalService.addActivity(userId, groupId, className, classPK, 10002, "", 0L);
            }
        }
        return subscription;
    }

    @Override
    public void deleteSubscription(long subscriptionId) throws PortalException, SystemException {
        Subscription subscription = this.subscriptionPersistence.fetchByPrimaryKey(subscriptionId);
        this.deleteSubscription(subscription);
    }

    public void deleteSubscription(long userId, String className, long classPK) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        Subscription subscription = this.subscriptionPersistence.findByC_U_C_C(user.getCompanyId(), userId, classNameId, classPK);
        this.deleteSubscription(subscription);
    }

    @Override
    public void deleteSubscription(Subscription subscription) throws PortalException, SystemException {
        this.subscriptionPersistence.remove((BaseModel)subscription);
        AssetEntry assetEntry = this.assetEntryPersistence.fetchByC_C(subscription.getClassNameId(), subscription.getClassPK());
        if (assetEntry != null) {
            String className = PortalUtil.getClassName((long)subscription.getClassNameId());
            this.socialActivityLocalService.addActivity(subscription.getUserId(), assetEntry.getGroupId(), className, subscription.getClassPK(), 10003, "", 0L);
        }
    }

    public void deleteSubscriptions(long userId) throws PortalException, SystemException {
        List subscriptions = this.subscriptionPersistence.findByUserId(userId);
        for (Subscription subscription : subscriptions) {
            this.deleteSubscription(subscription);
        }
    }

    public void deleteSubscriptions(long companyId, String className, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        List subscriptions = this.subscriptionPersistence.findByC_C_C(companyId, classNameId, classPK);
        for (Subscription subscription : subscriptions) {
            this.deleteSubscription(subscription);
        }
    }

    public Subscription getSubscription(long companyId, long userId, String className, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.subscriptionPersistence.findByC_U_C_C(companyId, userId, classNameId, classPK);
    }

    public List<Subscription> getSubscriptions(long companyId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.subscriptionPersistence.findByC_C_C(companyId, classNameId, classPK);
    }

    public List<Subscription> getUserSubscriptions(long userId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.subscriptionPersistence.findByUserId(userId, start, end, orderByComparator);
    }

    public List<Subscription> getUserSubscriptions(long userId, String className) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.subscriptionPersistence.findByU_C(userId, classNameId);
    }

    public int getUserSubscriptionsCount(long userId) throws SystemException {
        return this.subscriptionPersistence.countByUserId(userId);
    }

    public boolean isSubscribed(long companyId, long userId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        Subscription subscription = this.subscriptionPersistence.fetchByC_U_C_C(companyId, userId, classNameId, classPK);
        return subscription != null;
    }
}

