/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.ResourceBlockPermission;
import com.liferay.portal.model.ResourceBlockPermissionsContainer;
import com.liferay.portal.service.base.ResourceBlockPermissionLocalServiceBaseImpl;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

public class ResourceBlockPermissionLocalServiceImpl
extends ResourceBlockPermissionLocalServiceBaseImpl {
    public void addResourceBlockPermissions(long resourceBlockId, ResourceBlockPermissionsContainer resourceBlockPermissionsContainer) throws SystemException {
        SortedMap permissions = resourceBlockPermissionsContainer.getPermissions();
        for (Map.Entry permission : permissions.entrySet()) {
            long resourceBlockPermissionId = this.counterLocalService.increment();
            ResourceBlockPermission resourceBlockPermission = this.resourceBlockPermissionPersistence.create(resourceBlockPermissionId);
            resourceBlockPermission.setResourceBlockId(resourceBlockId);
            resourceBlockPermission.setRoleId(((Long)permission.getKey()).longValue());
            resourceBlockPermission.setActionIds(((Long)permission.getValue()).longValue());
            this.updateResourceBlockPermission(resourceBlockPermission);
        }
    }

    public void deleteResourceBlockPermissions(long resourceBlockId) throws SystemException {
        this.resourceBlockPermissionPersistence.removeByResourceBlockId(resourceBlockId);
    }

    public ResourceBlockPermissionsContainer getResourceBlockPermissionsContainer(long resourceBlockId) throws SystemException {
        List resourceBlockPermissions = this.resourceBlockPermissionPersistence.findByResourceBlockId(resourceBlockId);
        ResourceBlockPermissionsContainer resourceBlockPermissionContainer = new ResourceBlockPermissionsContainer();
        for (ResourceBlockPermission resourceBlockPermission : resourceBlockPermissions) {
            resourceBlockPermissionContainer.setPermissions(resourceBlockPermission.getRoleId(), resourceBlockPermission.getActionIds());
        }
        return resourceBlockPermissionContainer;
    }

    public void updateResourceBlockPermission(long resourceBlockId, long roleId, long actionIdsLong, int operator) throws SystemException {
        ResourceBlockPermission resourceBlockPermission = this.resourceBlockPermissionPersistence.fetchByR_R(resourceBlockId, roleId);
        if (resourceBlockPermission == null) {
            if (actionIdsLong == 0L) {
                return;
            }
            long resourceBlockPermissionId = this.counterLocalService.increment();
            resourceBlockPermission = this.resourceBlockPermissionPersistence.create(resourceBlockPermissionId);
            resourceBlockPermission.setResourceBlockId(resourceBlockId);
            resourceBlockPermission.setRoleId(roleId);
        }
        if (operator == 1) {
            actionIdsLong |= resourceBlockPermission.getActionIds();
        } else if (operator == 2) {
            actionIdsLong = resourceBlockPermission.getActionIds() & (actionIdsLong ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (actionIdsLong == 0L) {
            this.deleteResourceBlockPermission(resourceBlockPermission);
        } else {
            resourceBlockPermission.setActionIds(actionIdsLong);
            this.updateResourceBlockPermission(resourceBlockPermission);
        }
    }
}

