/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchResourceBlockException;
import com.liferay.portal.ResourceBlocksNotSupportedException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.model.AuditedModel;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.GroupedModel;
import com.liferay.portal.model.PermissionedModel;
import com.liferay.portal.model.PersistedModel;
import com.liferay.portal.model.ResourceAction;
import com.liferay.portal.model.ResourceBlock;
import com.liferay.portal.model.ResourceBlockPermissionsContainer;
import com.liferay.portal.model.ResourceTypePermission;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.security.permission.ResourceBlockIdsBag;
import com.liferay.portal.service.PersistedModelLocalService;
import com.liferay.portal.service.PersistedModelLocalServiceRegistryUtil;
import com.liferay.portal.service.base.ResourceBlockLocalServiceBaseImpl;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBlockLocalServiceImpl
extends ResourceBlockLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(ResourceBlockLocalServiceImpl.class);

    public void addCompanyScopePermission(long companyId, String name, long roleId, String actionId) throws PortalException, SystemException {
        this.updateCompanyScopePermissions(companyId, name, roleId, this.getActionId(name, actionId), 1);
    }

    public void addCompanyScopePermissions(long companyId, String name, long roleId, long actionIdsLong) throws SystemException {
        this.updateCompanyScopePermissions(companyId, name, roleId, actionIdsLong, 1);
    }

    public void addGroupScopePermission(long companyId, long groupId, String name, long roleId, String actionId) throws PortalException, SystemException {
        this.updateGroupScopePermissions(companyId, groupId, name, roleId, this.getActionId(name, actionId), 1);
    }

    public void addGroupScopePermissions(long companyId, long groupId, String name, long roleId, long actionIdsLong) throws SystemException {
        this.updateGroupScopePermissions(companyId, groupId, name, roleId, actionIdsLong, 1);
    }

    public void addIndividualScopePermission(long companyId, long groupId, String name, long primKey, long roleId, String actionId) throws PortalException, SystemException {
        PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, this.getActionId(name, actionId), 1);
    }

    public void addIndividualScopePermission(long companyId, long groupId, String name, PermissionedModel permissionedModel, long roleId, String actionId) throws PortalException, SystemException {
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, this.getActionId(name, actionId), 1);
    }

    public void addIndividualScopePermissions(long companyId, long groupId, String name, long primKey, long roleId, long actionIdsLong) throws PortalException, SystemException {
        PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, actionIdsLong, 1);
    }

    public void addIndividualScopePermissions(long companyId, long groupId, String name, PermissionedModel permissionedModel, long roleId, long actionIdsLong) throws SystemException {
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, actionIdsLong, 1);
    }

    public ResourceBlock addResourceBlock(long companyId, long groupId, String name, String permissionsHash, ResourceBlockPermissionsContainer resourceBlockPermissionsContainer) throws SystemException {
        long resourceBlockId = this.counterLocalService.increment(ResourceBlock.class.getName());
        ResourceBlock resourceBlock = this.resourceBlockPersistence.create(resourceBlockId);
        resourceBlock.setCompanyId(companyId);
        resourceBlock.setGroupId(groupId);
        resourceBlock.setName(name);
        resourceBlock.setPermissionsHash(permissionsHash);
        resourceBlock.setReferenceCount(1L);
        this.updateResourceBlock(resourceBlock);
        this.resourceBlockPermissionLocalService.addResourceBlockPermissions(resourceBlockId, resourceBlockPermissionsContainer);
        return resourceBlock;
    }

    @Override
    public void deleteResourceBlock(long resourceBlockId) throws PortalException, SystemException {
        ResourceBlock resourceBlock = this.resourceBlockPersistence.findByPrimaryKey(resourceBlockId);
        this.deleteResourceBlock(resourceBlock);
    }

    @Override
    public void deleteResourceBlock(ResourceBlock resourceBlock) throws SystemException {
        this.resourceBlockPermissionLocalService.deleteResourceBlockPermissions(resourceBlock.getPrimaryKey());
        this.resourceBlockPersistence.remove((BaseModel)resourceBlock);
    }

    public long getActionId(String name, String actionId) throws PortalException {
        ResourceAction resourcAction = this.resourceActionLocalService.getResourceAction(name, actionId);
        return resourcAction.getBitwiseValue();
    }

    public long getActionIds(String name, List<String> actionIds) throws PortalException {
        long actionIdsLong = 0L;
        for (String actionId : actionIds) {
            ResourceAction resourceAction = this.resourceActionLocalService.getResourceAction(name, actionId);
            actionIdsLong |= resourceAction.getBitwiseValue();
        }
        return actionIdsLong;
    }

    public List<String> getActionIds(String name, long actionIdsLong) throws SystemException {
        List resourceActions = this.resourceActionLocalService.getResourceActions(name);
        ArrayList<String> actionIds = new ArrayList<String>();
        for (ResourceAction resourceAction : resourceActions) {
            if ((actionIdsLong & resourceAction.getBitwiseValue()) != resourceAction.getBitwiseValue()) continue;
            actionIds.add(resourceAction.getActionId());
        }
        return actionIds;
    }

    public List<String> getCompanyScopePermissions(ResourceBlock resourceBlock, long roleId) throws SystemException {
        long actionIdsLong = this.resourceTypePermissionLocalService.getCompanyScopeActionIds(resourceBlock.getCompanyId(), resourceBlock.getName(), roleId);
        return this.getActionIds(resourceBlock.getName(), actionIdsLong);
    }

    public List<String> getGroupScopePermissions(ResourceBlock resourceBlock, long roleId) throws SystemException {
        long actionIdsLong = this.resourceTypePermissionLocalService.getGroupScopeActionIds(resourceBlock.getCompanyId(), resourceBlock.getGroupId(), resourceBlock.getName(), roleId);
        return this.getActionIds(resourceBlock.getName(), actionIdsLong);
    }

    public PermissionedModel getPermissionedModel(String name, long primKey) throws PortalException, SystemException {
        PersistedModelLocalService persistedModelLocalService = PersistedModelLocalServiceRegistryUtil.getPersistedModelLocalService((String)name);
        if (persistedModelLocalService == null) {
            throw new ResourceBlocksNotSupportedException();
        }
        PersistedModel persistedModel = persistedModelLocalService.getPersistedModel((Serializable)Long.valueOf(primKey));
        try {
            return (PermissionedModel)persistedModel;
        }
        catch (ClassCastException classCastException) {
            throw new ResourceBlocksNotSupportedException();
        }
    }

    public List<String> getPermissions(ResourceBlock resourceBlock, long roleId) throws SystemException {
        ResourceBlockPermissionsContainer resourceBlockPermissionsContainer = this.resourceBlockPermissionLocalService.getResourceBlockPermissionsContainer(resourceBlock.getPrimaryKey());
        long actionIdsLong = resourceBlockPermissionsContainer.getActionIds(roleId);
        return this.getActionIds(resourceBlock.getName(), actionIdsLong);
    }

    public String getPermissionsHash(ResourceBlockPermissionsContainer resourceBlockPermissionsContainer) {
        SortedMap permissions = resourceBlockPermissionsContainer.getPermissions();
        ByteBuffer byteBuffer = ByteBuffer.allocate(permissions.size() * 16);
        for (Map.Entry entry : permissions.entrySet()) {
            byteBuffer.putLong((Long)entry.getKey());
            byteBuffer.putLong((Long)entry.getValue());
        }
        byteBuffer.flip();
        return DigesterUtil.digestHex((String)"SHA-1", (ByteBuffer)byteBuffer);
    }

    public ResourceBlock getResourceBlock(String name, long primKey) throws PortalException, SystemException {
        PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
        return this.getResourceBlock(permissionedModel.getResourceBlockId());
    }

    public List<Long> getResourceBlockIds(ResourceBlockIdsBag resourceBlockIdsBag, String name, String actionId) throws PortalException {
        long actionIdsLong = this.getActionId(name, actionId);
        return resourceBlockIdsBag.getResourceBlockIds(actionIdsLong);
    }

    public ResourceBlockIdsBag getResourceBlockIdsBag(long companyId, long groupId, String name, long[] roleIds) throws SystemException {
        return this.resourceBlockFinder.findByC_G_N_R(companyId, groupId, name, roleIds);
    }

    public boolean hasPermission(String name, long primKey, String actionId, ResourceBlockIdsBag resourceBlockIdsBag) throws PortalException, SystemException {
        PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
        return this.hasPermission(name, permissionedModel, actionId, resourceBlockIdsBag);
    }

    public boolean hasPermission(String name, PermissionedModel permissionedModel, String actionId, ResourceBlockIdsBag resourceBlockIdsBag) throws PortalException {
        long actionIdsLong = this.getActionId(name, actionId);
        return resourceBlockIdsBag.hasResourceBlockId(permissionedModel.getResourceBlockId(), actionIdsLong);
    }

    public boolean isSupported(String name) {
        return PersistedModelLocalServiceRegistryUtil.isPermissionedModelLocalService((String)name);
    }

    public void releasePermissionedModelResourceBlock(PermissionedModel permissionedModel) throws PortalException, SystemException {
        block2: {
            try {
                this.releaseResourceBlock(permissionedModel.getResourceBlockId());
            }
            catch (NoSuchResourceBlockException noSuchResourceBlockException) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Resource block " + permissionedModel.getResourceBlockId() + " missing"));
            }
        }
    }

    public void releasePermissionedModelResourceBlock(String name, long primKey) throws PortalException, SystemException {
        PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
        this.releasePermissionedModelResourceBlock(permissionedModel);
    }

    public void releaseResourceBlock(long resourceBlockId) throws PortalException, SystemException {
        ResourceBlock resourceBlock = this.getResourceBlock(resourceBlockId);
        this.releaseResourceBlock(resourceBlock);
    }

    public void releaseResourceBlock(ResourceBlock resourceBlock) throws SystemException {
        long referenceCount = resourceBlock.getReferenceCount() - 1L;
        if (referenceCount <= 0L) {
            this.deleteResourceBlock(resourceBlock);
            return;
        }
        resourceBlock.setReferenceCount(referenceCount);
        this.updateResourceBlock(resourceBlock);
    }

    public void removeAllGroupScopePermissions(long companyId, String name, long roleId, long actionIdsLong) throws SystemException {
        List resourceTypePermissions = this.resourceTypePermissionLocalService.getGroupScopeResourceTypePermissions(companyId, name, roleId);
        for (ResourceTypePermission resourceTypePermission : resourceTypePermissions) {
            this.removeGroupScopePermissions(companyId, resourceTypePermission.getGroupId(), name, roleId, actionIdsLong);
        }
    }

    public void removeAllGroupScopePermissions(long companyId, String name, long roleId, String actionId) throws PortalException, SystemException {
        this.removeAllGroupScopePermissions(companyId, name, roleId, this.getActionId(name, actionId));
    }

    public void removeCompanyScopePermission(long companyId, String name, long roleId, String actionId) throws PortalException, SystemException {
        this.updateCompanyScopePermissions(companyId, name, roleId, this.getActionId(name, actionId), 2);
    }

    public void removeCompanyScopePermissions(long companyId, String name, long roleId, long actionIdsLong) throws SystemException {
        this.updateCompanyScopePermissions(companyId, name, roleId, actionIdsLong, 2);
    }

    public void removeGroupScopePermission(long companyId, long groupId, String name, long roleId, String actionId) throws PortalException, SystemException {
        this.updateGroupScopePermissions(companyId, groupId, name, roleId, this.getActionId(name, actionId), 2);
    }

    public void removeGroupScopePermissions(long companyId, long groupId, String name, long roleId, long actionIdsLong) throws SystemException {
        this.updateGroupScopePermissions(companyId, groupId, name, roleId, actionIdsLong, 2);
    }

    public void removeIndividualScopePermission(long companyId, long groupId, String name, long primKey, long roleId, String actionId) throws PortalException, SystemException {
        PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, this.getActionId(name, actionId), 2);
    }

    public void removeIndividualScopePermission(long companyId, long groupId, String name, PermissionedModel permissionedModel, long roleId, String actionId) throws PortalException, SystemException {
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, this.getActionId(name, actionId), 2);
    }

    public void removeIndividualScopePermissions(long companyId, long groupId, String name, long primKey, long roleId, long actionIdsLong) throws PortalException, SystemException {
        PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, actionIdsLong, 2);
    }

    public void removeIndividualScopePermissions(long companyId, long groupId, String name, PermissionedModel permissionedModel, long roleId, long actionIdsLong) throws SystemException {
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, actionIdsLong, 2);
    }

    public void retainResourceBlock(long resourceBlockId) throws PortalException, SystemException {
        ResourceBlock resourceBlock = this.getResourceBlock(resourceBlockId);
        this.retainResourceBlock(resourceBlock);
    }

    public void retainResourceBlock(ResourceBlock resourceBlock) throws SystemException {
        resourceBlock.setReferenceCount(resourceBlock.getReferenceCount() + 1L);
        this.updateResourceBlock(resourceBlock);
    }

    public void setCompanyScopePermissions(long companyId, String name, long roleId, List<String> actionIds) throws PortalException, SystemException {
        this.updateCompanyScopePermissions(companyId, name, roleId, this.getActionIds(name, actionIds), 3);
    }

    public void setCompanyScopePermissions(long companyId, String name, long roleId, long actionIdsLong) throws SystemException {
        this.updateCompanyScopePermissions(companyId, name, roleId, actionIdsLong, 3);
    }

    public void setGroupScopePermissions(long companyId, long groupId, String name, long roleId, List<String> actionIds) throws PortalException, SystemException {
        this.updateGroupScopePermissions(companyId, groupId, name, roleId, this.getActionIds(name, actionIds), 3);
    }

    public void setGroupScopePermissions(long companyId, long groupId, String name, long roleId, long actionIdsLong) throws SystemException {
        this.updateGroupScopePermissions(companyId, groupId, name, roleId, actionIdsLong, 3);
    }

    public void setIndividualScopePermissions(long companyId, long groupId, String name, long primKey, long roleId, List<String> actionIds) throws PortalException, SystemException {
        PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, this.getActionIds(name, actionIds), 3);
    }

    public void setIndividualScopePermissions(long companyId, long groupId, String name, long primKey, long roleId, long actionIdsLong) throws PortalException, SystemException {
        PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, actionIdsLong, 3);
    }

    public void setIndividualScopePermissions(long companyId, long groupId, String name, long primKey, Map<Long, String[]> roleIdsToActionIds) throws PortalException, SystemException {
        boolean flushEnabled = PermissionThreadLocal.isFlushEnabled();
        PermissionThreadLocal.setIndexEnabled((boolean)false);
        try {
            PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
            for (Map.Entry<Long, String[]> entry : roleIdsToActionIds.entrySet()) {
                long roleId = entry.getKey();
                Object[] actionIds = entry.getValue();
                this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, this.getActionIds(name, ListUtil.fromArray((Object[])actionIds)), 3);
            }
        }
        finally {
            PermissionThreadLocal.setIndexEnabled((boolean)flushEnabled);
            PermissionCacheUtil.clearCache();
        }
    }

    public void setIndividualScopePermissions(long companyId, long groupId, String name, PermissionedModel permissionedModel, long roleId, List<String> actionIds) throws PortalException, SystemException {
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, this.getActionIds(name, actionIds), 3);
    }

    public void setIndividualScopePermissions(long companyId, long groupId, String name, PermissionedModel permissionedModel, long roleId, long actionIdsLong) throws SystemException {
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, actionIdsLong, 3);
    }

    public void updateCompanyScopePermissions(long companyId, String name, long roleId, long actionIdsLong, int operator) throws SystemException {
        this.resourceTypePermissionLocalService.updateCompanyScopeResourceTypePermissions(companyId, name, roleId, actionIdsLong, (long)operator);
        List resourceBlocks = this.resourceBlockPersistence.findByC_N(companyId, name);
        this.updatePermissions(resourceBlocks, roleId, actionIdsLong, operator);
        PermissionCacheUtil.clearCache();
    }

    public void updateGroupScopePermissions(long companyId, long groupId, String name, long roleId, long actionIdsLong, int operator) throws SystemException {
        this.resourceTypePermissionLocalService.updateGroupScopeResourceTypePermissions(companyId, groupId, name, roleId, actionIdsLong, (long)operator);
        List resourceBlocks = this.resourceBlockPersistence.findByC_G_N(companyId, groupId, name);
        this.updatePermissions(resourceBlocks, roleId, actionIdsLong, operator);
        PermissionCacheUtil.clearCache();
    }

    public void updateIndividualScopePermissions(long companyId, long groupId, String name, PermissionedModel permissionedModel, long roleId, long actionIdsLong, int operator) throws SystemException {
        ResourceBlock resourceBlock = this.resourceBlockPersistence.fetchByPrimaryKey(permissionedModel.getResourceBlockId());
        ResourceBlockPermissionsContainer resourceBlockPermissionsContainer = null;
        resourceBlockPermissionsContainer = resourceBlock == null ? this.resourceTypePermissionLocalService.getResourceBlockPermissionsContainer(companyId, groupId, name) : this.resourceBlockPermissionLocalService.getResourceBlockPermissionsContainer(resourceBlock.getPrimaryKey());
        long oldActionIdsLong = resourceBlockPermissionsContainer.getActionIds(roleId);
        if (operator == 1) {
            actionIdsLong |= oldActionIdsLong;
        } else if (operator == 2) {
            actionIdsLong = oldActionIdsLong & (actionIdsLong ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (resourceBlock != null) {
            if (oldActionIdsLong == actionIdsLong) {
                return;
            }
            this.releaseResourceBlock(resourceBlock);
        }
        resourceBlockPermissionsContainer.setPermissions(roleId, actionIdsLong);
        String permissionsHash = this.getPermissionsHash(resourceBlockPermissionsContainer);
        this.updateResourceBlockId(companyId, groupId, name, permissionedModel, permissionsHash, resourceBlockPermissionsContainer);
        PermissionCacheUtil.clearCache();
    }

    public ResourceBlock updateResourceBlockId(long companyId, long groupId, String name, PermissionedModel permissionedModel, String permissionsHash, ResourceBlockPermissionsContainer resourceBlockPermissionsContainer) throws SystemException {
        ResourceBlock resourceBlock = this.resourceBlockPersistence.fetchByC_G_N_P(companyId, groupId, name, permissionsHash);
        if (resourceBlock == null) {
            resourceBlock = this.addResourceBlock(companyId, groupId, name, permissionsHash, resourceBlockPermissionsContainer);
        } else {
            this.retainResourceBlock(resourceBlock);
        }
        permissionedModel.setResourceBlockId(resourceBlock.getResourceBlockId());
        permissionedModel.persist();
        return resourceBlock;
    }

    public void verifyResourceBlockId(long companyId, String name, long primKey) throws PortalException, SystemException {
        PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
        ResourceBlock resourceBlock = this.resourceBlockPersistence.fetchByPrimaryKey(permissionedModel.getResourceBlockId());
        if (resourceBlock == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Resource block " + permissionedModel.getResourceBlockId() + " missing for " + name + "#" + primKey));
            }
            long groupId = 0L;
            long ownerId = 0L;
            if (permissionedModel instanceof GroupedModel) {
                GroupedModel groupedModel = (GroupedModel)permissionedModel;
                groupId = groupedModel.getGroupId();
                ownerId = groupedModel.getUserId();
            } else if (permissionedModel instanceof AuditedModel) {
                AuditedModel auditedModel = (AuditedModel)permissionedModel;
                ownerId = auditedModel.getUserId();
            }
            this.resourceLocalService.addResources(companyId, groupId, ownerId, name, primKey, false, true, true);
        }
    }

    protected void updatePermissions(List<ResourceBlock> resourceBlocks, long roleId, long actionIdsLong, int operator) throws SystemException {
        for (ResourceBlock resourceBlock : resourceBlocks) {
            this.resourceBlockPermissionLocalService.updateResourceBlockPermission(resourceBlock.getPrimaryKey(), roleId, actionIdsLong, operator);
            this.updatePermissionsHash(resourceBlock);
        }
    }

    protected void updatePermissionsHash(ResourceBlock resourceBlock) throws SystemException {
        ResourceBlockPermissionsContainer resourceBlockPermissionsContainer = this.resourceBlockPermissionLocalService.getResourceBlockPermissionsContainer(resourceBlock.getPrimaryKey());
        String permissionsHash = this.getPermissionsHash(resourceBlockPermissionsContainer);
        resourceBlock.setPermissionsHash(permissionsHash);
        this.updateResourceBlock(resourceBlock);
    }
}

