/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.RegionCodeException;
import com.liferay.portal.RegionNameException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Region;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.base.RegionServiceBaseImpl;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionServiceImpl
extends RegionServiceBaseImpl {
    public Region addRegion(long countryId, String regionCode, String name, boolean active) throws PortalException, SystemException {
        if (!this.getPermissionChecker().isOmniadmin()) {
            throw new PrincipalException();
        }
        this.countryPersistence.findByPrimaryKey(countryId);
        if (Validator.isNull((String)regionCode)) {
            throw new RegionCodeException();
        }
        if (Validator.isNull((String)name)) {
            throw new RegionNameException();
        }
        long regionId = this.counterLocalService.increment();
        Region region = this.regionPersistence.create(regionId);
        region.setCountryId(countryId);
        region.setRegionCode(regionCode);
        region.setName(name);
        region.setActive(active);
        this.regionPersistence.update((BaseModel)region, false);
        return region;
    }

    public Region getRegion(long regionId) throws PortalException, SystemException {
        return this.regionPersistence.findByPrimaryKey(regionId);
    }

    public List<Region> getRegions() throws SystemException {
        return this.regionPersistence.findAll();
    }

    public List<Region> getRegions(long countryId) throws SystemException {
        return this.regionPersistence.findByCountryId(countryId);
    }

    public List<Region> getRegions(boolean active) throws SystemException {
        return this.regionPersistence.findByActive(active);
    }

    public List<Region> getRegions(long countryId, boolean active) throws SystemException {
        return this.regionPersistence.findByC_A(countryId, active);
    }
}

