/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portlet.BasePreferencesImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletPreferencesLocalUtil {
    public static final String _CACHE_NAME = PortletPreferencesLocalUtil.class.getName();
    private static PortalCache _portalCache = MultiVMPoolUtil.getCache((String)_CACHE_NAME);

    public static Map<Serializable, BasePreferencesImpl> getPreferencesPool(long ownerId, int ownerType) {
        PreferencesPoolKey key = new PreferencesPoolKey(ownerId, ownerType);
        HashMap preferencesPool = (HashMap)_portalCache.get((Serializable)key);
        if (preferencesPool == null) {
            preferencesPool = new HashMap();
            _portalCache.put((Serializable)key, preferencesPool);
        }
        return preferencesPool;
    }

    protected static void clearPreferencesPool() {
        _portalCache.removeAll();
    }

    protected static void clearPreferencesPool(long ownerId, int ownerType) {
        PreferencesPoolKey key = new PreferencesPoolKey(ownerId, ownerType);
        _portalCache.remove((Serializable)key);
    }

    private static class PreferencesPoolKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long _ownerId;
        private final int _ownerType;

        public PreferencesPoolKey(long ownerId, int ownerType) {
            this._ownerId = ownerId;
            this._ownerType = ownerType;
        }

        public boolean equals(Object obj) {
            PreferencesPoolKey preferencesPoolKey = (PreferencesPoolKey)obj;
            return preferencesPoolKey._ownerId == this._ownerId && preferencesPoolKey._ownerType == this._ownerType;
        }

        public int hashCode() {
            return (int)(this._ownerId * 11L + (long)this._ownerType);
        }
    }
}

