/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.PhoneNumberException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.User;
import com.liferay.portal.service.base.PhoneLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.format.PhoneNumberUtil;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhoneLocalServiceImpl
extends PhoneLocalServiceBaseImpl {
    public Phone addPhone(long userId, String className, long classPK, String number, String extension, int typeId, boolean primary) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        Date now = new Date();
        number = PhoneNumberUtil.strip((String)number);
        extension = PhoneNumberUtil.strip((String)extension);
        this.validate(0L, user.getCompanyId(), classNameId, classPK, number, typeId, primary);
        long phoneId = this.counterLocalService.increment();
        Phone phone = this.phonePersistence.create(phoneId);
        phone.setCompanyId(user.getCompanyId());
        phone.setUserId(user.getUserId());
        phone.setUserName(user.getFullName());
        phone.setCreateDate(now);
        phone.setModifiedDate(now);
        phone.setClassNameId(classNameId);
        phone.setClassPK(classPK);
        phone.setNumber(number);
        phone.setExtension(extension);
        phone.setTypeId(typeId);
        phone.setPrimary(primary);
        this.phonePersistence.update((BaseModel)phone, false);
        return phone;
    }

    @Override
    public void deletePhone(long phoneId) throws PortalException, SystemException {
        Phone phone = this.phonePersistence.findByPrimaryKey(phoneId);
        this.deletePhone(phone);
    }

    @Override
    public void deletePhone(Phone phone) throws SystemException {
        this.phonePersistence.remove((BaseModel)phone);
    }

    public void deletePhones(long companyId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        List phones = this.phonePersistence.findByC_C_C(companyId, classNameId, classPK);
        for (Phone phone : phones) {
            this.deletePhone(phone);
        }
    }

    @Override
    public Phone getPhone(long phoneId) throws PortalException, SystemException {
        return this.phonePersistence.findByPrimaryKey(phoneId);
    }

    public List<Phone> getPhones() throws SystemException {
        return this.phonePersistence.findAll();
    }

    public List<Phone> getPhones(long companyId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.phonePersistence.findByC_C_C(companyId, classNameId, classPK);
    }

    public Phone updatePhone(long phoneId, String number, String extension, int typeId, boolean primary) throws PortalException, SystemException {
        number = PhoneNumberUtil.strip((String)number);
        extension = PhoneNumberUtil.strip((String)extension);
        this.validate(phoneId, 0L, 0L, 0L, number, typeId, primary);
        Phone phone = this.phonePersistence.findByPrimaryKey(phoneId);
        phone.setModifiedDate(new Date());
        phone.setNumber(number);
        phone.setExtension(extension);
        phone.setTypeId(typeId);
        phone.setPrimary(primary);
        this.phonePersistence.update((BaseModel)phone, false);
        return phone;
    }

    protected void validate(long phoneId, long companyId, long classNameId, long classPK, String number, int typeId, boolean primary) throws PortalException, SystemException {
        if (Validator.isNull((String)number)) {
            throw new PhoneNumberException();
        }
        if (phoneId > 0L) {
            Phone phone = this.phonePersistence.findByPrimaryKey(phoneId);
            companyId = phone.getCompanyId();
            classNameId = phone.getClassNameId();
            classPK = phone.getClassPK();
        }
        if (classNameId == PortalUtil.getClassNameId(Account.class) || classNameId == PortalUtil.getClassNameId(Contact.class) || classNameId == PortalUtil.getClassNameId(Organization.class)) {
            this.listTypeService.validate(typeId, classNameId, ".phone");
        }
        this.validate(phoneId, companyId, classNameId, classPK, primary);
    }

    protected void validate(long phoneId, long companyId, long classNameId, long classPK, boolean primary) throws SystemException {
        if (primary) {
            for (Phone phone : this.phonePersistence.findByC_C_C_P(companyId, classNameId, classPK, primary)) {
                if (phoneId > 0L && phone.getPhoneId() == phoneId) continue;
                phone.setPrimary(false);
                this.phonePersistence.update((BaseModel)phone, false);
            }
        }
    }
}

