/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchPermissionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.OrgGroupPermission;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Permission;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.ResourceCode;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.permission.PermissionCheckerBag;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.base.PermissionLocalServiceBaseImpl;
import com.liferay.portal.service.persistence.OrgGroupPermissionPK;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.comparator.PermissionComparator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionLocalServiceImpl
extends PermissionLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(PermissionLocalServiceImpl.class);

    public Permission addPermission(long companyId, String actionId, long resourceId) throws SystemException {
        Permission permission = this.permissionPersistence.fetchByA_R(actionId, resourceId);
        if (permission == null) {
            long permissionId = this.counterLocalService.increment(Permission.class.getName());
            permission = this.permissionPersistence.create(permissionId);
            permission.setCompanyId(companyId);
            permission.setActionId(actionId);
            permission.setResourceId(resourceId);
            this.permissionPersistence.update((BaseModel)permission, false);
        }
        return permission;
    }

    public List<Permission> addPermissions(long companyId, List<String> actionIds, long resourceId) throws SystemException {
        List permissions = this.permissionPersistence.findByResourceId(resourceId);
        permissions = ListUtil.copy((List)permissions);
        HashSet<String> actionIdsSet = new HashSet<String>();
        for (Permission permission : permissions) {
            actionIdsSet.add(permission.getActionId());
        }
        for (String actionId : actionIds) {
            Permission permission;
            block5: {
                if (actionIdsSet.contains(actionId)) continue;
                long permissionId = this.counterLocalService.increment(Permission.class.getName());
                permission = this.permissionPersistence.create(permissionId);
                permission.setCompanyId(companyId);
                permission.setActionId(actionId);
                permission.setResourceId(resourceId);
                try {
                    this.permissionPersistence.update((BaseModel)permission, false);
                }
                catch (SystemException se) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Add failed, fetch {actionId=" + actionId + ", resourceId=" + resourceId + "}"));
                    }
                    if ((permission = this.permissionPersistence.fetchByA_R(actionId, resourceId, false)) != null) break block5;
                    throw se;
                }
            }
            permissions.add(permission);
        }
        return permissions;
    }

    public List<Permission> addPermissions(long companyId, String name, long resourceId, boolean portletActions) throws SystemException {
        List actionIds = null;
        actionIds = portletActions ? ResourceActionsUtil.getPortletResourceActions((String)name) : ResourceActionsUtil.getModelResourceActions((String)name);
        return this.addPermissions(companyId, actionIds, resourceId);
    }

    public void addUserPermissions(long userId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        List<Permission> permissions = this.permissionFinder.findByU_R(userId, resourceId);
        permissions = this.getPermissions(user.getCompanyId(), actionIds, resourceId);
        this.userPersistence.addPermissions(userId, permissions);
        PermissionCacheUtil.clearCache();
    }

    public void checkPermissions(String name, List<String> actionIds) throws PortalException, SystemException {
        List resources = this.resourceFinder.findByN_S(name, 4);
        for (Resource resource : resources) {
            for (String actionId : actionIds) {
                Permission permission = this.permissionPersistence.fetchByA_R(actionId, resource.getResourceId());
                if (permission != null) continue;
                this.checkPermission(resource, actionId);
            }
        }
        PermissionCacheUtil.clearCache();
    }

    public List<String> getActions(List<Permission> permissions) {
        ArrayList<String> actionIds = new ArrayList<String>();
        for (Permission permission : permissions) {
            actionIds.add(permission.getActionId());
        }
        return actionIds;
    }

    public List<Permission> getGroupPermissions(long groupId, long resourceId) throws SystemException {
        return this.permissionFinder.findByG_R(groupId, resourceId);
    }

    public List<Permission> getGroupPermissions(long groupId, long companyId, String name, int scope, String primKey) throws SystemException {
        return this.permissionFinder.findByG_C_N_S_P(groupId, companyId, name, scope, primKey);
    }

    public long getLatestPermissionId() throws SystemException {
        List permissions = this.permissionPersistence.findAll(0, 1, (OrderByComparator)new PermissionComparator());
        if (permissions.size() == 0) {
            return 0L;
        }
        Permission permission = (Permission)permissions.get(0);
        return permission.getPermissionId();
    }

    public List<Permission> getOrgGroupPermissions(long organizationId, long groupId, long resourceId) throws SystemException {
        return this.permissionFinder.findByO_G_R(organizationId, groupId, resourceId);
    }

    public List<Permission> getPermissions(long companyId, String[] actionIds, long resourceId) throws SystemException {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        String[] stringArray = actionIds;
        int n = actionIds.length;
        int n2 = 0;
        while (n2 < n) {
            String actionId = stringArray[n2];
            Permission permission = this.addPermission(companyId, actionId, resourceId);
            permissions.add(permission);
            ++n2;
        }
        return permissions;
    }

    public List<Permission> getRolePermissions(long roleId) throws SystemException {
        return this.rolePersistence.getPermissions(roleId);
    }

    public List<Permission> getRolePermissions(long roleId, int[] scopes) throws SystemException {
        return this.permissionFinder.findByR_S(roleId, scopes);
    }

    public List<Permission> getRolePermissions(long roleId, long resourceId) throws SystemException {
        return this.permissionFinder.findByR_R(roleId, resourceId);
    }

    public List<Permission> getUserPermissions(long userId) throws SystemException {
        return this.userPersistence.getPermissions(userId);
    }

    public List<Permission> getUserPermissions(long userId, long resourceId) throws SystemException {
        return this.permissionFinder.findByU_R(userId, resourceId);
    }

    public List<Permission> getUserPermissions(long userId, long companyId, String name, int scope, String primKey) throws SystemException {
        return this.permissionFinder.findByU_C_N_S_P(userId, companyId, name, scope, primKey);
    }

    public boolean hasGroupPermission(long groupId, String actionId, long resourceId) throws SystemException {
        Permission permission = this.permissionPersistence.fetchByA_R(actionId, resourceId);
        if (permission == null) {
            return false;
        }
        return this.groupPersistence.containsPermission(groupId, permission.getPermissionId());
    }

    public boolean hasRolePermission(long roleId, long companyId, String name, int scope, String actionId) throws SystemException {
        ResourceCode resourceCode = this.resourceCodeLocalService.getResourceCode(companyId, name, scope);
        return this.permissionFinder.countByR_A_C(roleId, actionId, resourceCode.getCodeId()) > 0;
    }

    public boolean hasRolePermission(long roleId, long companyId, String name, int scope, String primKey, String actionId) throws SystemException {
        ResourceCode resourceCode = this.resourceCodeLocalService.getResourceCode(companyId, name, scope);
        Resource resource = this.resourcePersistence.fetchByC_P(resourceCode.getCodeId(), primKey);
        if (resource == null) {
            return false;
        }
        Permission permission = this.permissionPersistence.fetchByA_R(actionId, resource.getResourceId());
        if (permission == null) {
            return false;
        }
        return this.rolePersistence.containsPermission(roleId, permission.getPermissionId());
    }

    public boolean hasUserPermission(long userId, String actionId, long resourceId) throws SystemException {
        Permission permission = this.permissionPersistence.fetchByA_R(actionId, resourceId);
        if (permission == null) {
            return false;
        }
        return this.userPersistence.containsPermission(userId, permission.getPermissionId());
    }

    public boolean hasUserPermissions(long userId, long groupId, List<Resource> resources, String actionId, PermissionCheckerBag permissionCheckerBag) throws PortalException, SystemException {
        StopWatch stopWatch = null;
        if (_log.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        int block = 1;
        if (Validator.isNull((String)actionId) || resources.isEmpty()) {
            return false;
        }
        long[] resourceIds = null;
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 6) {
            resourceIds = new long[resources.size()];
            int i = 0;
            while (i < resources.size()) {
                Resource resource = resources.get(i);
                resourceIds[i] = resource.getResourceId();
                ++i;
            }
        }
        List permissions = null;
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 6 && (permissions = this.permissionFinder.findByA_R(actionId, resourceIds)).size() == 0) {
            return false;
        }
        long resourceId = 0L;
        resourceId = PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 6 ? resourceIds[0] : resources.get(0).getResourceId();
        this.logHasUserPermissions(userId, resourceId, actionId, stopWatch, block++);
        List groups = permissionCheckerBag.getGroups();
        List roles = permissionCheckerBag.getRoles();
        this.logHasUserPermissions(userId, resourceId, actionId, stopWatch, block++);
        this.logHasUserPermissions(userId, resourceId, actionId, stopWatch, block++);
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 1) {
            return this.hasUserPermissions_1(userId, resourceId, actionId, permissions, groups, groupId, stopWatch, block);
        }
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 2) {
            return this.hasUserPermissions_2(userId, resourceId, actionId, permissions, groups, groupId, stopWatch, block);
        }
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 3) {
            return this.hasUserPermissions_3(userId, resourceId, actionId, permissions, groups, roles, stopWatch, block);
        }
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 4) {
            return this.hasUserPermissions_4(userId, resourceId, actionId, permissions, groups, roles, stopWatch, block);
        }
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            return this.hasUserPermissions_5(userId, resourceId, actionId, permissions, roles, stopWatch, block);
        }
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            return this.hasUserPermissions_6(userId, resourceId, resources, actionId, permissionCheckerBag.getRoleIds(), stopWatch, block);
        }
        return false;
    }

    public void setContainerResourcePermissions(String name, String roleName, String actionId) throws PortalException, SystemException {
        List companies = this.companyPersistence.findAll();
        for (Company company : companies) {
            this.setContainerResourcePermissions(company.getCompanyId(), name, roleName, actionId);
        }
    }

    public void setGroupPermissions(long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        List<Permission> permissions = this.permissionFinder.findByG_R(groupId, resourceId);
        for (Permission permission : permissions) {
            this.groupPersistence.removePermission(groupId, permission);
        }
        permissions = this.getPermissions(group.getCompanyId(), actionIds, resourceId);
        this.groupPersistence.addPermissions(groupId, permissions);
        PermissionCacheUtil.clearCache();
    }

    public void setGroupPermissions(String className, String classPK, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        long associatedGroupId = 0L;
        if (className.equals(Organization.class.getName())) {
            long organizationId = GetterUtil.getLong((String)classPK);
            Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
            this.orgGroupPermissionFinder.removeByO_G_R(organizationId, groupId, resourceId);
            associatedGroupId = organization.getGroup().getGroupId();
        } else if (className.equals(UserGroup.class.getName())) {
            long userGroupId = GetterUtil.getLong((String)classPK);
            UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
            associatedGroupId = userGroup.getGroup().getGroupId();
        }
        this.setGroupPermissions(associatedGroupId, actionIds, resourceId);
    }

    public void setOrgGroupPermissions(long organizationId, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        long orgGroupId = organization.getGroup().getGroupId();
        List<Permission> permissions = this.permissionPersistence.findByResourceId(resourceId);
        for (Permission permission : permissions) {
            this.groupPersistence.removePermission(orgGroupId, permission);
        }
        permissions = this.getPermissions(organization.getCompanyId(), actionIds, resourceId);
        this.orgGroupPermissionFinder.removeByO_G_R(organizationId, groupId, resourceId);
        for (Permission permission : permissions) {
            OrgGroupPermissionPK pk = new OrgGroupPermissionPK(organizationId, groupId, permission.getPermissionId());
            OrgGroupPermission orgGroupPermission = this.orgGroupPermissionPersistence.create(pk);
            this.orgGroupPermissionPersistence.update((BaseModel)orgGroupPermission, false);
        }
        PermissionCacheUtil.clearCache();
    }

    public void setRolePermission(long roleId, long companyId, String name, int scope, String primKey, String actionId) throws PortalException, SystemException {
        if (scope == 1) {
            this.unsetRolePermissions(roleId, companyId, name, 2, actionId);
        } else if (scope == 2) {
            this.unsetRolePermissions(roleId, companyId, name, 1, actionId);
        } else if (scope == 4) {
            throw new NoSuchPermissionException();
        }
        Resource resource = this.resourceLocalService.addResource(companyId, name, scope, primKey);
        long resourceId = resource.getResourceId();
        Permission permission = this.permissionPersistence.fetchByA_R(actionId, resourceId);
        if (permission == null) {
            long permissionId = this.counterLocalService.increment(Permission.class.getName());
            permission = this.permissionPersistence.create(permissionId);
            permission.setCompanyId(companyId);
            permission.setActionId(actionId);
            permission.setResourceId(resourceId);
            this.permissionPersistence.update((BaseModel)permission, false);
        }
        this.rolePersistence.addPermission(roleId, permission);
        PermissionCacheUtil.clearCache();
        SearchEngineUtil.updatePermissionFields((long)resourceId);
    }

    public void setRolePermissions(long roleId, long companyId, String name, int scope, String primKey, String[] actionIds) throws PortalException, SystemException {
        String[] stringArray = actionIds;
        int n = actionIds.length;
        int n2 = 0;
        while (n2 < n) {
            String actionId = stringArray[n2];
            this.setRolePermission(roleId, companyId, name, scope, primKey, actionId);
            ++n2;
        }
    }

    public void setRolePermissions(long roleId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        List<Permission> permissions = this.permissionFinder.findByR_R(roleId, resourceId);
        this.rolePersistence.removePermissions(roleId, (List)permissions);
        permissions = this.getPermissions(role.getCompanyId(), actionIds, resourceId);
        this.rolePersistence.addPermissions(roleId, permissions);
        PermissionCacheUtil.clearCache();
        SearchEngineUtil.updatePermissionFields((long)resourceId);
    }

    public void setRolesPermissions(long companyId, Map<Long, String[]> roleIdsToActionIds, long resourceId) throws SystemException {
        boolean flushEnabled = PermissionThreadLocal.isFlushEnabled();
        PermissionThreadLocal.setIndexEnabled((boolean)false);
        try {
            for (Map.Entry<Long, String[]> entry : roleIdsToActionIds.entrySet()) {
                long roleId = entry.getKey();
                String[] actionIds = entry.getValue();
                List<Permission> permissions = this.permissionFinder.findByR_R(roleId, resourceId);
                this.rolePersistence.removePermissions(roleId, (List)permissions);
                permissions = this.getPermissions(companyId, actionIds, resourceId);
                this.rolePersistence.addPermissions(roleId, permissions);
            }
        }
        finally {
            PermissionThreadLocal.setIndexEnabled((boolean)flushEnabled);
            PermissionCacheUtil.clearCache();
            SearchEngineUtil.updatePermissionFields((long)resourceId);
        }
    }

    public void setRolesPermissions(long companyId, Map<Long, String[]> roleIdsToActionIds, String name, int scope, String primKey) throws SystemException {
        Resource resource = this.resourceLocalService.fetchResource(companyId, name, scope, String.valueOf(primKey));
        if (resource == null) {
            resource = this.resourceLocalService.addResource(companyId, name, scope, String.valueOf(primKey));
        }
        if (resource == null) {
            return;
        }
        this.setRolesPermissions(companyId, roleIdsToActionIds, resource.getResourceId());
    }

    public void setUserPermissions(long userId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        List<Permission> permissions = this.permissionFinder.findByU_R(userId, resourceId);
        this.userPersistence.removePermissions(userId, (List)permissions);
        permissions = this.getPermissions(user.getCompanyId(), actionIds, resourceId);
        this.userPersistence.addPermissions(userId, permissions);
        PermissionCacheUtil.clearCache();
    }

    public void unsetRolePermission(long roleId, long permissionId) throws SystemException {
        Permission permission = this.permissionPersistence.fetchByPrimaryKey(permissionId);
        if (permission != null) {
            this.rolePersistence.removePermission(roleId, permission);
        }
        PermissionCacheUtil.clearCache();
    }

    public void unsetRolePermission(long roleId, long companyId, String name, int scope, String primKey, String actionId) throws SystemException {
        Permission permission;
        ResourceCode resourceCode = this.resourceCodeLocalService.getResourceCode(companyId, name, scope);
        Resource resource = this.resourcePersistence.fetchByC_P(resourceCode.getCodeId(), primKey);
        if (resource != null && (permission = this.permissionPersistence.fetchByA_R(actionId, resource.getResourceId())) != null) {
            this.rolePersistence.removePermission(roleId, permission);
        }
        PermissionCacheUtil.clearCache();
    }

    public void unsetRolePermissions(long roleId, long companyId, String name, int scope, String actionId) throws SystemException {
        ResourceCode resourceCode = this.resourceCodeLocalService.getResourceCode(companyId, name, scope);
        List permissions = this.permissionFinder.findByA_C(actionId, resourceCode.getCodeId());
        for (Permission permission : permissions) {
            this.rolePersistence.removePermission(roleId, permission);
        }
        PermissionCacheUtil.clearCache();
    }

    public void unsetUserPermissions(long userId, String[] actionIds, long resourceId) throws SystemException {
        List permissions = this.permissionFinder.findByU_A_R(userId, actionIds, resourceId);
        this.userPersistence.removePermissions(userId, permissions);
        PermissionCacheUtil.clearCache();
    }

    protected void addRolePermissions(String roleName, Permission permission) throws SystemException {
        List roles = this.rolePersistence.findByName(roleName);
        for (Role role : roles) {
            this.rolePersistence.addPermission(role.getRoleId(), permission);
        }
    }

    protected boolean checkOrgGroupPermission(List<Organization> organizations, List<Group> groups, List<Permission> permissions) throws PortalException, SystemException {
        for (Permission permission : permissions) {
            if (!this.checkOrgGroupPermission(organizations, groups, permission)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkOrgGroupPermission(List<Organization> organizations, List<Group> groups, Permission permission) throws PortalException, SystemException {
        if (organizations.size() == 0 || groups.size() == 0) {
            return false;
        }
        List orgGroupPermissions = this.orgGroupPermissionPersistence.findByPermissionId(permission.getPermissionId());
        if (orgGroupPermissions.size() == 0) {
            return false;
        }
        for (OrgGroupPermission orgGroupPermission : orgGroupPermissions) {
            if (!orgGroupPermission.containsOrganization(organizations) || !orgGroupPermission.containsGroup(groups)) continue;
            return true;
        }
        throw new NoSuchPermissionException("User has a permission in OrgGroupPermission that does not match");
    }

    protected void checkPermission(Resource resource, String actionId) throws PortalException, SystemException {
        List guestDefaultActions;
        long permissionId = this.counterLocalService.increment(Permission.class.getName());
        Permission permission = this.permissionPersistence.create(permissionId);
        permission.setCompanyId(resource.getCompanyId());
        permission.setActionId(actionId);
        permission.setResourceId(resource.getResourceId());
        this.permissionPersistence.update((BaseModel)permission, false);
        List groupDefaultActions = ResourceActionsUtil.getModelResourceGroupDefaultActions((String)resource.getName());
        if (groupDefaultActions.contains(actionId)) {
            this.addRolePermissions("Site Member", permission);
        }
        if ((guestDefaultActions = ResourceActionsUtil.getModelResourceGuestDefaultActions((String)resource.getName())).contains(actionId)) {
            this.addRolePermissions("Guest", permission);
        }
        this.addRolePermissions("Owner", permission);
        SearchEngineUtil.updatePermissionFields((long)resource.getResourceId());
    }

    protected boolean hasUserPermissions_1(long userId, long resourceId, String actionId, List<Permission> permissions, List<Group> groups, long groupId, StopWatch stopWatch, int block) throws SystemException {
        if (groups.size() > 0 && this.permissionFinder.countByGroupsRoles(permissions, groups) > 0) {
            return true;
        }
        this.logHasUserPermissions(userId, resourceId, actionId, stopWatch, block++);
        if (groups.size() > 0 && this.permissionFinder.countByGroupsPermissions(permissions, groups) > 0) {
            return true;
        }
        this.logHasUserPermissions(userId, resourceId, actionId, stopWatch, block++);
        if (this.permissionFinder.countByUsersRoles(permissions, userId) > 0) {
            return true;
        }
        this.logHasUserPermissions(userId, resourceId, actionId, stopWatch, block++);
        if (this.permissionFinder.countByUserGroupRole(permissions, userId, groupId) > 0) {
            return true;
        }
        this.logHasUserPermissions(userId, resourceId, actionId, stopWatch, block++);
        if (this.permissionFinder.countByUsersPermissions(permissions, userId) > 0) {
            return true;
        }
        this.logHasUserPermissions(userId, resourceId, actionId, stopWatch, block++);
        return false;
    }

    protected boolean hasUserPermissions_2(long userId, long resourceId, String actionId, List<Permission> permissions, List<Group> groups, long groupId, StopWatch stopWatch, int block) throws SystemException {
        if (this.permissionFinder.containsPermissions_2(permissions, userId, groups, groupId)) {
            return true;
        }
        this.logHasUserPermissions(userId, resourceId, actionId, stopWatch, block++);
        return false;
    }

    protected boolean hasUserPermissions_3(long userId, long resourceId, String actionId, List<Permission> permissions, List<Group> groups, List<Role> roles, StopWatch stopWatch, int block) throws SystemException {
        if (groups.size() > 0 && this.permissionFinder.countByGroupsPermissions(permissions, groups) > 0) {
            return true;
        }
        this.logHasUserPermissions(userId, resourceId, actionId, stopWatch, block++);
        if (roles.size() > 0 && this.permissionFinder.countByRolesPermissions(permissions, roles) > 0) {
            return true;
        }
        this.logHasUserPermissions(userId, resourceId, actionId, stopWatch, block++);
        if (this.permissionFinder.countByUsersPermissions(permissions, userId) > 0) {
            return true;
        }
        this.logHasUserPermissions(userId, resourceId, actionId, stopWatch, block++);
        return false;
    }

    protected boolean hasUserPermissions_4(long userId, long resourceId, String actionId, List<Permission> permissions, List<Group> groups, List<Role> roles, StopWatch stopWatch, int block) throws SystemException {
        if (this.permissionFinder.containsPermissions_4(permissions, userId, groups, roles)) {
            return true;
        }
        this.logHasUserPermissions(userId, resourceId, actionId, stopWatch, block++);
        return false;
    }

    protected boolean hasUserPermissions_5(long userId, long resourceId, String actionId, List<Permission> permissions, List<Role> roles, StopWatch stopWatch, int block) throws SystemException {
        if (roles.size() > 0 && this.permissionFinder.countByRolesPermissions(permissions, roles) > 0) {
            return true;
        }
        this.logHasUserPermissions(userId, resourceId, actionId, stopWatch, block++);
        return false;
    }

    protected boolean hasUserPermissions_6(long userId, long resourceId, List<Resource> resources, String actionId, long[] roleIds, StopWatch stopWatch, int block) throws PortalException, SystemException {
        boolean hasUserPermissions = this.resourcePermissionLocalService.hasResourcePermission(resources, roleIds, actionId);
        this.logHasUserPermissions(userId, resourceId, actionId, stopWatch, block++);
        return hasUserPermissions;
    }

    protected void logHasUserPermissions(long userId, long resourceId, String actionId, StopWatch stopWatch, int block) {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Checking user permissions block " + block + " for " + userId + " " + resourceId + " " + actionId + " takes " + stopWatch.getTime() + " ms"));
    }

    protected void setContainerResourcePermissions(long companyId, String name, String roleName, String actionId) throws PortalException, SystemException {
        ResourceCode resourceCode = this.resourceCodePersistence.fetchByC_N_S(companyId, name, 4);
        if (resourceCode == null) {
            return;
        }
        List groups = this.groupPersistence.findByCompanyId(companyId);
        for (Group group : groups) {
            String primKey = Long.toString(group.getGroupId());
            Resource resource = this.resourcePersistence.fetchByC_P(resourceCode.getCodeId(), primKey);
            if (resource == null) continue;
            Permission permission = this.permissionPersistence.fetchByA_R(actionId, resource.getResourceId());
            if (permission == null) {
                long permissionId = this.counterLocalService.increment(Permission.class.getName());
                permission = this.permissionPersistence.create(permissionId);
                permission.setCompanyId(companyId);
                permission.setActionId(actionId);
                permission.setResourceId(resource.getResourceId());
                this.permissionPersistence.update((BaseModel)permission, false);
            }
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5 || roleName.equals("Organization User") || roleName.equals("Owner") || roleName.equals("Site Member")) {
                Role role = this.rolePersistence.findByC_N(companyId, roleName);
                this.permissionPersistence.addRole(permission.getPermissionId(), role);
                continue;
            }
            long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
            this.permissionPersistence.addUser(permission.getPermissionId(), defaultUserId);
        }
    }
}

