/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.MembershipRequestCommentsException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.MembershipRequest;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.MembershipRequestLocalServiceBaseImpl;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.SubscriptionSender;
import com.liferay.util.UniqueList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipRequestLocalServiceImpl
extends MembershipRequestLocalServiceBaseImpl {
    public MembershipRequest addMembershipRequest(long userId, long groupId, String comments, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        this.validate(comments);
        long membershipRequestId = this.counterLocalService.increment();
        MembershipRequest membershipRequest = this.membershipRequestPersistence.create(membershipRequestId);
        membershipRequest.setCompanyId(user.getCompanyId());
        membershipRequest.setUserId(userId);
        membershipRequest.setCreateDate(now);
        membershipRequest.setGroupId(groupId);
        membershipRequest.setComments(comments);
        membershipRequest.setStatusId(0);
        this.membershipRequestPersistence.update((BaseModel)membershipRequest, false);
        this.notifyGroupAdministrators(membershipRequest, serviceContext);
        return membershipRequest;
    }

    @Override
    public void deleteMembershipRequest(long membershipRequestId) throws PortalException, SystemException {
        MembershipRequest membershipRequest = this.membershipRequestPersistence.findByPrimaryKey(membershipRequestId);
        this.deleteMembershipRequest(membershipRequest);
    }

    @Override
    public void deleteMembershipRequest(MembershipRequest membershipRequest) throws SystemException {
        this.membershipRequestPersistence.remove((BaseModel)membershipRequest);
    }

    public void deleteMembershipRequests(long groupId) throws SystemException {
        List membershipRequests = this.membershipRequestPersistence.findByGroupId(groupId);
        for (MembershipRequest membershipRequest : membershipRequests) {
            this.deleteMembershipRequest(membershipRequest);
        }
    }

    public void deleteMembershipRequests(long groupId, int statusId) throws SystemException {
        List membershipRequests = this.membershipRequestPersistence.findByG_S(groupId, statusId);
        for (MembershipRequest membershipRequest : membershipRequests) {
            this.deleteMembershipRequest(membershipRequest);
        }
    }

    public void deleteMembershipRequestsByUserId(long userId) throws SystemException {
        List membershipRequests = this.membershipRequestPersistence.findByUserId(userId);
        for (MembershipRequest membershipRequest : membershipRequests) {
            this.deleteMembershipRequest(membershipRequest);
        }
    }

    @Override
    public MembershipRequest getMembershipRequest(long membershipRequestId) throws PortalException, SystemException {
        return this.membershipRequestPersistence.findByPrimaryKey(membershipRequestId);
    }

    public List<MembershipRequest> getMembershipRequests(long userId, long groupId, int statusId) throws SystemException {
        return this.membershipRequestPersistence.findByG_U_S(groupId, userId, statusId);
    }

    public boolean hasMembershipRequest(long userId, long groupId, int statusId) throws SystemException {
        List<MembershipRequest> membershipRequests = this.getMembershipRequests(userId, groupId, statusId);
        return !membershipRequests.isEmpty();
    }

    public List<MembershipRequest> search(long groupId, int status, int start, int end) throws SystemException {
        return this.membershipRequestPersistence.findByG_S(groupId, status, start, end);
    }

    public int searchCount(long groupId, int status) throws SystemException {
        return this.membershipRequestPersistence.countByG_S(groupId, status);
    }

    public void updateStatus(long replierUserId, long membershipRequestId, String replyComments, int statusId, boolean addUserToGroup, ServiceContext serviceContext) throws PortalException, SystemException {
        this.validate(replyComments);
        MembershipRequest membershipRequest = this.membershipRequestPersistence.findByPrimaryKey(membershipRequestId);
        membershipRequest.setReplyComments(replyComments);
        membershipRequest.setReplyDate(new Date());
        if (replierUserId != 0L) {
            membershipRequest.setReplierUserId(replierUserId);
        } else {
            long defaultUserId = this.userLocalService.getDefaultUserId(membershipRequest.getCompanyId());
            membershipRequest.setReplierUserId(defaultUserId);
        }
        membershipRequest.setStatusId(statusId);
        this.membershipRequestPersistence.update((BaseModel)membershipRequest, false);
        if (statusId == 1 && addUserToGroup) {
            long[] addUserIds = new long[]{membershipRequest.getUserId()};
            this.userLocalService.addGroupUsers(membershipRequest.getGroupId(), addUserIds);
        }
        if (replierUserId != 0L) {
            this.notify(membershipRequest.getUserId(), membershipRequest, "sites.email.membership.reply.subject", "sites.email.membership.reply.body", serviceContext);
        }
    }

    protected List<Long> getGroupAdministratorUserIds(long groupId) throws PortalException, SystemException {
        UniqueList userIds = new UniqueList();
        Group group = this.groupLocalService.getGroup(groupId);
        Role siteAdministratorRole = this.roleLocalService.getRole(group.getCompanyId(), "Site Administrator");
        List siteAdministratorUserGroupRoles = this.userGroupRoleLocalService.getUserGroupRolesByGroupAndRole(groupId, siteAdministratorRole.getRoleId());
        for (UserGroupRole userGroupRole : siteAdministratorUserGroupRoles) {
            userIds.add(userGroupRole.getUserId());
        }
        Role siteOwnerRole = this.rolePersistence.findByC_N(group.getCompanyId(), "Site Owner");
        List siteOwnerUserGroupRoles = this.userGroupRoleLocalService.getUserGroupRolesByGroupAndRole(groupId, siteOwnerRole.getRoleId());
        for (UserGroupRole userGroupRole : siteOwnerUserGroupRoles) {
            userIds.add(userGroupRole.getUserId());
        }
        if (!group.isOrganization()) {
            return userIds;
        }
        Role organizationAdministratorRole = this.roleLocalService.getRole(group.getCompanyId(), "Organization Administrator");
        List organizationAdminstratorUserGroupRoles = this.userGroupRoleLocalService.getUserGroupRolesByGroupAndRole(groupId, organizationAdministratorRole.getRoleId());
        for (UserGroupRole orgAdministratorUserGroupRole : organizationAdminstratorUserGroupRoles) {
            userIds.add(orgAdministratorUserGroupRole.getUserId());
        }
        Role orgOwnerRole = this.roleLocalService.getRole(group.getCompanyId(), "Organization Owner");
        List organizationOwnerUserGroupRoles = this.userGroupRoleLocalService.getUserGroupRolesByGroupAndRole(groupId, orgOwnerRole.getRoleId());
        for (UserGroupRole organizationOwnerUserGroupRole : organizationOwnerUserGroupRoles) {
            userIds.add(organizationOwnerUserGroupRole.getUserId());
        }
        return userIds;
    }

    protected void notify(long userId, MembershipRequest membershipRequest, String subjectProperty, String bodyProperty, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        User requestUser = this.userPersistence.findByPrimaryKey(membershipRequest.getUserId());
        String fromName = PrefsPropsUtil.getStringFromNames(membershipRequest.getCompanyId(), "sites.email.from.name", "admin.email.from.name");
        String fromAddress = PrefsPropsUtil.getStringFromNames(membershipRequest.getCompanyId(), "sites.email.from.address", "admin.email.from.address");
        String toName = user.getFullName();
        String toAddress = user.getEmailAddress();
        String subject = PrefsPropsUtil.getContent(membershipRequest.getCompanyId(), subjectProperty);
        String body = PrefsPropsUtil.getContent(membershipRequest.getCompanyId(), bodyProperty);
        String statusKey = null;
        statusKey = membershipRequest.getStatusId() == 1 ? "approved" : (membershipRequest.getStatusId() == 2 ? "denied" : "pending");
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setBody(body);
        subscriptionSender.setCompanyId(membershipRequest.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$COMMENTS$]", membershipRequest.getComments(), "[$REPLY_COMMENTS$]", membershipRequest.getReplyComments(), "[$REQUEST_USER_ADDRESS$]", requestUser.getEmailAddress(), "[$REQUEST_USER_NAME$]", requestUser.getFullName(), "[$STATUS$]", LanguageUtil.get((Locale)user.getLocale(), (String)statusKey), "[$USER_ADDRESS$]", user.getEmailAddress(), "[$USER_NAME$]", user.getFullName()});
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setMailId("membership_request", new Object[]{membershipRequest.getMembershipRequestId()});
        subscriptionSender.setScopeGroupId(membershipRequest.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setSubject(subject);
        subscriptionSender.setUserId(userId);
        subscriptionSender.addRuntimeSubscribers(toAddress, toName);
        subscriptionSender.flushNotificationsAsync();
    }

    protected void notifyGroupAdministrators(MembershipRequest membershipRequest, ServiceContext serviceContext) throws PortalException, SystemException {
        List<Long> userIds = this.getGroupAdministratorUserIds(membershipRequest.getGroupId());
        for (Long userId : userIds) {
            this.notify(userId, membershipRequest, "sites.email.membership.request.subject", "sites.email.membership.request.body", serviceContext);
        }
    }

    protected void validate(String comments) throws PortalException {
        if (Validator.isNull((String)comments) || Validator.isNumber((String)comments)) {
            throw new MembershipRequestCommentsException();
        }
    }
}

