/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.LayoutSetPrototypeServiceBaseImpl;
import com.liferay.portal.service.permission.LayoutSetPrototypePermissionUtil;
import com.liferay.portal.service.permission.PortalPermissionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutSetPrototypeServiceImpl
extends LayoutSetPrototypeServiceBaseImpl {
    public LayoutSetPrototype addLayoutSetPrototype(Map<Locale, String> nameMap, String description, boolean active, boolean layoutsUpdateable, ServiceContext serviceContext) throws PortalException, SystemException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_LAYOUT_PROTOTYPE");
        User user = this.getUser();
        return this.layoutSetPrototypeLocalService.addLayoutSetPrototype(user.getUserId(), user.getCompanyId(), nameMap, description, active, layoutsUpdateable, serviceContext);
    }

    public void deleteLayoutSetPrototype(long layoutSetPrototypeId) throws PortalException, SystemException {
        LayoutSetPrototypePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layoutSetPrototypeId, (String)"DELETE");
        this.layoutSetPrototypeLocalService.deleteLayoutSetPrototype(layoutSetPrototypeId);
    }

    public LayoutSetPrototype getLayoutSetPrototype(long layoutSetPrototypeId) throws PortalException, SystemException {
        LayoutSetPrototypePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layoutSetPrototypeId, (String)"VIEW");
        return this.layoutSetPrototypeLocalService.getLayoutSetPrototype(layoutSetPrototypeId);
    }

    public List<LayoutSetPrototype> search(long companyId, Boolean active, OrderByComparator obc) throws PortalException, SystemException {
        ArrayList<LayoutSetPrototype> filteredLayoutSetPrototypes = new ArrayList<LayoutSetPrototype>();
        List layoutSetPrototypes = this.layoutSetPrototypeLocalService.search(companyId, active, -1, -1, obc);
        for (LayoutSetPrototype layoutSetPrototype : layoutSetPrototypes) {
            if (!LayoutSetPrototypePermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)layoutSetPrototype.getLayoutSetPrototypeId(), (String)"VIEW")) continue;
            filteredLayoutSetPrototypes.add(layoutSetPrototype);
        }
        return filteredLayoutSetPrototypes;
    }

    public LayoutSetPrototype updateLayoutSetPrototype(long layoutSetPrototypeId, Map<Locale, String> nameMap, String description, boolean active, boolean layoutsUpdateable, ServiceContext serviceContext) throws PortalException, SystemException {
        LayoutSetPrototypePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layoutSetPrototypeId, (String)"UPDATE");
        return this.layoutSetPrototypeLocalService.updateLayoutSetPrototype(layoutSetPrototypeId, nameMap, description, active, layoutsUpdateable, serviceContext);
    }

    public LayoutSetPrototype updateLayoutSetPrototype(long layoutSetPrototypeId, String settings) throws PortalException, SystemException {
        return this.layoutSetPrototypeLocalService.updateLayoutSetPrototype(layoutSetPrototypeId, settings);
    }
}

