/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.BaseModelListener;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.service.impl.LayoutSetPrototypeLayoutListener;
import com.liferay.portal.service.persistence.LayoutSetPrototypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutSetPrototypeLayoutSetListener
extends BaseModelListener<LayoutSet> {
    private static Log _log = LogFactoryUtil.getLog(LayoutSetPrototypeLayoutListener.class);

    public void onAfterCreate(LayoutSet layoutSet) {
        this.updateLayoutSetPrototype(layoutSet);
    }

    public void onAfterRemove(LayoutSet layoutSet) {
        this.updateLayoutSetPrototype(layoutSet);
    }

    public void onAfterUpdate(LayoutSet layoutSet) {
        this.updateLayoutSetPrototype(layoutSet);
    }

    protected void updateLayoutSetPrototype(LayoutSet layoutSet) {
        try {
            Group group = layoutSet.getGroup();
            if (!group.isLayoutSetPrototype()) {
                return;
            }
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)group.getClassPK());
            layoutSetPrototype.setModifiedDate(layoutSet.getModifiedDate());
            UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
            settingsProperties.remove((Object)"merge-fail-count");
            LayoutSetPrototypeUtil.update((LayoutSetPrototype)layoutSetPrototype, (boolean)false);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }
}

