/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.LayoutSetBranchNameException;
import com.liferay.portal.NoSuchLayoutSetBranchException;
import com.liferay.portal.RequiredLayoutSetBranchException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutBranch;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.LayoutSetBranchLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutSetBranchLocalServiceImpl
extends LayoutSetBranchLocalServiceBaseImpl {
    public LayoutSetBranch addLayoutSetBranch(long userId, long groupId, boolean privateLayout, String name, String description, boolean master, long copyLayoutSetBranchId, ServiceContext serviceContext) throws PortalException, SystemException {
        LayoutSetBranch layoutSetBranch;
        block4: {
            long layoutSetBranchId;
            block3: {
                User user = this.userPersistence.findByPrimaryKey(userId);
                Date now = new Date();
                this.validate(0L, groupId, privateLayout, name, master);
                layoutSetBranchId = this.counterLocalService.increment();
                layoutSetBranch = this.layoutSetBranchPersistence.create(layoutSetBranchId);
                layoutSetBranch.setGroupId(groupId);
                layoutSetBranch.setCompanyId(user.getCompanyId());
                layoutSetBranch.setUserId(user.getUserId());
                layoutSetBranch.setUserName(user.getFullName());
                layoutSetBranch.setCreateDate(serviceContext.getCreateDate(now));
                layoutSetBranch.setModifiedDate(serviceContext.getModifiedDate(now));
                layoutSetBranch.setPrivateLayout(privateLayout);
                layoutSetBranch.setName(name);
                layoutSetBranch.setDescription(description);
                layoutSetBranch.setMaster(master);
                this.layoutSetBranchPersistence.update((BaseModel)layoutSetBranch, false);
                this.resourceLocalService.addResources(user.getCompanyId(), layoutSetBranch.getGroupId(), user.getUserId(), LayoutSetBranch.class.getName(), layoutSetBranch.getLayoutSetBranchId(), false, true, false);
                if (!layoutSetBranch.isMaster() && copyLayoutSetBranchId != 0L) break block3;
                List layouts = this.layoutPersistence.findByG_P(layoutSetBranch.getGroupId(), layoutSetBranch.getPrivateLayout());
                for (Layout layout : layouts) {
                    LayoutBranch layoutBranch = this.layoutBranchLocalService.addLayoutBranch(layoutSetBranchId, layout.getPlid(), "main-variation", "", true, serviceContext);
                    LayoutRevision lastLayoutRevision = this.layoutRevisionLocalService.fetchLastLayoutRevision(layout.getPlid(), true);
                    if (lastLayoutRevision != null) {
                        this.layoutRevisionLocalService.addLayoutRevision(userId, layoutSetBranchId, layoutBranch.getLayoutBranchId(), 0L, true, lastLayoutRevision.getPlid(), lastLayoutRevision.getLayoutRevisionId(), lastLayoutRevision.getPrivateLayout(), lastLayoutRevision.getName(), lastLayoutRevision.getTitle(), lastLayoutRevision.getDescription(), lastLayoutRevision.getKeywords(), lastLayoutRevision.getRobots(), lastLayoutRevision.getTypeSettings(), lastLayoutRevision.isIconImage(), lastLayoutRevision.getIconImageId(), lastLayoutRevision.getThemeId(), lastLayoutRevision.getColorSchemeId(), lastLayoutRevision.getWapThemeId(), lastLayoutRevision.getWapColorSchemeId(), lastLayoutRevision.getCss(), serviceContext);
                        continue;
                    }
                    this.layoutRevisionLocalService.addLayoutRevision(userId, layoutSetBranchId, layoutBranch.getLayoutBranchId(), 0L, false, layout.getPlid(), 0L, layout.getPrivateLayout(), layout.getName(), layout.getTitle(), layout.getDescription(), layout.getKeywords(), layout.getRobots(), layout.getTypeSettings(), layout.isIconImage(), layout.getIconImageId(), layout.getThemeId(), layout.getColorSchemeId(), layout.getWapThemeId(), layout.getWapColorSchemeId(), layout.getCss(), serviceContext);
                }
                break block4;
            }
            if (copyLayoutSetBranchId <= 0L) break block4;
            List layoutRevisions = this.layoutRevisionLocalService.getLayoutRevisions(copyLayoutSetBranchId, true);
            for (LayoutRevision layoutRevision : layoutRevisions) {
                LayoutBranch layoutBranch = this.layoutBranchLocalService.addLayoutBranch(layoutSetBranchId, layoutRevision.getPlid(), "main-variation", "", true, serviceContext);
                this.layoutRevisionLocalService.addLayoutRevision(userId, layoutSetBranchId, layoutBranch.getLayoutBranchId(), 0L, true, layoutRevision.getPlid(), layoutRevision.getLayoutRevisionId(), layoutRevision.getPrivateLayout(), layoutRevision.getName(), layoutRevision.getTitle(), layoutRevision.getDescription(), layoutRevision.getKeywords(), layoutRevision.getRobots(), layoutRevision.getTypeSettings(), layoutRevision.isIconImage(), layoutRevision.getIconImageId(), layoutRevision.getThemeId(), layoutRevision.getColorSchemeId(), layoutRevision.getWapThemeId(), layoutRevision.getWapColorSchemeId(), layoutRevision.getCss(), serviceContext);
            }
        }
        return layoutSetBranch;
    }

    @Override
    public void deleteLayoutSetBranch(LayoutSetBranch layoutSetBranch) throws PortalException, SystemException {
        this.deleteLayoutSetBranch(layoutSetBranch, false);
    }

    public void deleteLayoutSetBranch(LayoutSetBranch layoutSetBranch, boolean includeMaster) throws PortalException, SystemException {
        if (!includeMaster && layoutSetBranch.isMaster()) {
            throw new RequiredLayoutSetBranchException();
        }
        this.layoutSetBranchPersistence.remove((BaseModel)layoutSetBranch);
        this.resourceLocalService.deleteResource(layoutSetBranch.getCompanyId(), LayoutSetBranch.class.getName(), 4, layoutSetBranch.getLayoutSetBranchId());
        this.layoutBranchLocalService.deleteLayoutSetBranchLayoutBranches(layoutSetBranch.getLayoutSetBranchId());
        this.layoutRevisionLocalService.deleteLayoutSetBranchLayoutRevisions(layoutSetBranch.getLayoutSetBranchId());
    }

    @Override
    public void deleteLayoutSetBranch(long layoutSetBranchId) throws PortalException, SystemException {
        LayoutSetBranch layoutSetBranch = this.layoutSetBranchPersistence.findByPrimaryKey(layoutSetBranchId);
        this.deleteLayoutSetBranch(layoutSetBranch);
    }

    public void deleteLayoutSetBranches(long groupId, boolean privateLayout) throws PortalException, SystemException {
        this.deleteLayoutSetBranches(groupId, privateLayout, false);
    }

    public void deleteLayoutSetBranches(long groupId, boolean privateLayout, boolean includeMaster) throws PortalException, SystemException {
        List layoutSetBranches = this.layoutSetBranchPersistence.findByG_P(groupId, privateLayout);
        for (LayoutSetBranch layoutSetBranch : layoutSetBranches) {
            this.deleteLayoutSetBranch(layoutSetBranch, includeMaster);
        }
    }

    public LayoutSetBranch getLayoutSetBranch(long groupId, boolean privateLayout, String name) throws PortalException, SystemException {
        return this.layoutSetBranchPersistence.findByG_P_N(groupId, privateLayout, name);
    }

    public List<LayoutSetBranch> getLayoutSetBranches(long groupId, boolean privateLayout) throws SystemException {
        return this.layoutSetBranchPersistence.findByG_P(groupId, privateLayout);
    }

    public LayoutSetBranch getMasterLayoutSetBranch(long groupId, boolean privateLayout) throws PortalException, SystemException {
        return this.layoutSetBranchFinder.findByMaster(groupId, privateLayout);
    }

    public LayoutSetBranch getUserLayoutSetBranch(long userId, long groupId, boolean privateLayout, long layoutSetBranchId) throws PortalException, SystemException {
        if (layoutSetBranchId <= 0L) {
            User user = this.userPersistence.findByPrimaryKey(userId);
            LayoutSet layoutSet = this.layoutSetLocalService.getLayoutSet(groupId, privateLayout);
            layoutSetBranchId = StagingUtil.getRecentLayoutSetBranchId((User)user, (long)layoutSet.getLayoutSetId());
        }
        if (layoutSetBranchId > 0L) {
            try {
                return this.getLayoutSetBranch(layoutSetBranchId);
            }
            catch (NoSuchLayoutSetBranchException noSuchLayoutSetBranchException) {}
        }
        return this.getMasterLayoutSetBranch(groupId, privateLayout);
    }

    public LayoutSetBranch mergeLayoutSetBranch(long layoutSetBranchId, long mergeLayoutSetBranchId, ServiceContext serviceContext) throws PortalException, SystemException {
        LayoutSetBranch layoutSetBranch = this.layoutSetBranchPersistence.findByPrimaryKey(layoutSetBranchId);
        List layoutRevisions = this.layoutRevisionLocalService.getLayoutRevisions(mergeLayoutSetBranchId, true);
        serviceContext.setWorkflowAction(1);
        for (LayoutRevision layoutRevision : layoutRevisions) {
            this.layoutRevisionLocalService.addLayoutRevision(layoutRevision.getUserId(), layoutSetBranch.getLayoutSetBranchId(), layoutRevision.getLayoutBranchId(), 0L, false, layoutRevision.getPlid(), layoutRevision.getLayoutRevisionId(), layoutRevision.isPrivateLayout(), layoutRevision.getName(), layoutRevision.getTitle(), layoutRevision.getDescription(), layoutRevision.getKeywords(), layoutRevision.getRobots(), layoutRevision.getTypeSettings(), layoutRevision.getIconImage(), layoutRevision.getIconImageId(), layoutRevision.getThemeId(), layoutRevision.getColorSchemeId(), layoutRevision.getWapThemeId(), layoutRevision.getWapColorSchemeId(), layoutRevision.getCss(), serviceContext);
        }
        return layoutSetBranch;
    }

    public LayoutSetBranch updateLayoutSetBranch(long layoutSetBranchId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        LayoutSetBranch layoutSetBranch = this.layoutSetBranchPersistence.findByPrimaryKey(layoutSetBranchId);
        this.validate(layoutSetBranch.getLayoutSetBranchId(), layoutSetBranch.getGroupId(), layoutSetBranch.getPrivateLayout(), name, layoutSetBranch.isMaster());
        layoutSetBranch.setName(name);
        layoutSetBranch.setDescription(description);
        this.layoutSetBranchPersistence.update((BaseModel)layoutSetBranch, false);
        return layoutSetBranch;
    }

    protected void validate(long layoutSetBranchId, long groupId, boolean privateLayout, String name, boolean master) throws PortalException, SystemException {
        if (Validator.isNull((String)name) || name.length() < 4) {
            throw new LayoutSetBranchNameException(3);
        }
        if (name.length() > 100) {
            throw new LayoutSetBranchNameException(2);
        }
        try {
            LayoutSetBranch layoutSetBranch = this.layoutSetBranchPersistence.findByG_P_N(groupId, privateLayout, name);
            if (layoutSetBranch.getLayoutSetBranchId() != layoutSetBranchId) {
                throw new LayoutSetBranchNameException(1);
            }
        }
        catch (NoSuchLayoutSetBranchException noSuchLayoutSetBranchException) {}
        if (master) {
            try {
                LayoutSetBranch masterLayoutSetBranch = this.layoutSetBranchFinder.findByMaster(groupId, privateLayout);
                if (layoutSetBranchId != masterLayoutSetBranch.getLayoutSetBranchId()) {
                    throw new LayoutSetBranchNameException(4);
                }
            }
            catch (NoSuchLayoutSetBranchException noSuchLayoutSetBranchException) {}
        }
    }
}

