/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.impl.VirtualLayout;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.service.LockLocalServiceUtil;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.persistence.LayoutSetUtil;
import com.liferay.portal.service.persistence.LayoutUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.sites.util.SitesUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.annotation.Order;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Order(value=2)
public class LayoutLocalServiceVirtualLayoutsAdvice
implements MethodInterceptor {
    private static final String _TEMP_DIR = String.valueOf(SystemProperties.get((String)"java.io.tmpdir")) + "/liferay/layout_set_prototype/";
    private static final Class<?>[] _TYPES_L = new Class[]{Long.TYPE};
    private static final Class<?>[] _TYPES_L_B_L = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE};
    private static final Class<?>[] _TYPES_L_B_L_B_I_I = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE};
    private static Log _log = LogFactoryUtil.getLog(LayoutLocalServiceVirtualLayoutsAdvice.class);

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null) {
            return methodInvocation.proceed();
        }
        Method method = methodInvocation.getMethod();
        String methodName = method.getName();
        Object[] arguments = methodInvocation.getArguments();
        Object[] parameterTypes = method.getParameterTypes();
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        if (methodName.equals("getLayout") && (Arrays.equals(parameterTypes, _TYPES_L) || Arrays.equals(parameterTypes, _TYPES_L_B_L))) {
            Layout layout = (Layout)methodInvocation.proceed();
            if (Validator.isNull((String)layout.getSourcePrototypeLayoutUuid())) {
                return layout;
            }
            Group group = layout.getGroup();
            LayoutSet layoutSet = layout.getLayoutSet();
            try {
                MergeLayoutPrototypesThreadLocal.setInProgress((boolean)true);
                WorkflowThreadLocal.setEnabled((boolean)false);
                this.mergeLayoutProtypeLayout(group, layout);
                this.mergeLayoutSetProtypeLayouts(group, layoutSet);
            }
            finally {
                MergeLayoutPrototypesThreadLocal.setInProgress((boolean)false);
                WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
            }
        }
        if (methodName.equals("getLayouts") && (Arrays.equals(parameterTypes, _TYPES_L_B_L) || Arrays.equals(parameterTypes, _TYPES_L_B_L_B_I_I))) {
            long groupId = (Long)arguments[0];
            boolean privateLayout = (Boolean)arguments[1];
            long parentLayoutId = (Long)arguments[2];
            try {
                Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
                try {
                    MergeLayoutPrototypesThreadLocal.setInProgress((boolean)true);
                    WorkflowThreadLocal.setEnabled((boolean)false);
                    this.mergeLayoutSetProtypeLayouts(group, layoutSet);
                }
                finally {
                    MergeLayoutPrototypesThreadLocal.setInProgress((boolean)false);
                    WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
                }
                if (!PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE && group.isUser() && parentLayoutId == 0L) {
                    Object returnValue = methodInvocation.proceed();
                    return this.addUserGroupLayouts(group, layoutSet, (List)returnValue);
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                throw e;
            }
        }
        return methodInvocation.proceed();
    }

    protected List<Layout> addUserGroupLayouts(Group group, LayoutSet layoutSet, List<Layout> layouts) throws Exception {
        layouts = ListUtil.copy(layouts);
        List userUserGroups = UserGroupLocalServiceUtil.getUserUserGroups((long)group.getClassPK());
        for (UserGroup userGroup : userUserGroups) {
            Group userGroupGroup = userGroup.getGroup();
            List userGroupLayouts = LayoutLocalServiceUtil.getLayouts((long)userGroupGroup.getGroupId(), (boolean)layoutSet.isPrivateLayout());
            for (Layout userGroupLayout : userGroupLayouts) {
                VirtualLayout virtualLayout = new VirtualLayout(userGroupLayout, group);
                layouts.add(virtualLayout);
            }
        }
        return layouts;
    }

    protected Map<String, String[]> getLayoutTemplatesParameters(boolean firstTime) {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        parameterMap.put("CATEGORIES", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("DELETE_PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("IGNORE_LAST_PUBLISH_DATE", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("LAYOUT_SET_PROTOTYPE_LINK_ENABLED", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("LAYOUTS_IMPORT_MODE", new String[]{"CREATED_FROM_PROTOTYPE"});
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_ARCHIVED_SETUPS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("THEME", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("THEME_REFERENCE", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("UPDATE_LAST_PUBLISH_DATE", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("USER_ID_STRATEGY", new String[]{"CURRENT_USER_ID"});
        if (firstTime) {
            parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR"});
            parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
            parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        } else {
            parameterMap.put("PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
            parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.FALSE.toString()});
        }
        return parameterMap;
    }

    protected void importLayoutSetPrototype(LayoutSetPrototype layoutSetPrototype, long groupId, boolean privateLayout, Map<String, String[]> parameterMap) throws PortalException, SystemException {
        File file = null;
        File cacheFile = new File(_TEMP_DIR.concat(layoutSetPrototype.getUuid()).concat(".lar"));
        if (cacheFile.exists()) {
            Date modifiedDate = layoutSetPrototype.getModifiedDate();
            if (cacheFile.lastModified() >= modifiedDate.getTime()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Using cached layout set prototype LAR file " + cacheFile.getAbsolutePath()));
                }
                file = cacheFile;
            }
        }
        boolean newFile = false;
        if (file == null) {
            Group layoutSetPrototypeGroup = layoutSetPrototype.getGroup();
            file = LayoutLocalServiceUtil.exportLayoutsAsFile((long)layoutSetPrototypeGroup.getGroupId(), (boolean)true, null, parameterMap, null, null);
            newFile = true;
        }
        long userId = UserLocalServiceUtil.getDefaultUserId((long)layoutSetPrototype.getCompanyId());
        LayoutLocalServiceUtil.importLayouts((long)userId, (long)groupId, (boolean)privateLayout, parameterMap, (File)file);
        if (newFile) {
            try {
                FileUtil.copyFile((File)file, (File)cacheFile);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Copied " + file.getAbsolutePath() + " to " + cacheFile.getAbsolutePath()));
                }
            }
            catch (Exception e) {
                _log.error((Object)("Unable to copy file " + file.getAbsolutePath() + " to " + cacheFile.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    protected void mergeLayoutProtypeLayout(Group group, Layout layout) throws Exception {
        String owner;
        int mergeFailCount;
        UnicodeProperties prototypeTypeSettingsProperties;
        LayoutPrototype layoutPrototype;
        Layout layoutPrototypeLayout;
        block12: {
            Date modifiedDate;
            if (!layout.isLayoutPrototypeLinkActive() || group.isLayoutPrototype() || group.isLayoutSetPrototype() || group.hasStagingGroup()) {
                return;
            }
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            long lastMergeTime = GetterUtil.getLong((String)typeSettingsProperties.getProperty("last-merge-time"));
            if (lastMergeTime >= (modifiedDate = (layoutPrototypeLayout = (layoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototypeByUuid((String)layout.getLayoutPrototypeUuid())).getLayout()).getModifiedDate()).getTime()) {
                return;
            }
            prototypeTypeSettingsProperties = layoutPrototypeLayout.getTypeSettingsProperties();
            mergeFailCount = GetterUtil.getInteger((String)prototypeTypeSettingsProperties.getProperty("merge-fail-count"));
            if (mergeFailCount > PropsValues.LAYOUT_PROTOTYPE_MERGE_FAIL_THRESHOLD) {
                return;
            }
            owner = PortalUUIDUtil.generate();
            try {
                Lock lock = LockLocalServiceUtil.lock((String)LayoutLocalServiceVirtualLayoutsAdvice.class.getName(), (String)String.valueOf(layout.getPlid()), (String)owner, (boolean)false);
                if (owner.equals(lock.getOwner())) break block12;
                Date createDate = lock.getCreateDate();
                if (System.currentTimeMillis() - createDate.getTime() >= PropsValues.LAYOUT_PROTOTYPE_MERGE_LOCK_MAX_TIME) {
                    lock = LockLocalServiceUtil.lock((String)LayoutLocalServiceVirtualLayoutsAdvice.class.getName(), (String)String.valueOf(layout.getPlid()), (String)lock.getOwner(), (String)owner, (boolean)false);
                    if (!owner.equals(lock.getOwner())) {
                        return;
                    }
                    break block12;
                }
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        try {
            try {
                SitesUtil.applyLayoutPrototype(layoutPrototype, layout, true);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                prototypeTypeSettingsProperties.setProperty("merge-fail-count", String.valueOf(++mergeFailCount));
                LayoutUtil.updateImpl((Layout)layoutPrototypeLayout, (boolean)false);
                LockLocalServiceUtil.unlock((String)LayoutLocalServiceVirtualLayoutsAdvice.class.getName(), (String)String.valueOf(layout.getPlid()), (String)owner, (boolean)false);
            }
        }
        finally {
            LockLocalServiceUtil.unlock((String)LayoutLocalServiceVirtualLayoutsAdvice.class.getName(), (String)String.valueOf(layout.getPlid()), (String)owner, (boolean)false);
        }
    }

    protected void mergeLayoutSetProtypeLayouts(Group group, LayoutSet layoutSet) throws Exception {
        String owner;
        int mergeFailCount;
        UnicodeProperties layoutSetPrototypeSettingsProperties;
        LayoutSet layoutSetPrototypeLayoutSet;
        LayoutSetPrototype layoutSetPrototype;
        Date modifiedDate;
        long lastMergeTime;
        UnicodeProperties settingsProperties;
        block12: {
            if (!layoutSet.isLayoutSetPrototypeLinkActive() || group.isLayoutPrototype() || group.isLayoutSetPrototype()) {
                return;
            }
            settingsProperties = layoutSet.getSettingsProperties();
            lastMergeTime = GetterUtil.getLong((String)settingsProperties.getProperty("last-merge-time"));
            if (lastMergeTime >= (modifiedDate = (layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuid((String)layoutSet.getLayoutSetPrototypeUuid())).getModifiedDate()).getTime()) {
                return;
            }
            layoutSetPrototypeLayoutSet = layoutSetPrototype.getLayoutSet();
            layoutSetPrototypeSettingsProperties = layoutSetPrototypeLayoutSet.getSettingsProperties();
            mergeFailCount = GetterUtil.getInteger((String)layoutSetPrototypeSettingsProperties.getProperty("merge-fail-count"));
            if (mergeFailCount > PropsValues.LAYOUT_SET_PROTOTYPE_MERGE_FAIL_THRESHOLD) {
                return;
            }
            owner = PortalUUIDUtil.generate();
            try {
                Lock lock = LockLocalServiceUtil.lock((String)LayoutLocalServiceVirtualLayoutsAdvice.class.getName(), (String)String.valueOf(layoutSet.getLayoutSetId()), (String)owner, (boolean)false);
                if (owner.equals(lock.getOwner())) break block12;
                Date createDate = lock.getCreateDate();
                if (System.currentTimeMillis() - createDate.getTime() >= PropsValues.LAYOUT_SET_PROTOTYPE_MERGE_LOCK_MAX_TIME) {
                    lock = LockLocalServiceUtil.lock((String)LayoutLocalServiceVirtualLayoutsAdvice.class.getName(), (String)String.valueOf(layoutSet.getLayoutSetId()), (String)lock.getOwner(), (String)owner, (boolean)false);
                    if (!owner.equals(lock.getOwner())) {
                        return;
                    }
                    break block12;
                }
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        try {
            try {
                Map<String, String[]> parameterMap = null;
                parameterMap = lastMergeTime > 0L ? this.getLayoutTemplatesParameters(false) : this.getLayoutTemplatesParameters(true);
                this.importLayoutSetPrototype(layoutSetPrototype, layoutSet.getGroupId(), layoutSet.isPrivateLayout(), parameterMap);
                settingsProperties.setProperty("last-merge-time", String.valueOf(modifiedDate.getTime()));
                LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet, (boolean)false);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                layoutSetPrototypeSettingsProperties.setProperty("merge-fail-count", String.valueOf(++mergeFailCount));
                LayoutSetUtil.updateImpl((LayoutSet)layoutSetPrototypeLayoutSet, (boolean)false);
                LockLocalServiceUtil.unlock((String)LayoutLocalServiceVirtualLayoutsAdvice.class.getName(), (String)String.valueOf(layoutSet.getLayoutSetId()), (String)owner, (boolean)false);
            }
        }
        finally {
            LockLocalServiceUtil.unlock((String)LayoutLocalServiceVirtualLayoutsAdvice.class.getName(), (String)String.valueOf(layoutSet.getLayoutSetId()), (String)owner, (boolean)false);
        }
    }
}

