/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutStagingHandler;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.impl.LayoutLocalServiceImpl;
import com.liferay.portlet.expando.model.ExpandoBridge;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.annotation.Order;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Order(value=1)
public class LayoutLocalServiceStagingAdvice
extends LayoutLocalServiceImpl
implements MethodInterceptor {
    private static Set<String> _layoutLocalServiceStagingAdviceMethodNames = new HashSet<String>();

    static {
        _layoutLocalServiceStagingAdviceMethodNames.add("deleteLayout");
        _layoutLocalServiceStagingAdviceMethodNames.add("getLayouts");
        _layoutLocalServiceStagingAdviceMethodNames.add("updateLayout");
        _layoutLocalServiceStagingAdviceMethodNames.add("updateLookAndFeel");
        _layoutLocalServiceStagingAdviceMethodNames.add("updateName");
    }

    @Override
    public void deleteLayout(Layout layout, boolean updateLayoutSet, ServiceContext serviceContext) throws PortalException, SystemException {
        long layoutSetBranchId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"layoutSetBranchId");
        if (layoutSetBranchId > 0L) {
            this.layoutRevisionLocalService.deleteLayoutRevisions(layoutSetBranchId, layout.getPlid());
            List notIncompleteLayoutRevisions = this.layoutRevisionPersistence.findByP_NotS(layout.getPlid(), 6);
            if (notIncompleteLayoutRevisions.isEmpty()) {
                this.layoutRevisionLocalService.deleteLayoutLayoutRevisions(layout.getPlid());
                super.deleteLayout(layout, updateLayoutSet, serviceContext);
            }
        } else {
            super.deleteLayout(layout, updateLayoutSet, serviceContext);
        }
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        String methodName = method.getName();
        Object[] arguments = methodInvocation.getArguments();
        boolean showIncomplete = false;
        if (!_layoutLocalServiceStagingAdviceMethodNames.contains(methodName)) {
            return this.wrapReturnValue(methodInvocation.proceed(), showIncomplete);
        }
        Object returnValue = null;
        if (methodName.equals("deleteLayout") && arguments.length == 3) {
            this.deleteLayout((Layout)arguments[0], (Boolean)arguments[1], (ServiceContext)arguments[2]);
        } else if (methodName.equals("updateLayout") && arguments.length == 15) {
            returnValue = this.updateLayout((Long)arguments[0], (Boolean)arguments[1], (Long)arguments[2], (Long)arguments[3], (Map)arguments[4], (Map)arguments[5], (Map)arguments[6], (Map)arguments[7], (Map)arguments[8], (String)arguments[9], (Boolean)arguments[10], (String)arguments[11], (Boolean)arguments[12], (byte[])arguments[13], (ServiceContext)arguments[14]);
        } else {
            if (methodName.equals("getLayouts")) {
                if (arguments.length == 6) {
                    showIncomplete = (Boolean)arguments[3];
                }
                return this.wrapReturnValue(methodInvocation.proceed(), showIncomplete);
            }
            try {
                Class<?> clazz = this.getClass();
                Method localMethod = clazz.getMethod(methodName, method.getParameterTypes());
                returnValue = localMethod.invoke((Object)this, arguments);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
            catch (NoSuchMethodException nsme) {
                throw new SystemException((Throwable)nsme);
            }
        }
        returnValue = this.wrapReturnValue(returnValue, showIncomplete);
        return returnValue;
    }

    @Override
    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, String friendlyURL, Boolean iconImage, byte[] iconBytes, ServiceContext serviceContext) throws PortalException, SystemException {
        parentLayoutId = this.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        String name = nameMap.get(LocaleUtil.getDefault());
        friendlyURL = this.getFriendlyURL(groupId, privateLayout, layoutId, "", friendlyURL);
        this.validate(groupId, privateLayout, layoutId, parentLayoutId, name, type, hidden, friendlyURL);
        this.validateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout);
        if (layoutRevision == null) {
            return super.updateLayout(groupId, privateLayout, layoutId, parentLayoutId, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURL, iconImage, iconBytes, serviceContext);
        }
        if (parentLayoutId != layout.getParentLayoutId()) {
            layout.setPriority(this.getNextPriority(groupId, privateLayout, parentLayoutId));
        }
        layout.setParentLayoutId(parentLayoutId);
        layoutRevision.setNameMap(nameMap);
        layoutRevision.setTitleMap(titleMap);
        layoutRevision.setDescriptionMap(descriptionMap);
        layoutRevision.setKeywordsMap(keywordsMap);
        layoutRevision.setRobotsMap(robotsMap);
        layout.setType(type);
        layout.setHidden(hidden);
        layout.setFriendlyURL(friendlyURL);
        if (iconImage != null) {
            long iconImageId;
            layout.setIconImage(iconImage.booleanValue());
            if (iconImage.booleanValue() && (iconImageId = layout.getIconImageId()) <= 0L) {
                iconImageId = this.counterLocalService.increment();
                layout.setIconImageId(iconImageId);
            }
        }
        this.layoutPersistence.update((BaseModel)layout, false);
        serviceContext.setWorkflowAction(2);
        this.layoutRevisionLocalService.updateLayoutRevision(serviceContext.getUserId(), layoutRevision.getLayoutRevisionId(), layoutRevision.getLayoutBranchId(), layoutRevision.getName(), layoutRevision.getTitle(), layoutRevision.getDescription(), layoutRevision.getKeywords(), layoutRevision.getRobots(), layoutRevision.getTypeSettings(), layoutRevision.getIconImage(), layoutRevision.getIconImageId(), layoutRevision.getThemeId(), layoutRevision.getColorSchemeId(), layoutRevision.getWapThemeId(), layoutRevision.getWapColorSchemeId(), layoutRevision.getCss(), serviceContext);
        if (iconImage != null && iconBytes != null && iconBytes.length > 0) {
            this.imageLocalService.updateImage(layout.getIconImageId(), iconBytes);
        }
        ExpandoBridge expandoBridge = layout.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        return this.wrapLayout(layout);
    }

    @Override
    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)(layout = this.wrapLayout(layout)));
        if (layoutRevision == null) {
            return super.updateLayout(groupId, privateLayout, layoutId, typeSettings);
        }
        layout.setTypeSettings(typeSettings);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (!MergeLayoutPrototypesThreadLocal.isInProgress()) {
            serviceContext.setWorkflowAction(2);
        }
        this.layoutRevisionLocalService.updateLayoutRevision(serviceContext.getUserId(), layoutRevision.getLayoutRevisionId(), layoutRevision.getLayoutBranchId(), layoutRevision.getName(), layoutRevision.getTitle(), layoutRevision.getDescription(), layoutRevision.getKeywords(), layoutRevision.getRobots(), layoutRevision.getTypeSettings(), layoutRevision.getIconImage(), layoutRevision.getIconImageId(), layoutRevision.getThemeId(), layoutRevision.getColorSchemeId(), layoutRevision.getWapThemeId(), layoutRevision.getWapColorSchemeId(), layoutRevision.getCss(), serviceContext);
        return layout;
    }

    @Override
    public Layout updateLookAndFeel(long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css, boolean wapTheme) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)(layout = this.wrapLayout(layout)));
        if (layoutRevision == null) {
            return super.updateLookAndFeel(groupId, privateLayout, layoutId, themeId, colorSchemeId, css, wapTheme);
        }
        if (wapTheme) {
            layout.setWapThemeId(themeId);
            layout.setWapColorSchemeId(colorSchemeId);
        } else {
            layout.setThemeId(themeId);
            layout.setColorSchemeId(colorSchemeId);
            layout.setCss(css);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (!MergeLayoutPrototypesThreadLocal.isInProgress()) {
            serviceContext.setWorkflowAction(2);
        }
        this.layoutRevisionLocalService.updateLayoutRevision(serviceContext.getUserId(), layoutRevision.getLayoutRevisionId(), layoutRevision.getLayoutBranchId(), layoutRevision.getName(), layoutRevision.getTitle(), layoutRevision.getDescription(), layoutRevision.getKeywords(), layoutRevision.getRobots(), layoutRevision.getTypeSettings(), layoutRevision.getIconImage(), layoutRevision.getIconImageId(), layoutRevision.getThemeId(), layoutRevision.getColorSchemeId(), layoutRevision.getWapThemeId(), layoutRevision.getWapColorSchemeId(), layoutRevision.getCss(), serviceContext);
        return layout;
    }

    @Override
    public Layout updateName(Layout layout, String name, String languageId) throws PortalException, SystemException {
        LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)(layout = this.wrapLayout(layout)));
        if (layoutRevision == null) {
            return super.updateName(layout, name, languageId);
        }
        this.validateName(name, languageId);
        layout.setName(name, LocaleUtil.fromLanguageId((String)languageId));
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        serviceContext.setWorkflowAction(2);
        this.layoutRevisionLocalService.updateLayoutRevision(serviceContext.getUserId(), layoutRevision.getLayoutRevisionId(), layoutRevision.getLayoutBranchId(), layoutRevision.getName(), layoutRevision.getTitle(), layoutRevision.getDescription(), layoutRevision.getKeywords(), layoutRevision.getRobots(), layoutRevision.getTypeSettings(), layoutRevision.getIconImage(), layoutRevision.getIconImageId(), layoutRevision.getThemeId(), layoutRevision.getColorSchemeId(), layoutRevision.getWapThemeId(), layoutRevision.getWapColorSchemeId(), layoutRevision.getCss(), serviceContext);
        return layout;
    }

    protected Layout unwrapLayout(Layout layout) {
        LayoutStagingHandler layoutStagingHandler = LayoutStagingUtil.getLayoutStagingHandler((Layout)layout);
        if (layoutStagingHandler == null) {
            return layout;
        }
        return layoutStagingHandler.getLayout();
    }

    protected Layout wrapLayout(Layout layout) {
        LayoutStagingHandler layoutStagingHandler = LayoutStagingUtil.getLayoutStagingHandler((Layout)layout);
        if (layoutStagingHandler != null) {
            return layout;
        }
        if (!LayoutStagingUtil.isBranchingLayout((Layout)layout)) {
            return layout;
        }
        return (Layout)ProxyUtil.newProxyInstance((ClassLoader)PortalClassLoaderUtil.getClassLoader(), (Class[])new Class[]{Layout.class}, (InvocationHandler)new LayoutStagingHandler(layout));
    }

    protected List<Layout> wrapLayouts(List<Layout> layouts, boolean showIncomplete) {
        if (layouts.isEmpty()) {
            return layouts;
        }
        Layout firstLayout = layouts.get(0);
        Layout wrappedFirstLayout = this.wrapLayout(firstLayout);
        if (wrappedFirstLayout == firstLayout) {
            return layouts;
        }
        long layoutSetBranchId = 0L;
        if (!showIncomplete) {
            try {
                long userId = GetterUtil.getLong((String)PrincipalThreadLocal.getName());
                if (userId > 0L) {
                    User user = UserLocalServiceUtil.getUser((long)userId);
                    LayoutSet layoutSet = firstLayout.getLayoutSet();
                    layoutSetBranchId = StagingUtil.getRecentLayoutSetBranchId((User)user, (long)layoutSet.getLayoutSetId());
                }
            }
            catch (Exception exception) {}
        }
        ArrayList<Layout> wrappedLayouts = new ArrayList<Layout>(layouts.size());
        int i = 0;
        while (i < layouts.size()) {
            Layout wrappedLayout = this.wrapLayout(layouts.get(i));
            if (showIncomplete || !StagingUtil.isIncomplete((Layout)wrappedLayout, (long)layoutSetBranchId)) {
                wrappedLayouts.add(wrappedLayout);
            }
            ++i;
        }
        return wrappedLayouts;
    }

    protected Object wrapReturnValue(Object returnValue, boolean showIncomplete) {
        if (returnValue instanceof Layout) {
            returnValue = this.wrapLayout((Layout)returnValue);
        } else if (returnValue instanceof List) {
            returnValue = this.wrapLayouts(returnValue, showIncomplete);
        }
        return returnValue;
    }
}

