/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.UserGroupServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserGroupServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(UserGroupServiceHttp.class);
    private static final Class<?>[] _addGroupUserGroupsParameterTypes0 = new Class[]{Long.TYPE, long[].class};
    private static final Class<?>[] _addTeamUserGroupsParameterTypes1 = new Class[]{Long.TYPE, long[].class};
    private static final Class<?>[] _addUserGroupParameterTypes2 = new Class[]{String.class, String.class};
    private static final Class<?>[] _deleteUserGroupParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getUserGroupParameterTypes4 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getUserGroupParameterTypes5 = new Class[]{String.class};
    private static final Class<?>[] _getUserUserGroupsParameterTypes6 = new Class[]{Long.TYPE};
    private static final Class<?>[] _unsetGroupUserGroupsParameterTypes7 = new Class[]{Long.TYPE, long[].class};
    private static final Class<?>[] _unsetTeamUserGroupsParameterTypes8 = new Class[]{Long.TYPE, long[].class};
    private static final Class<?>[] _updateUserGroupParameterTypes9 = new Class[]{Long.TYPE, String.class, String.class};

    public static void addGroupUserGroups(HttpPrincipal httpPrincipal, long groupId, long[] userGroupIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class.getName(), "addGroupUserGroups", (Class[])_addGroupUserGroupsParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userGroupIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void addTeamUserGroups(HttpPrincipal httpPrincipal, long teamId, long[] userGroupIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class.getName(), "addTeamUserGroups", (Class[])_addTeamUserGroupsParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{teamId, userGroupIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static UserGroup addUserGroup(HttpPrincipal httpPrincipal, String name, String description) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class.getName(), "addUserGroup", (Class[])_addUserGroupParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{name, description});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (UserGroup)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteUserGroup(HttpPrincipal httpPrincipal, long userGroupId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class.getName(), "deleteUserGroup", (Class[])_deleteUserGroupParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userGroupId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static UserGroup getUserGroup(HttpPrincipal httpPrincipal, long userGroupId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class.getName(), "getUserGroup", (Class[])_getUserGroupParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userGroupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (UserGroup)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static UserGroup getUserGroup(HttpPrincipal httpPrincipal, String name) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class.getName(), "getUserGroup", (Class[])_getUserGroupParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (UserGroup)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<UserGroup> getUserUserGroups(HttpPrincipal httpPrincipal, long userId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class.getName(), "getUserUserGroups", (Class[])_getUserUserGroupsParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetGroupUserGroups(HttpPrincipal httpPrincipal, long groupId, long[] userGroupIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class.getName(), "unsetGroupUserGroups", (Class[])_unsetGroupUserGroupsParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userGroupIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetTeamUserGroups(HttpPrincipal httpPrincipal, long teamId, long[] userGroupIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class.getName(), "unsetTeamUserGroups", (Class[])_unsetTeamUserGroupsParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{teamId, userGroupIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static UserGroup updateUserGroup(HttpPrincipal httpPrincipal, long userGroupId, String name, String description) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserGroupServiceUtil.class.getName(), "updateUserGroup", (Class[])_updateUserGroupParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userGroupId, name, description});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (UserGroup)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

