/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.GroupSoap;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.RoleSoap;
import com.liferay.portal.model.impl.GroupModelImpl;
import com.liferay.portal.service.RoleServiceUtil;
import java.rmi.RemoteException;
import java.util.List;

public class RoleServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(RoleServiceSoap.class);

    public static void addUserRoles(long userId, long[] roleIds) throws RemoteException {
        try {
            RoleServiceUtil.addUserRoles((long)userId, (long[])roleIds);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteRole(long roleId) throws RemoteException {
        try {
            RoleServiceUtil.deleteRole((long)roleId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RoleSoap[] getGroupRoles(long groupId) throws RemoteException {
        try {
            List returnValue = RoleServiceUtil.getGroupRoles((long)groupId);
            return RoleSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RoleSoap getRole(long roleId) throws RemoteException {
        try {
            Role returnValue = RoleServiceUtil.getRole((long)roleId);
            return RoleSoap.toSoapModel((Role)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RoleSoap getRole(long companyId, String name) throws RemoteException {
        try {
            Role returnValue = RoleServiceUtil.getRole((long)companyId, (String)name);
            return RoleSoap.toSoapModel((Role)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RoleSoap[] getUserGroupGroupRoles(long userId, long groupId) throws RemoteException {
        try {
            List returnValue = RoleServiceUtil.getUserGroupGroupRoles((long)userId, (long)groupId);
            return RoleSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RoleSoap[] getUserGroupRoles(long userId, long groupId) throws RemoteException {
        try {
            List returnValue = RoleServiceUtil.getUserGroupRoles((long)userId, (long)groupId);
            return RoleSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RoleSoap[] getUserRelatedRoles(long userId, GroupSoap[] groups) throws RemoteException {
        try {
            List returnValue = RoleServiceUtil.getUserRelatedRoles((long)userId, GroupModelImpl.toModels(groups));
            return RoleSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static RoleSoap[] getUserRoles(long userId) throws RemoteException {
        try {
            List returnValue = RoleServiceUtil.getUserRoles((long)userId);
            return RoleSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean hasUserRole(long userId, long companyId, String name, boolean inherited) throws RemoteException {
        try {
            boolean returnValue = RoleServiceUtil.hasUserRole((long)userId, (long)companyId, (String)name, (boolean)inherited);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean hasUserRoles(long userId, long companyId, String[] names, boolean inherited) throws RemoteException {
        try {
            boolean returnValue = RoleServiceUtil.hasUserRoles((long)userId, (long)companyId, (String[])names, (boolean)inherited);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unsetUserRoles(long userId, long[] roleIds) throws RemoteException {
        try {
            RoleServiceUtil.unsetUserRoles((long)userId, (long[])roleIds);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }
}

