/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.RoleServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(RoleServiceHttp.class);
    private static final Class<?>[] _addRoleParameterTypes0 = new Class[]{String.class, Map.class, Map.class, Integer.TYPE};
    private static final Class<?>[] _addUserRolesParameterTypes1 = new Class[]{Long.TYPE, long[].class};
    private static final Class<?>[] _deleteRoleParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getGroupRolesParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getRoleParameterTypes4 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getRoleParameterTypes5 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getUserGroupGroupRolesParameterTypes6 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getUserGroupRolesParameterTypes7 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getUserRelatedRolesParameterTypes8 = new Class[]{Long.TYPE, List.class};
    private static final Class<?>[] _getUserRolesParameterTypes9 = new Class[]{Long.TYPE};
    private static final Class<?>[] _hasUserRoleParameterTypes10 = new Class[]{Long.TYPE, Long.TYPE, String.class, Boolean.TYPE};
    private static final Class<?>[] _hasUserRolesParameterTypes11 = new Class[]{Long.TYPE, Long.TYPE, String[].class, Boolean.TYPE};
    private static final Class<?>[] _unsetUserRolesParameterTypes12 = new Class[]{Long.TYPE, long[].class};
    private static final Class<?>[] _updateRoleParameterTypes13 = new Class[]{Long.TYPE, String.class, Map.class, Map.class, String.class};

    public static Role addRole(HttpPrincipal httpPrincipal, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, int type) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "addRole", (Class[])_addRoleParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{name, titleMap, descriptionMap, type});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Role)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void addUserRoles(HttpPrincipal httpPrincipal, long userId, long[] roleIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "addUserRoles", (Class[])_addUserRolesParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, roleIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteRole(HttpPrincipal httpPrincipal, long roleId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "deleteRole", (Class[])_deleteRoleParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Role> getGroupRoles(HttpPrincipal httpPrincipal, long groupId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "getGroupRoles", (Class[])_getGroupRolesParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Role getRole(HttpPrincipal httpPrincipal, long roleId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "getRole", (Class[])_getRoleParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Role)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Role getRole(HttpPrincipal httpPrincipal, long companyId, String name) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "getRole", (Class[])_getRoleParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Role)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Role> getUserGroupGroupRoles(HttpPrincipal httpPrincipal, long userId, long groupId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "getUserGroupGroupRoles", (Class[])_getUserGroupGroupRolesParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Role> getUserGroupRoles(HttpPrincipal httpPrincipal, long userId, long groupId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "getUserGroupRoles", (Class[])_getUserGroupRolesParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Role> getUserRelatedRoles(HttpPrincipal httpPrincipal, long userId, List<Group> groups) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "getUserRelatedRoles", (Class[])_getUserRelatedRolesParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, groups});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Role> getUserRoles(HttpPrincipal httpPrincipal, long userId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "getUserRoles", (Class[])_getUserRolesParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasUserRole(HttpPrincipal httpPrincipal, long userId, long companyId, String name, boolean inherited) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "hasUserRole", (Class[])_hasUserRoleParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, companyId, name, inherited});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasUserRoles(HttpPrincipal httpPrincipal, long userId, long companyId, String[] names, boolean inherited) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "hasUserRoles", (Class[])_hasUserRolesParameterTypes11);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, companyId, names, inherited});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetUserRoles(HttpPrincipal httpPrincipal, long userId, long[] roleIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "unsetUserRoles", (Class[])_unsetUserRolesParameterTypes12);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, roleIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Role updateRole(HttpPrincipal httpPrincipal, long roleId, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String subtype) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RoleServiceUtil.class.getName(), "updateRole", (Class[])_updateRoleParameterTypes13);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId, name, titleMap, descriptionMap, subtype});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Role)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

