/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Repository;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.RepositoryServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;

public class RepositoryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(RepositoryServiceHttp.class);
    private static final Class<?>[] _addRepositoryParameterTypes0 = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE, String.class, String.class, String.class, UnicodeProperties.class, ServiceContext.class};
    private static final Class<?>[] _checkRepositoryParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _deleteRepositoryParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getLocalRepositoryImplParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getLocalRepositoryImplParameterTypes4 = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getRepositoryParameterTypes5 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getRepositoryImplParameterTypes6 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getRepositoryImplParameterTypes7 = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getSupportedConfigurationsParameterTypes8 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getSupportedParametersParameterTypes9 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getTypeSettingsPropertiesParameterTypes10 = new Class[]{Long.TYPE};
    private static final Class<?>[] _updateRepositoryParameterTypes11 = new Class[]{Long.TYPE, String.class, String.class};

    public static long addRepository(HttpPrincipal httpPrincipal, long groupId, long classNameId, long parentFolderId, String name, String description, String portletId, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class.getName(), "addRepository", (Class[])_addRepositoryParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, classNameId, parentFolderId, name, description, portletId, typeSettingsProperties, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Long)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void checkRepository(HttpPrincipal httpPrincipal, long repositoryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class.getName(), "checkRepository", (Class[])_checkRepositoryParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{repositoryId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteRepository(HttpPrincipal httpPrincipal, long repositoryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class.getName(), "deleteRepository", (Class[])_deleteRepositoryParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{repositoryId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static LocalRepository getLocalRepositoryImpl(HttpPrincipal httpPrincipal, long repositoryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class.getName(), "getLocalRepositoryImpl", (Class[])_getLocalRepositoryImplParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{repositoryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (LocalRepository)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static LocalRepository getLocalRepositoryImpl(HttpPrincipal httpPrincipal, long folderId, long fileEntryId, long fileVersionId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class.getName(), "getLocalRepositoryImpl", (Class[])_getLocalRepositoryImplParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{folderId, fileEntryId, fileVersionId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (LocalRepository)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Repository getRepository(HttpPrincipal httpPrincipal, long repositoryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class.getName(), "getRepository", (Class[])_getRepositoryParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{repositoryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Repository)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static com.liferay.portal.kernel.repository.Repository getRepositoryImpl(HttpPrincipal httpPrincipal, long repositoryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class.getName(), "getRepositoryImpl", (Class[])_getRepositoryImplParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{repositoryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (com.liferay.portal.kernel.repository.Repository)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static com.liferay.portal.kernel.repository.Repository getRepositoryImpl(HttpPrincipal httpPrincipal, long folderId, long fileEntryId, long fileVersionId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class.getName(), "getRepositoryImpl", (Class[])_getRepositoryImplParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{folderId, fileEntryId, fileVersionId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (com.liferay.portal.kernel.repository.Repository)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static String[] getSupportedConfigurations(HttpPrincipal httpPrincipal, long classNameId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class.getName(), "getSupportedConfigurations", (Class[])_getSupportedConfigurationsParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{classNameId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (String[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static String[] getSupportedParameters(HttpPrincipal httpPrincipal, long classNameId, String configuration) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class.getName(), "getSupportedParameters", (Class[])_getSupportedParametersParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{classNameId, configuration});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (String[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static UnicodeProperties getTypeSettingsProperties(HttpPrincipal httpPrincipal, long repositoryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class.getName(), "getTypeSettingsProperties", (Class[])_getTypeSettingsPropertiesParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{repositoryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (UnicodeProperties)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void updateRepository(HttpPrincipal httpPrincipal, long repositoryId, String name, String description) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(RepositoryServiceUtil.class.getName(), "updateRepository", (Class[])_updateRepositoryParameterTypes11);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{repositoryId, name, description});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

