/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.ListType;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.ListTypeServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListTypeServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(ListTypeServiceHttp.class);
    private static final Class<?>[] _getListTypeParameterTypes0 = new Class[]{Integer.TYPE};
    private static final Class<?>[] _getListTypesParameterTypes1 = new Class[]{String.class};
    private static final Class<?>[] _validateParameterTypes2 = new Class[]{Integer.TYPE, String.class};
    private static final Class<?>[] _validateParameterTypes3 = new Class[]{Integer.TYPE, Long.TYPE, String.class};

    public static ListType getListType(HttpPrincipal httpPrincipal, int listTypeId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ListTypeServiceUtil.class.getName(), "getListType", (Class[])_getListTypeParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{listTypeId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (ListType)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<ListType> getListTypes(HttpPrincipal httpPrincipal, String type) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(ListTypeServiceUtil.class.getName(), "getListTypes", (Class[])_getListTypesParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{type});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void validate(HttpPrincipal httpPrincipal, int listTypeId, String type) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ListTypeServiceUtil.class.getName(), "validate", (Class[])_validateParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{listTypeId, type});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void validate(HttpPrincipal httpPrincipal, int listTypeId, long classNameId, String type) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(ListTypeServiceUtil.class.getName(), "validate", (Class[])_validateParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{listTypeId, classNameId, type});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

