/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.service.PermissionedModelLocalService;
import com.liferay.portal.service.PersistedModelLocalService;
import com.liferay.portal.service.PersistedModelLocalServiceRegistry;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistedModelLocalServiceRegistryImpl
implements PersistedModelLocalServiceRegistry {
    private static Log _log = LogFactoryUtil.getLog(PersistedModelLocalServiceRegistryImpl.class);
    private Map<String, PersistedModelLocalService> _persistedModelLocalServices = new ConcurrentHashMap<String, PersistedModelLocalService>();

    public PersistedModelLocalService getPersistedModelLocalService(String className) {
        return this._persistedModelLocalServices.get(className);
    }

    public List<PersistedModelLocalService> getPersistedModelLocalServices() {
        return ListUtil.fromMapValues(this._persistedModelLocalServices);
    }

    public boolean isPermissionedModelLocalService(String className) {
        PersistedModelLocalService persistedModelLocalService = this.getPersistedModelLocalService(className);
        if (persistedModelLocalService == null) {
            return false;
        }
        return persistedModelLocalService instanceof PermissionedModelLocalService;
    }

    public void register(String className, PersistedModelLocalService persistedModelLocalService) {
        PersistedModelLocalService oldPersistedModelLocalService = this._persistedModelLocalServices.put(className, persistedModelLocalService);
        if (oldPersistedModelLocalService != null) {
            _log.warn((Object)("Duplicate class name " + className));
        }
    }

    public void unregister(String className) {
        this._persistedModelLocalServices.remove(className);
    }
}

