/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.lar.ImportExportThreadLocal;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionCheckerBag;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.security.permission.ResourceBlockIdsBag;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;

public class PermissionCacheUtil {
    public static final String PERMISSION_CACHE_NAME = String.valueOf(PermissionCacheUtil.class.getName()) + "_PERMISSION";
    public static final String PERMISSION_CHECKER_BAG_CACHE_NAME = String.valueOf(PermissionCacheUtil.class.getName()) + "_PERMISSION_CHECKER_BAG";
    public static final String RESOURCE_BLOCK_IDS_BAG_CACHE_NAME = String.valueOf(PermissionCacheUtil.class.getName()) + "_RESOURCE_BLOCK_IDS_BAG";
    private static ThreadLocal<LRUMap> _localCache;
    private static boolean _localCacheAvailable;
    private static PortalCache _permissionCheckerBagPortalCache;
    private static PortalCache _permissionPortalCache;
    private static PortalCache _resourceBlockIdsBagCache;

    static {
        _permissionCheckerBagPortalCache = MultiVMPoolUtil.getCache((String)PERMISSION_CHECKER_BAG_CACHE_NAME, (boolean)PropsValues.PERMISSIONS_OBJECT_BLOCKING_CACHE);
        _permissionPortalCache = MultiVMPoolUtil.getCache((String)PERMISSION_CACHE_NAME, (boolean)PropsValues.PERMISSIONS_OBJECT_BLOCKING_CACHE);
        _resourceBlockIdsBagCache = MultiVMPoolUtil.getCache((String)RESOURCE_BLOCK_IDS_BAG_CACHE_NAME, (boolean)PropsValues.PERMISSIONS_OBJECT_BLOCKING_CACHE);
        if (PropsValues.PERMISSIONS_THREAD_LOCAL_CACHE_MAX_SIZE > 0) {
            _localCache = new AutoResetThreadLocal(PermissionCacheUtil.class + "._localCache", (Object)new LRUMap(PropsValues.PERMISSIONS_THREAD_LOCAL_CACHE_MAX_SIZE));
            _localCacheAvailable = true;
        }
    }

    public static void clearCache() {
        if (ImportExportThreadLocal.isImportInProcess() || !PermissionThreadLocal.isFlushEnabled()) {
            return;
        }
        PermissionCacheUtil.clearLocalCache();
        _permissionCheckerBagPortalCache.removeAll();
        _permissionPortalCache.removeAll();
        _resourceBlockIdsBagCache.removeAll();
    }

    public static void clearLocalCache() {
        if (_localCacheAvailable) {
            Map localCache = (Map)_localCache.get();
            localCache.clear();
        }
    }

    public static PermissionCheckerBag getBag(long userId, long groupId) {
        PermissionCheckerBag bag = null;
        BagKey key = new BagKey(userId, groupId);
        if (_localCacheAvailable) {
            Map localCache = (Map)_localCache.get();
            bag = (PermissionCheckerBag)localCache.get(key);
        }
        if (bag == null) {
            bag = (PermissionCheckerBag)_permissionCheckerBagPortalCache.get((Serializable)key);
        }
        return bag;
    }

    public static Boolean getPermission(long userId, boolean signedIn, boolean checkGuest, long groupId, String name, String primKey, String actionId) {
        Boolean value = null;
        PermissionKey key = new PermissionKey(userId, signedIn, checkGuest, groupId, name, primKey, actionId);
        if (_localCacheAvailable) {
            Map localCache = (Map)_localCache.get();
            value = (Boolean)localCache.get(key);
        }
        if (value == null) {
            value = (Boolean)_permissionPortalCache.get((Serializable)key);
        }
        return value;
    }

    public static ResourceBlockIdsBag getResourceBlockIdsBag(long companyId, long userId, long groupId, String name, boolean checkGuest) {
        ResourceBlockIdsBag resourceBlockIdsBag = null;
        ResourceBlockIdsBagKey key = new ResourceBlockIdsBagKey(companyId, groupId, userId, name, checkGuest);
        if (_localCacheAvailable) {
            Map localCache = (Map)_localCache.get();
            resourceBlockIdsBag = (ResourceBlockIdsBag)localCache.get(key);
        }
        if (resourceBlockIdsBag == null) {
            resourceBlockIdsBag = (ResourceBlockIdsBag)_resourceBlockIdsBagCache.get((Serializable)key);
        }
        return resourceBlockIdsBag;
    }

    public static PermissionCheckerBag putBag(long userId, long groupId, PermissionCheckerBag bag) {
        if (bag == null) {
            return null;
        }
        BagKey key = new BagKey(userId, groupId);
        if (_localCacheAvailable) {
            Map localCache = (Map)_localCache.get();
            localCache.put(key, bag);
        }
        _permissionCheckerBagPortalCache.put((Serializable)key, (Serializable)bag);
        return bag;
    }

    public static Boolean putPermission(long userId, boolean signedIn, boolean checkGuest, long groupId, String name, String primKey, String actionId, Boolean value) {
        if (value == null) {
            return null;
        }
        PermissionKey key = new PermissionKey(userId, signedIn, checkGuest, groupId, name, primKey, actionId);
        if (_localCacheAvailable) {
            Map localCache = (Map)_localCache.get();
            localCache.put(key, value);
        }
        _permissionPortalCache.put((Serializable)key, (Serializable)value);
        return value;
    }

    public static ResourceBlockIdsBag putResourceBlockIdsBag(long companyId, long groupId, long userId, String name, boolean checkGuest, ResourceBlockIdsBag resourceBlockIdsBag) {
        if (resourceBlockIdsBag == null) {
            return null;
        }
        ResourceBlockIdsBagKey key = new ResourceBlockIdsBagKey(companyId, groupId, userId, name, checkGuest);
        if (_localCacheAvailable) {
            Map localCache = (Map)_localCache.get();
            localCache.put(key, resourceBlockIdsBag);
        }
        _resourceBlockIdsBagCache.put((Serializable)key, (Serializable)resourceBlockIdsBag);
        return resourceBlockIdsBag;
    }

    private static class BagKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long _groupId;
        private final long _userId;

        public BagKey(long userId, long groupId) {
            this._userId = userId;
            this._groupId = groupId;
        }

        public boolean equals(Object obj) {
            BagKey bagKey = (BagKey)obj;
            return bagKey._userId == this._userId && bagKey._groupId == this._groupId;
        }

        public int hashCode() {
            return (int)(this._userId * 11L + this._groupId);
        }
    }

    private static class PermissionKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String _actionId;
        private final boolean _checkGuest;
        private final long _groupId;
        private final String _name;
        private final String _primKey;
        private final boolean _signedIn;
        private final long _userId;

        public PermissionKey(long userId, boolean signedIn, boolean checkGuest, long groupId, String name, String primKey, String actionId) {
            this._userId = userId;
            this._signedIn = signedIn;
            this._checkGuest = checkGuest;
            this._groupId = groupId;
            this._name = name;
            this._primKey = primKey;
            this._actionId = actionId;
        }

        public boolean equals(Object obj) {
            PermissionKey permissionKey = (PermissionKey)obj;
            return permissionKey._userId == this._userId && permissionKey._signedIn == this._signedIn && permissionKey._checkGuest == this._checkGuest && permissionKey._groupId == this._groupId && Validator.equals((Object)permissionKey._name, (Object)this._name) && Validator.equals((Object)permissionKey._primKey, (Object)this._primKey) && Validator.equals((Object)permissionKey._actionId, (Object)this._actionId);
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (long)this._userId);
            hashCode = HashUtil.hash((int)hashCode, (boolean)this._signedIn);
            hashCode = HashUtil.hash((int)hashCode, (boolean)this._checkGuest);
            hashCode = HashUtil.hash((int)hashCode, (long)this._groupId);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._name);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._primKey);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._actionId);
            return hashCode;
        }
    }

    private static class ResourceBlockIdsBagKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean _checkGuest;
        private final long _companyId;
        private final long _groupId;
        private final String _name;
        private final long _userId;

        public ResourceBlockIdsBagKey(long companyId, long groupId, long userId, String name, boolean checkGuest) {
            this._companyId = companyId;
            this._groupId = groupId;
            this._userId = userId;
            this._name = name;
            this._checkGuest = checkGuest;
        }

        public boolean equals(Object obj) {
            ResourceBlockIdsBagKey resourceBlockIdsKey = (ResourceBlockIdsBagKey)obj;
            return resourceBlockIdsKey._companyId == this._companyId && resourceBlockIdsKey._groupId == this._groupId && resourceBlockIdsKey._userId == this._userId && resourceBlockIdsKey._checkGuest == this._checkGuest && Validator.equals((Object)resourceBlockIdsKey._name, (Object)this._name);
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (long)this._companyId);
            hashCode = HashUtil.hash((int)hashCode, (long)this._groupId);
            hashCode = HashUtil.hash((int)hashCode, (long)this._userId);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._name);
            hashCode = HashUtil.hash((int)hashCode, (boolean)this._checkGuest);
            return hashCode;
        }
    }
}

